/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld.tools;

import de.omegazirkel.risingworld.tools.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.risingworld.api.Plugin;

public class I18n {
    private Map<String, Properties> language = new HashMap<String, Properties>();
    private static final String defaultLanguage = "en";
    private Plugin plugin = null;
    private static Logger log = null;

    public I18n(Plugin plugin) {
        this.plugin = plugin;
        log = new Logger("[OZ.i18n]", 0);
        this.loadLanguageData(plugin.getPath());
    }

    public I18n(Plugin plugin, int logLevel) {
        this.plugin = plugin;
        log = new Logger("[OZ.i18n]", logLevel);
        this.loadLanguageData(this.plugin.getPath());
    }

    private void loadLanguageData(String pluginPath) {
        log.out("Loading language files from " + pluginPath + "/i18n'");
        File folder = new File(String.valueOf(pluginPath) + "/i18n");
        File[] listOfFiles = folder.listFiles();
        try {
            log.out("Files found: " + listOfFiles.length, 0);
            int i = 0;
            while (i < listOfFiles.length) {
                log.out("loading: " + listOfFiles[i].getName(), 0);
                if (listOfFiles[i].isFile() && listOfFiles[i].getName().endsWith("properties")) {
                    String lang = listOfFiles[i].getName().substring(0, 2);
                    Properties lngProperties = new Properties();
                    try {
                        FileInputStream in = new FileInputStream(listOfFiles[i]);
                        lngProperties.load(new InputStreamReader((InputStream)in, "UTF8"));
                        in.close();
                        this.language.put(lang.toLowerCase(), lngProperties);
                    }
                    catch (FileNotFoundException e) {
                        log.out("Error: " + e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        log.out("Error: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.out("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getLanguageUsed(String lang) {
        if (!this.language.containsKey(lang.toLowerCase())) {
            return "en (default Language)";
        }
        return lang;
    }

    public String getLanguageAvailable() {
        CharSequence[] keys = this.language.keySet().toArray(new String[0]);
        return String.join((CharSequence)", ", keys);
    }

    public String get(String key, String lang) {
        try {
            Properties lngDefaultProperties = this.language.get(defaultLanguage);
            Properties lngProperties = null;
            lngProperties = !this.language.containsKey(lang.toLowerCase()) ? lngDefaultProperties : this.language.get(lang.toLowerCase());
            return lngProperties.getProperty(key, lngDefaultProperties.getProperty(key, key));
        }
        catch (Exception e) {
            log.out("Error: " + e.getMessage());
            e.printStackTrace();
            return key;
        }
    }

    public String get(String key) {
        return this.get(key, defaultLanguage);
    }
}

