/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.customitems;

import java.io.File;
import net.risingworld.api.Plugin;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class CustomItemLoader
extends Plugin {
    private final String UUID = "uuid: ";
    private final String NAME = "name: ";
    private final String MODEL = "model: ";
    private final String TEXTURE = "texture: ";
    private final String ICON = "icon: ";
    private final String SIZE = "size: ";
    private final String HAND = "hand: ";
    private final String HITDEF = "hitdef: ";
    private final String HITFACTOR = "hitfactor: ";
    private final String STACKSIZE = "stack: ";
    private final String IDLEANIMATION = "idleanimation: ";
    private final String PRIMARYANIMATION = "primaryanimation: ";
    private final String SECONDARYANIMATION = "secondaryanimation: ";
    private final String PRIMARYTRIGGERDELAY = "primarytriggerdelay: ";
    private final String SECONDARYTRIGGERDELAY = "secondarytriggerdelay: ";
    private final String ITEMPOSITION = "itemposition: ";
    private final String ITEMROTATION = "itemrotation: ";
    private final String BODYPOSITION = "bodyposition: ";
    private final String BODYROTATION = "bodyrotation: ";
    private final String DESCRIPTION = "description: ";
    private final String INGREDIENTS = "ingredients: ";
    private final String CRAFTINGSTATION = "craftingstation: ";
    private final String CATEGORY = "category: ";

    public void onEnable() {
        File dir = new File(this.getPath() + "/Items/");
        if (!dir.exists()) {
            dir.mkdir();
        } else {
            File[] subfolders;
            for (File subfolder : subfolders = dir.listFiles()) {
                if (!subfolder.isDirectory()) continue;
                try {
                    ItemDef itemDef = this.loadCustomItemDefinition(subfolder);
                    if (itemDef == null) continue;
                    this.createCustomItem(itemDef);
                }
                catch (Exception e) {
                    System.err.println("Unable to load item from folder '" + subfolder.getName() + "'");
                    e.printStackTrace();
                }
            }
        }
    }

    public void onDisable() {
    }

    private void createCustomItem(ItemDef itemDef) {
        Definitions.HitDamageDefinition damageDef;
        System.out.println("CREATE CUSTOM ITEM: " + itemDef.name + "  (" + itemDef.uuid + ")");
        CustomItem item = new CustomItem(itemDef.uuid, itemDef.name);
        ModelInformation model = new ModelInformation(itemDef.model);
        ImageInformation texture = new ImageInformation(itemDef.texture);
        ImageInformation icon = new ImageInformation(itemDef.icon);
        item.setModel(model, texture, itemDef.size);
        item.setIcon(icon);
        item.setMaxStacksize(itemDef.stacksize);
        item.setPlayerIdleAnimation(itemDef.idleAnimation);
        item.setHand(itemDef.hand);
        item.setItemPosition(itemDef.itemPosition);
        item.setItemRotation(itemDef.itemRotation);
        item.setFPBodyPosition(itemDef.bodyPosition);
        item.setFPBodyRotation(itemDef.bodyRotation);
        if (itemDef.primaryAnimation != null) {
            item.setPrimaryAction(itemDef.primaryAnimation, itemDef.primaryTriggerDelay, null);
        }
        if (itemDef.secondaryAnimation != null) {
            item.setSecondaryAction(itemDef.secondaryAnimation, itemDef.secondaryTriggerDelay, null);
        }
        if (itemDef.hitDefinition != null && (damageDef = Definitions.getHitDamageDefinition((String)itemDef.hitDefinition)) != null) {
            item.setHitDamageDefinition(damageDef);
            item.setHitDamageFactor(itemDef.hitDefinitionFactor);
        }
        item.setLocalizedNames(new String[]{itemDef.name});
        this.getServer().registerCustomItem(item);
        if (itemDef.category != null) {
            CustomRecipe recipe = new CustomRecipe(itemDef.uuid, CustomRecipe.Type.CustomItem, 0, itemDef.category, new String[]{itemDef.craftingStation});
            recipe.setPreviewSize(item.getModelSize());
            recipe.setIngredients(itemDef.ingredients);
            recipe.setLocalizedNames(new String[]{item.getName()});
            recipe.setLocalizedDescriptions(new String[]{itemDef.description});
            this.getServer().registerCustomRecipe(recipe);
        }
    }

    private ItemDef loadCustomItemDefinition(File folder) {
        File definition = this.findFile("ItemDefinition.txt", folder);
        if (definition != null) {
            String content = Utils.FileUtils.readStringFromFile((File)definition);
            String[] lines = content.split("\r\n|\n|\r");
            ItemDef def = new ItemDef();
            for (String line : lines) {
                String s;
                String l = line.toLowerCase();
                if (l.startsWith("uuid: ")) {
                    def.uuid = line.substring("uuid: ".length());
                    continue;
                }
                if (l.startsWith("name: ")) {
                    def.name = line.substring("name: ".length());
                    continue;
                }
                if (l.startsWith("model: ")) {
                    def.model = new File(folder, line.substring("model: ".length()));
                    continue;
                }
                if (l.startsWith("texture: ")) {
                    def.texture = new File(folder, line.substring("texture: ".length()));
                    continue;
                }
                if (l.startsWith("icon: ")) {
                    def.icon = new File(folder, line.substring("icon: ".length()));
                    continue;
                }
                if (l.startsWith("hitdef: ")) {
                    def.hitDefinition = line.substring("hitdef: ".length());
                    continue;
                }
                if (l.startsWith("hitfactor: ")) {
                    s = line.substring("hitfactor: ".length());
                    if (!Utils.StringUtils.isNumeric((String)s)) continue;
                    def.hitDefinitionFactor = Float.parseFloat(s);
                    continue;
                }
                if (l.startsWith("size: ")) {
                    s = line.substring("size: ".length());
                    if (!Utils.StringUtils.isNumeric((String)s)) continue;
                    def.size = Float.parseFloat(s);
                    continue;
                }
                if (l.startsWith("stack: ")) {
                    s = line.substring("stack: ".length());
                    if (!Utils.StringUtils.isInteger((String)s)) continue;
                    def.stacksize = Integer.parseInt(s);
                    continue;
                }
                if (l.startsWith("hand: ")) {
                    s = line.substring("hand: ".length());
                    if (s.equalsIgnoreCase("left")) {
                        def.hand = CustomItem.Hand.Left;
                        continue;
                    }
                    if (s.equalsIgnoreCase("right")) {
                        def.hand = CustomItem.Hand.Right;
                        continue;
                    }
                    def.hand = CustomItem.Hand.None;
                    continue;
                }
                if (l.startsWith("idleanimation: ")) {
                    def.idleAnimation = Animation.valueOf((String)line.substring("idleanimation: ".length()));
                    continue;
                }
                if (l.startsWith("primaryanimation: ")) {
                    def.primaryAnimation = Animation.valueOf((String)line.substring("primaryanimation: ".length()));
                    continue;
                }
                if (l.startsWith("secondaryanimation: ")) {
                    def.secondaryAnimation = Animation.valueOf((String)line.substring("secondaryanimation: ".length()));
                    continue;
                }
                if (l.startsWith("primarytriggerdelay: ")) {
                    s = line.substring("primarytriggerdelay: ".length());
                    if (!Utils.StringUtils.isNumeric((String)s)) continue;
                    def.primaryTriggerDelay = Float.parseFloat(s);
                    continue;
                }
                if (l.startsWith("secondarytriggerdelay: ")) {
                    s = line.substring("secondarytriggerdelay: ".length());
                    if (!Utils.StringUtils.isNumeric((String)s)) continue;
                    def.secondaryTriggerDelay = Float.parseFloat(s);
                    continue;
                }
                if (l.startsWith("itemposition: ")) {
                    s = line.substring("itemposition: ".length());
                    def.itemPosition.fromString(s);
                    continue;
                }
                if (l.startsWith("itemrotation: ")) {
                    s = line.substring("itemrotation: ".length());
                    def.itemRotation.fromString(s);
                    continue;
                }
                if (l.startsWith("bodyposition: ")) {
                    s = line.substring("bodyposition: ".length());
                    def.bodyPosition.fromString(s);
                    continue;
                }
                if (l.startsWith("bodyrotation: ")) {
                    s = line.substring("bodyrotation: ".length());
                    def.bodyRotation.fromString(s);
                    continue;
                }
                if (l.startsWith("description: ")) {
                    def.description = line.substring("description: ".length());
                    continue;
                }
                if (l.startsWith("category: ")) {
                    def.category = line.substring("category: ".length());
                    continue;
                }
                if (l.startsWith("craftingstation: ")) {
                    def.craftingStation = line.substring("craftingstation: ".length()).toLowerCase();
                    continue;
                }
                if (!l.startsWith("ingredients: ")) continue;
                s = Utils.StringUtils.removeAllWhitespaces((String)line.substring("ingredients: ".length())).toLowerCase();
                def.ingredients = s.contains(",") ? s.split(",") : new String[]{s};
            }
            if (def.uuid == null || def.uuid.isEmpty()) {
                throw new IllegalStateException("UUID is not set!");
            }
            if (def.name == null || def.name.isEmpty()) {
                throw new IllegalStateException("Item name is not set!");
            }
            if (def.model == null || !def.model.exists()) {
                throw new IllegalStateException("Model info does not exist!");
            }
            if (def.texture == null || !def.texture.exists()) {
                throw new IllegalStateException("Texture info does not exist!");
            }
            if (def.icon == null || !def.icon.exists()) {
                throw new IllegalStateException("Icon info does not exist!");
            }
            return def;
        }
        return null;
    }

    private File findFile(String filename, File parent) {
        for (File f : parent.listFiles()) {
            if (f.isDirectory() || !f.getName().equalsIgnoreCase(filename)) continue;
            return f;
        }
        return null;
    }

    private class ItemDef {
        String uuid;
        String name;
        File model;
        File texture;
        File icon;
        float size = 1.0f;
        String hitDefinition;
        float hitDefinitionFactor = 1.0f;
        int stacksize = 1;
        CustomItem.Hand hand = CustomItem.Hand.Right;
        Animation idleAnimation = Animation.Weapon1HandIdle;
        Animation primaryAnimation = Animation.Weapon1HandHit3;
        Animation secondaryAnimation = null;
        float primaryTriggerDelay = 0.5f;
        float secondaryTriggerDelay = 0.5f;
        Vector3f itemPosition = new Vector3f();
        Quaternion itemRotation = new Quaternion();
        Vector3f bodyPosition = new Vector3f();
        Quaternion bodyRotation = new Quaternion();
        String category;
        String description = "";
        String craftingStation;
        String[] ingredients;

        private ItemDef() {
        }
    }
}

