/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.audio;

import net.risingworld.api.example.audio.Jukebox;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.SoundInformation;
import net.risingworld.api.utils.Vector3f;

public class MusicPlayer {
    private int id;
    private Vector3f position;
    private Jukebox plugin;
    private int currentTrack = -1;
    private long playStartTime = 0L;
    private boolean isPlaying = false;
    public static final float DEFAULT_VOLUME = 0.25f;
    public static final float MIN_RANGE = 1.0f;
    public static final float MAX_RANGE = 25.0f;
    private static final String TRACK_ATTRIBUTE = "net.risingworld.api.jukebox.track";

    public MusicPlayer(Jukebox plugin, int id, Vector3f position) {
        this.id = id;
        this.plugin = plugin;
        this.position = new Vector3f(position);
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public int getCurrentTrack() {
        return this.currentTrack;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void play(int track) {
        if (track >= 0 && track < this.plugin.musicTracks.size()) {
            this.currentTrack = track;
            this.playStartTime = System.currentTimeMillis();
            this.isPlaying = true;
            SoundInformation musicTrack = this.plugin.musicTracks.get(track);
            String attribute = this.getAttributeName();
            for (Player player : this.plugin.getServer().getAllPlayers()) {
                if (player == null || !player.isConnected()) continue;
                int soundID = player.playSound(musicTrack, true, 0.25f, 1.0f, 1.0f, 25.0f, this.position);
                player.setAttribute(attribute, (Object)soundID);
            }
        }
    }

    public void stop() {
        String attribute = this.getAttributeName();
        for (Player player : this.plugin.getServer().getAllPlayers()) {
            if (player == null || !player.isConnected() || !player.hasAttribute(attribute)) continue;
            int soundID = (Integer)player.getAttribute(attribute);
            player.stopSound(soundID);
            player.deleteAttribute(attribute);
        }
        this.currentTrack = -1;
        this.isPlaying = false;
    }

    public long getPlayStartTime() {
        return this.playStartTime;
    }

    public String getAttributeName() {
        return "net.risingworld.api.jukebox.track_" + this.id + "_" + this.currentTrack;
    }
}

