/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.audio;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.example.audio.MusicPlayer;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Sign;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.SoundInformation;
import net.risingworld.api.utils.Utils;

public class Jukebox
extends Plugin
implements Listener {
    protected ArrayList<SoundInformation> musicTracks = new ArrayList();
    private String[] musicTrackNames;
    private HashMap<Integer, MusicPlayer> musicPlayers = new HashMap();

    public void onEnable() {
        File musicFolder = this.getMusicFolder();
        if (musicFolder != null && musicFolder.exists() && musicFolder.isDirectory()) {
            File[] files;
            for (File f : files = musicFolder.listFiles()) {
                String name;
                if (f.isDirectory() || !(name = f.getName()).endsWith(".mp3") && !name.endsWith(".ogg") && !name.endsWith(".midi")) continue;
                SoundInformation soundInfo = new SoundInformation(f);
                soundInfo.setStreamed(true);
                this.musicTracks.add(soundInfo);
                System.out.println("Added track to jukebox: " + name);
            }
            this.musicTrackNames = new String[this.musicTracks.size()];
            for (int i = 0; i < this.musicTracks.size(); ++i) {
                SoundInformation s = this.musicTracks.get(i);
                this.musicTrackNames[i] = "Track " + (i + 1) + ": " + s.getFilename();
            }
        }
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod(value=Threading.Sync)
    public void onObjectInteraction(PlayerObjectInteractionEvent event) {
        String text;
        Sign sign;
        Player player = event.getPlayer();
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        if (def.isSign() && (sign = this.getWorld().getSign(event.getObjectInfoID())) != null && (text = sign.getText()) != null && text.toLowerCase().contains("jukebox")) {
            MusicPlayer musicPlayer = this.musicPlayers.get(sign.getID());
            if (musicPlayer == null) {
                musicPlayer = new MusicPlayer(this, sign.getID(), event.getObjectPosition());
                this.musicPlayers.put(sign.getID(), musicPlayer);
            }
            if (musicPlayer.isPlaying()) {
                musicPlayer.stop();
                player.showStatusMessage("[#FFAA00]Music player turned off", 2);
            } else {
                MusicPlayer mp = musicPlayer;
                player.showContextMenu(this.musicTrackNames, selection -> {
                    if (selection != null && !selection.isEmpty()) {
                        int track = -1;
                        for (int i = 0; i < this.musicTrackNames.length; ++i) {
                            if (!this.musicTrackNames[i].equals(selection)) continue;
                            track = i;
                            break;
                        }
                        if (mp.isPlaying()) {
                            return;
                        }
                        if (track >= 0) {
                            mp.play(track);
                            player.showStatusMessage("[#FFAA00]Now playing:\n[#33AABF]\"" + this.musicTrackNames[track] + "\"", 4);
                        }
                    }
                });
            }
            event.setCancelled(true);
        }
    }

    @EventMethod(value=Threading.Sync)
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        for (MusicPlayer musicPlayer : this.musicPlayers.values()) {
            int soundID;
            if (!musicPlayer.isPlaying()) continue;
            SoundInformation musicTrack = this.musicTracks.get(musicPlayer.getCurrentTrack());
            String attribute = musicPlayer.getAttributeName();
            if (player.hasAttribute(attribute)) {
                soundID = (Integer)player.getAttribute(attribute);
                player.stopSound(soundID);
            }
            soundID = player.playSound(musicTrack, true, 0.25f, 1.0f, 1.0f, 25.0f, musicPlayer.getPosition());
            float timeline = (float)(System.currentTimeMillis() - musicPlayer.getPlayStartTime()) * 0.001f;
            player.setSoundTimelinePosition(soundID, timeline, false);
            player.setAttribute(attribute, (Object)soundID);
        }
    }

    @EventMethod(value=Threading.Sync)
    public void onObjectDestroy(PlayerDestroyObjectEvent event) {
        if (event.getObjectDefinition().isSign()) {
            this.removeMusicPlayer(event.getObjectInfoID());
        }
    }

    @EventMethod(value=Threading.Sync)
    public void onObjectRemove(PlayerRemoveObjectEvent event) {
        if (event.getObjectDefinition().isSign()) {
            this.removeMusicPlayer(event.getObjectInfoID());
        }
    }

    private void removeMusicPlayer(int id) {
        MusicPlayer musicPlayer = this.musicPlayers.get(id);
        if (musicPlayer != null) {
            if (musicPlayer.isPlaying()) {
                musicPlayer.stop();
            }
            this.musicPlayers.remove(id);
        }
    }

    private File getMusicFolder() {
        File musicPath = new File(this.getPath() + "/Music.txt");
        if (musicPath.exists()) {
            File musicDirectory;
            String path = Utils.FileUtils.readStringFromFile((File)musicPath);
            if (path != null && !path.isEmpty() && (musicDirectory = new File(path)).exists() && musicDirectory.isDirectory()) {
                return musicDirectory;
            }
        } else {
            File musicDirectory = new File(this.getPath() + "/Music/");
            if (musicDirectory.exists()) {
                return musicDirectory;
            }
        }
        return null;
    }
}

