/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.custommusic;

import java.io.File;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.SoundInformation;
import net.risingworld.api.utils.Utils;

public class CustomGameMusic
extends Plugin
implements Listener {
    public ArrayList<SoundInformation> musicTracks = new ArrayList();
    private static final String CURRENTTRACK_ATTRIBUTE = "custom_gamemusic_currenttrack";

    public void onEnable() {
        File musicFolder = this.getMusicFolder();
        if (musicFolder != null && musicFolder.exists() && musicFolder.isDirectory()) {
            File[] files;
            for (File f : files = musicFolder.listFiles()) {
                String name;
                if (f.isDirectory() || !(name = f.getName()).endsWith(".mp3") && !name.endsWith(".ogg") && !name.endsWith(".midi")) continue;
                SoundInformation soundInfo = new SoundInformation(f);
                soundInfo.setStreamed(true);
                this.musicTracks.add(soundInfo);
                System.out.println("Loaded custom music track: " + name);
            }
        }
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        player.disableGameMusic();
        if (!this.musicTracks.isEmpty()) {
            player.setAttribute(CURRENTTRACK_ATTRIBUTE, (Object)Utils.MathUtils.nextRandomInt((int)0, (int)(this.musicTracks.size() - 1)));
            Timer timer = new Timer(600.0f, 20.0f, -1, null);
            timer.setTask(() -> {
                if (!player.isConnected()) {
                    timer.kill();
                    return;
                }
                int currentTrack = (Integer)player.getAttribute(CURRENTTRACK_ATTRIBUTE);
                if (++currentTrack >= this.musicTracks.size()) {
                    currentTrack = 0;
                }
                player.setAttribute(CURRENTTRACK_ATTRIBUTE, (Object)currentTrack);
                SoundInformation track = this.musicTracks.get(currentTrack);
                player.getOption("audio_music_volume", value -> {
                    if (value != null && Utils.StringUtils.isNumeric((String)value)) {
                        float volume = Float.parseFloat(value);
                        player.playSound(track, false, volume *= 0.01f, 1.0f, 0.0f, 0.0f, null);
                    }
                });
            });
            timer.start();
        }
    }

    private File getMusicFolder() {
        File musicPath = new File(this.getPath() + "/Music.txt");
        if (musicPath.exists()) {
            File musicDirectory;
            String path = Utils.FileUtils.readStringFromFile((File)musicPath);
            if (path != null && !path.isEmpty() && (musicDirectory = new File(path)).exists() && musicDirectory.isDirectory()) {
                return musicDirectory;
            }
        } else {
            File musicDirectory = new File(this.getPath() + "/Music/");
            if (musicDirectory.exists()) {
                return musicDirectory;
            }
        }
        return null;
    }
}

