/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.position;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangePositionEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class Position
extends Plugin
implements Listener {
    public void onEnable() {
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        GuiPanel panel = new GuiPanel(0.5f, 0.04f, true, 300.0f, 30.0f, false);
        panel.setPivot(PivotPosition.Center);
        panel.setColor(0.0f, 0.0f, 0.0f, 0.35f);
        GuiLabel posLabel = new GuiLabel(0.5f, 0.5f, true);
        posLabel.setPivot(PivotPosition.Center);
        posLabel.setFont(Font.DefaultMono_Bold);
        posLabel.setFontSize(20);
        posLabel.setFontColor(1.0f, 1.0f, 1.0f, 1.0f);
        panel.addChild((GuiElement)posLabel);
        player.addGuiElement((GuiElement)panel);
        player.addGuiElement((GuiElement)posLabel);
        player.setAttribute("net.rw.api.pos.label", (Object)posLabel);
    }

    @EventMethod
    public void onPlayerChangePosition(PlayerChangePositionEvent event) {
        Player player = event.getPlayer();
        Object attribute = player.getAttribute("net.rw.api.pos.label");
        if (attribute != null && attribute instanceof GuiLabel) {
            GuiLabel label = (GuiLabel)attribute;
            Vector3f pos = player.getPosition();
            label.setText(String.format("%.1f   %.1f   %.1f", Float.valueOf(pos.x), Float.valueOf(pos.y), Float.valueOf(pos.z)));
        }
    }
}

