/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.utils.ChunkLOD;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.World3DModel;

public class _3D {
    static float getSurfaceElevation(Plugin plugin, Vector3f area3fPOS) {
        Vector3i chunkPositionStore = new Vector3i().zero();
        Vector3i blockPositionStore = new Vector3i().zero();
        Utils.ChunkUtils.getChunkAndBlockPosition((Vector3f)area3fPOS, (Vector3i)chunkPositionStore, (Vector3i)blockPositionStore);
        Vector3i chunkPos = chunkPositionStore;
        ChunkLOD chunkLOD = plugin.getWorld().getChunkLOD(chunkPos.x, chunkPos.z);
        if (chunkLOD != null) {
            Vector3i blockPos = blockPositionStore;
            short elevation = chunkLOD.getSurfaceElevation(blockPos.x, blockPos.z);
            return elevation;
        }
        return 0.0f;
    }

    public static World3DModel create3DModel(ModelInformation model, ImageInformation texture, Crosshair cross, boolean LightingEnabled, boolean Interactable, CollisionShape CollisionShape2, float Scale, float TextureScale) {
        World3DModel Model = new World3DModel(model, texture);
        Model.setLightingEnabled(LightingEnabled);
        Model.setInteractable(Interactable);
        Model.setInteractionCrosshair(cross);
        Model.setCollisionShape(CollisionShape2);
        Model.setScale(Scale);
        Model.setTextureScale(TextureScale);
        return Model;
    }

    public static Vector3f getPosDirectMult(Vector3f position, Quaternion rotation, int multie) {
        Vector3f newPosition = new Vector3f(0.0f, 0.0f, 1.0f);
        rotation.multLocal(newPosition);
        newPosition.multLocal((float)multie);
        newPosition.addLocal(position);
        return newPosition;
    }

    public final class World3DMultiModel
    extends World3DModel {
        private final ArrayList<World3DModel> models;
        private int debug;
        private long modelLastTine;
        private ArrayList<ImageInformation> skin;
        private int skinNr;
        private int modelsNr;
        Timer ani;
        float interval;
        float delay;
        int repit;
        Runnable timerRun;

        long getModelLastTime() {
            return this.modelLastTine;
        }

        public int getModelMax() {
            return this.models.size() - 1;
        }

        public int getModelsNr() {
            return this.modelsNr;
        }

        public World3DMultiModel(ArrayList<World3DModel> models) {
            super(models.get(0).getModel(), models.get(0).getTexture());
            this.debug = 3;
            this.skin = null;
            this.skinNr = -1;
            this.interval = 5.0f;
            this.delay = 0.0f;
            this.repit = -1;
            this.timerRun = () -> {
                if (this.modelsNr + 1 >= models.size()) {
                    this.setModel(0);
                } else {
                    this.setModel(this.modelsNr + 1);
                }
                if (this.debug > 4) {
                    System.out.println("[] World3DMultiModel run Liste setModel " + this.modelsNr);
                }
            };
            this.ani = new Timer(this.interval, this.delay, this.repit, this.timerRun);
            if (this.debug > 3) {
                System.out.println("[] Info 0.1 World3DMultiModel");
            }
            this.models = models;
            this.modelsNr = 0;
            this.handleModels();
            this.setModel(this.modelsNr);
        }

        public World3DMultiModel(World3DMultiModel models) {
            super(models.models.get(0).getModel(), models.models.get(0).getTexture());
            this.debug = 3;
            this.skin = null;
            this.skinNr = -1;
            this.interval = 5.0f;
            this.delay = 0.0f;
            this.repit = -1;
            this.timerRun = () -> {
                if (this.modelsNr + 1 >= models.models.size()) {
                    this.setModel(0);
                } else {
                    this.setModel(this.modelsNr + 1);
                }
                if (this.debug > 4) {
                    System.out.println("[] World3DMultiModel run Model setModel " + this.modelsNr);
                }
            };
            this.ani = new Timer(this.interval, this.delay, this.repit, this.timerRun);
            if (this.debug > 3) {
                System.out.println("[] Info 0.2 World3DMultiModel");
            }
            this.models = new ArrayList<World3DModel>(models.models);
            this.modelsNr = 0;
            if (models.skin != null) {
                this.skin = new ArrayList<ImageInformation>(models.skin);
            }
            this.skinNr = models.skinNr;
            this.handleModels();
            this.setModel(this.modelsNr);
        }

        private void handleModels() {
            this.models.forEach(modles -> {
                if (this.debug > 3) {
                    System.out.println("[] Model[" + modles.getModel().getFilename() + "]\tTextur[" + modles.getTexture().getFilename() + "]");
                }
            });
        }

        public void setModel(int modelNr) {
            this.setModel(modelNr, -1);
        }

        public void setModel(int modelNr, int skinNr) {
            if (this.models.size() > 0) {
                if (modelNr < 0) {
                    modelNr = 0;
                }
                if (modelNr >= this.models.size()) {
                    modelNr = this.models.size() - 1;
                } else {
                    this.modelLastTine = System.currentTimeMillis();
                }
                this.modelsNr = modelNr;
                if (this.debug > 3) {
                    System.out.println("[] World3DMultiModel in setModel " + this.modelsNr + "\t" + (Object)((Object)this));
                }
                if (skinNr >= 0) {
                    this.skinNr = skinNr;
                }
                if (this.debug > 3) {
                    System.out.println("[] World3DMultiModel in setModel img[" + this.skin.get(this.skinNr).getFilename() + "] \t" + (Object)((Object)this));
                }
                if (this.skin != null && this.skinNr >= 0) {
                    if (this.skinNr < this.skin.size()) {
                        this.setTexture(this.skin.get(this.skinNr));
                    } else {
                        this.setTexture(this.models.get(modelNr).getTexture());
                    }
                } else {
                    this.setTexture(this.models.get(modelNr).getTexture());
                }
                this.setModel(this.models.get(modelNr).getModel());
                this.setHittable(this.models.get(modelNr).isHittable());
                this.setInteractable(this.models.get(modelNr).isInteractable());
                this.setLightingEnabled(this.models.get(modelNr).isLightingEnabled());
                this.setListenForCollisions(this.models.get(modelNr).isListeningForCollisions());
                this.setInteractionCrosshair(this.models.get(modelNr).getInteractionCrosshair());
                this.setCollisionShape(this.models.get(modelNr).getCollisionShape());
                this.setScale(this.models.get((int)modelNr).getScale().x, this.models.get((int)modelNr).getScale().y, this.models.get((int)modelNr).getScale().z);
                this.refresh();
            }
        }

        public void setPosition(Vector3f position) {
            super.setPosition(position);
        }

        public void setPosition(float x, float y, float z) {
            super.setPosition(x, y, z);
        }

        void iniSkin(ArrayList<ImageInformation> skin) {
            if (this.skin == null) {
                this.skin = skin;
            }
        }

        int getSkinMax() {
            if (this.skin != null) {
                return this.skin.size();
            }
            return 0;
        }

        int getSkinNr() {
            return this.skinNr;
        }

        ArrayList<ImageInformation> getSkin() {
            return new ArrayList<ImageInformation>(this.skin);
        }
    }
}

