/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.data;

import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalDataBase;
import carsten.risingworld.abm.data.NpcFetcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;

public class AnimalMap {
    private static NpcFetcher npcFetcher;
    private static Map<Integer, Animal> map;

    private AnimalMap() {
    }

    public static void setNpcFetcher(NpcFetcher p_npcFetcher) {
        npcFetcher = p_npcFetcher;
    }

    public static void preloadAll() {
        List<Animal> allAnimals = AnimalDataBase.INSTANCE.selectAllAnimals();
        for (Animal animal : allAnimals) {
            AnimalMap.add(animal);
        }
    }

    private static Animal load(int npcId) {
        Animal animal = AnimalDataBase.INSTANCE.selectAnimalByNpc(npcId);
        if (animal == Animal.NULL) {
            animal = new Animal(npcId);
        }
        return animal;
    }

    static void add(Animal animal) {
        int npcId = animal.getNpcId();
        if (!map.containsKey(npcId)) {
            animal.setNpc(npcFetcher.getNpc(npcId));
            map.put(npcId, animal);
        }
    }

    public static Animal get(int npcId) {
        if (!map.containsKey(npcId)) {
            AnimalMap.add(AnimalMap.load(npcId));
        }
        return map.get(npcId);
    }

    public static List<Animal> getAll() {
        return new ArrayList<Animal>(map.values());
    }

    public static void remove(Animal animal) {
        map.remove(animal.getNpcId());
        animal.clear();
    }

    @PreDestroy
    public static void clearAll() {
        for (Animal animal : map.values()) {
            animal.clear();
        }
        map.clear();
    }

    static {
        map = new HashMap<Integer, Animal>();
    }
}

