/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.data;

import carsten.risingworld.abm.ABMTimeStamp;
import carsten.risingworld.abm.data.AnimalType;
import javax.annotation.PreDestroy;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.utils.Vector3f;

public class Animal
implements carsten.risingworld.api.abm.Animal {
    private static int OBJID = 0;
    public static final Animal NULL = new Animal(-1);
    private final int id = OBJID++;
    private int npcId;
    private String npcName;
    private int playerId;
    private boolean offspring;
    private boolean prolific;
    private int pregnancyProgress;
    private float xLoc;
    private float yLoc;
    private float zLoc;
    private int feedCount;
    private Npc npc;
    private int lastModified;

    public Animal(int npcId) {
        this(npcId, "", -1, false, false, 0, 0.0f, 0.0f, 0.0f);
    }

    public Animal(int p_npcId, String p_npcName, int p_playerId, boolean p_offspring, boolean p_prolific, int p_pregnancyProgress, float p_xLoc, float p_yLoc, float p_zLoc) {
        this.npcId = p_npcId;
        this.npcName = p_npcName;
        this.playerId = p_playerId;
        this.offspring = p_offspring;
        this.prolific = p_prolific;
        this.pregnancyProgress = p_pregnancyProgress;
        this.xLoc = p_xLoc;
        this.yLoc = p_yLoc;
        this.zLoc = p_zLoc;
        this.updateLastModified();
    }

    @Override
    public int getNpcId() {
        return this.npcId;
    }

    @Override
    public String getNpcName() {
        return this.npcName;
    }

    public void setNpcName(String p_npcName) {
        this.npcName = p_npcName;
        this.updateLastModified();
    }

    @Override
    public int getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(int p_playerId) {
        this.playerId = p_playerId;
        if (this.playerId < 0) {
            this.playerId = -1;
        }
        this.updateLastModified();
    }

    @Override
    public boolean isOffspring() {
        return this.offspring;
    }

    public void setOffspring() {
        this.offspring = true;
        this.updateLastModified();
    }

    @Override
    public boolean isProlific() {
        return this.prolific;
    }

    public void setProlific(boolean p_prolific) {
        this.prolific = p_prolific;
        this.updateLastModified();
    }

    @Override
    public int getPregnancyProgress() {
        return this.pregnancyProgress;
    }

    public void setPregnancyProgress(int p_pregnancyProgress) {
        this.pregnancyProgress = p_pregnancyProgress;
        this.updateLastModified();
    }

    float getXLocation() {
        return this.xLoc;
    }

    void setXLocation(float p_xPos) {
        this.xLoc = p_xPos;
    }

    float getYLocation() {
        return this.yLoc;
    }

    void setYLocation(float p_yPos) {
        this.yLoc = p_yPos;
    }

    float getZLocation() {
        return this.zLoc;
    }

    void setZLocation(float p_zPos) {
        this.zLoc = p_zPos;
    }

    @Override
    public Vector3f getHomeLocation() {
        return new Vector3f(this.getXLocation(), this.getYLocation(), this.getZLocation());
    }

    public void setHomeLocation(Vector3f location) {
        this.setXLocation(location.getX());
        this.setYLocation(location.getY() + 0.5f);
        this.setZLocation(location.getZ());
        this.updateLastModified();
    }

    public void resetFeedCount() {
        this.feedCount = 0;
        this.updateLastModified();
    }

    public void incFeedCount() {
        ++this.feedCount;
        this.updateLastModified();
    }

    @Override
    public int getFeedCount() {
        return this.feedCount;
    }

    @Override
    public boolean isOwnedByPlayer(int playerId) {
        return this.getPlayerId() == playerId;
    }

    @Override
    public boolean isOwned() {
        return this.getPlayerId() > 0;
    }

    @Override
    public boolean isPregnant() {
        return this.pregnancyProgress > 0;
    }

    void setNpc(Npc p_npc) {
        this.npc = p_npc;
        if (this.npc == null || this.getXLocation() != 0.0f) {
            // empty if block
        }
    }

    @Override
    public Npc getNpc() {
        return this.npc;
    }

    public void setLocked(boolean locked) {
        Npc npc = this.getNpc();
        if (npc == null) {
            return;
        }
        npc.setLocked(locked);
        this.updateLastModified();
    }

    @Override
    public boolean isLocked() {
        return this.npc != null && this.npc.isLocked();
    }

    public void setInvincible(boolean invincible) {
        Npc npc = this.getNpc();
        if (npc == null) {
            return;
        }
        npc.setInvincible(invincible);
        this.updateLastModified();
    }

    @Override
    public boolean isInvincible() {
        return this.npc != null && this.npc.isInvincible();
    }

    private void updateLastModified() {
        this.lastModified = ABMTimeStamp.INSTANCE.get();
    }

    @Override
    public int getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getType() {
        return this.npc == null ? "undefined" : AnimalType.name(this.npc.getTypeID());
    }

    @PreDestroy
    void clear() {
        this.npc = null;
    }

    public String toString() {
        return "Animal[id=" + this.id + ", npcId=" + this.getNpcId() + ", name=" + this.getNpcName() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Animal) {
            Animal anotherAnimal = (Animal)obj;
            return this.getNpcId() == anotherAnimal.getNpcId();
        }
        return false;
    }
}

