/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm;

import carsten.risingworld.abm.ABMPreferencesHandler;
import carsten.risingworld.abm.ABMResourceBundle;
import carsten.risingworld.abm.ABMUtil;
import carsten.risingworld.abm.AnimalBreedMaster;
import carsten.risingworld.abm.AnimalController;
import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.event.AnimalBornEvent;
import carsten.risingworld.abm.event.AnimalFollowLockedEvent;
import carsten.risingworld.abm.event.AnimalFollowStartEvent;
import carsten.risingworld.abm.event.AnimalFollowStopEvent;
import carsten.risingworld.abm.event.AnimalOwnerChangedEvent;
import carsten.risingworld.abm.event.AnimalOwnerReleasedEvent;
import carsten.risingworld.abm.event.AnimalPregnantEvent;
import carsten.risingworld.abm.event.AnimalProlificEvent;
import carsten.risingworld.abm.event.AnimalRenamedEvent;
import carsten.risingworld.abm.event.AnimalRewardEvent;
import carsten.risingworld.abm.event.AnimalSleepEvent;
import carsten.risingworld.abm.event.PlayerAnimalLimitReachedEvent;
import carsten.risingworld.abm.event.PlayerInsufficientPointsEvent;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.objects.Player;

public class ABMChatNotification
implements Listener {
    private static ABMChatNotification notification;
    private AnimalBreedMaster abm;

    static void enable(AnimalBreedMaster abm) {
        notification = new ABMChatNotification(abm);
        notification.register();
    }

    static void disable() {
        notification.unregister();
    }

    private ABMChatNotification(AnimalBreedMaster p_abm) {
        this.abm = p_abm;
    }

    private void register() {
        this.abm.registerEventListener(this);
    }

    private void unregister() {
        this.abm.unregisterEventListener(this);
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalRenamedEvent(AnimalRenamedEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = ABMUtil.getBundleFor(player);
        ABMUtil.chatMessage(player, "[#7fff00]" + bundle.getVal("rename.old") + evt.getOldName() + " [#ffff00]" + bundle.getVal("rename.new") + animal.getNpcName());
        AnimalController.resetRenameTaggedAnimal(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerInsufficientPointsEvent(PlayerInsufficientPointsEvent evt) {
        Player player = evt.getPlayer();
        ABMResourceBundle bundle = ABMUtil.getBundleFor(player);
        ABMUtil.chatMessage(player, "[#ffff00]" + bundle.getVal("reward.insuff") + "[#7fff00]" + evt.getRequiredPoints() + "[#ffff00]" + bundle.getVal("reward.insuff." + evt.getAnimalName()) + bundle.getVal("reward.insuff.curr") + "[#7fff00]" + evt.getCurrentPoints() + "[#ffff00]!");
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerAnimalLimitReachedEvent(PlayerAnimalLimitReachedEvent evt) {
        Player player = evt.getPlayer();
        ABMResourceBundle bundle = ABMUtil.getBundleFor(player);
        ABMUtil.chatMessage(player, "[#ffff00]" + evt.getMessage() + ": " + bundle.getVal("owner.limit") + " (" + ABMPreferencesHandler.getMaxAnimals() + ")");
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalBornEvent(AnimalBornEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        player.playGameSound("fireworks_start", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        ABMChatNotification.chatMessage(player, "[#7fff00]" + ABMChatNotification.getNameOrDefault(player, animal) + bundle.getVal("birth.ok"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalProlificEvent(AnimalProlificEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        ABMChatNotification.chatMessage(player, "[#7fff00]" + ABMChatNotification.getNameOrDefault(player, animal) + bundle.getVal("prolific"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalPregnantEvent(AnimalPregnantEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        ABMChatNotification.chatMessage(player, "[#7fff00]" + ABMChatNotification.getNameOrDefault(player, animal) + bundle.getVal("pregnant"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalOwnerChangedEvent(AnimalOwnerChangedEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        ABMChatNotification.chatMessage(player, "[#7fff00]" + ABMChatNotification.getNameOrDefault(player, animal) + bundle.getVal("owner.new"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalOwnerReleasedEvent(AnimalOwnerReleasedEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        ABMChatNotification.chatMessage(player, "[#7fff00]" + ABMChatNotification.getNameOrDefault(player, animal) + bundle.getVal("owner.released"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalSleepEvent(AnimalSleepEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        String name = ABMChatNotification.getNameOrDefault(player, animal);
        ABMChatNotification.chatMessage(player, "[#ffff00]" + name + "[#ffff00]: ...zzzzz zzzzz");
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalRewardEvent(AnimalRewardEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        player.playGameSound("fireworks_start", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        ABMChatNotification.chatMessage(player, "[#7fff00]" + ABMChatNotification.getNameOrDefault(player, animal) + bundle.getVal("reward.ok") + " [#ffff00]" + bundle.getVal("congratulations"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalFollowStartEvent(AnimalFollowStartEvent evt) {
        Player player = evt.getPlayer();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        String name = evt.getAnimalName();
        ABMChatNotification.chatMessage(player, "[#7fff00]" + name + "[#7fff00]" + bundle.getVal("following.start"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalFollowStopEvent(AnimalFollowStopEvent evt) {
        Player player = evt.getPlayer();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        String name = evt.getAnimalName();
        ABMChatNotification.chatMessage(player, "[#ffff00]" + name + "[#ffff00]" + bundle.getVal("following.stop"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalFollowLockedEvent(AnimalFollowLockedEvent evt) {
        Player player = evt.getPlayer();
        ABMResourceBundle bundle = ABMChatNotification.getPlayerBundle(player);
        String name = evt.getAnimalName();
        ABMChatNotification.chatMessage(player, "[#ffff00]" + name + "[#ffff00]" + bundle.getVal("animal.says") + bundle.getVal("following.locked"));
    }

    private static ABMResourceBundle getPlayerBundle(Player player) {
        return ABMUtil.getBundleFor(player);
    }

    private static void chatMessage(Player player, String message) {
        ABMUtil.chatMessage(player, message);
    }

    private static String getNameOrDefault(Player player, Animal animal) {
        return ABMUtil.getNameOrDefault(player, animal);
    }
}

