/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm;

import carsten.risingworld.abm.ABMUtil;
import carsten.risingworld.abm.AnimalBreedMaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.Properties;

public class ABMPreferencesHandler {
    private static final String SEP = FileSystems.getDefault().getSeparator();
    private static final String EXT = ".xml";
    private static final String ABM_PREFS = "AnimalBreedMaster.prefs";
    private static String PATH;
    private static final String PROP_MAX_ANIMALS = "max_animals_per_player";
    private static final String PROP_RENAMING_ACTIVE = "rename_action_active";
    private static final String PROP_INVINCIBLE_ACTIVE = "invincible_action_active";
    private static final String PROP_REWARDS_ACTIVE = "reward_system_active";
    private static final Properties settings;

    static void init(AnimalBreedMaster abm) {
        PATH = abm.getPath();
        ABMPreferencesHandler.loadSettings();
    }

    private static void loadSettings() {
        ABMPreferencesHandler.loadPreferences();
        ABMPreferencesHandler.checkSettings();
        ABMPreferencesHandler.saveSettings();
    }

    private static void saveSettings() {
        ABMPreferencesHandler.savePreferences();
    }

    static int getMaxAnimals() {
        return ABMUtil.getInteger(settings.getProperty(PROP_MAX_ANIMALS));
    }

    static void setRenamingActive(String bool) {
        settings.setProperty(PROP_RENAMING_ACTIVE, bool);
        ABMPreferencesHandler.saveSettings();
        ABMPreferencesHandler.loadSettings();
    }

    public static boolean isRenamingActive() {
        return Boolean.parseBoolean(settings.getProperty(PROP_RENAMING_ACTIVE));
    }

    static void setInvincibleActionActive(String bool) {
        settings.setProperty(PROP_INVINCIBLE_ACTIVE, bool);
        ABMPreferencesHandler.saveSettings();
        ABMPreferencesHandler.loadSettings();
    }

    public static boolean isInvincibleActionActive() {
        return Boolean.parseBoolean(settings.getProperty(PROP_INVINCIBLE_ACTIVE));
    }

    static void setRewardSystemActive(String bool) {
        settings.setProperty(PROP_REWARDS_ACTIVE, bool);
        ABMPreferencesHandler.saveSettings();
        ABMPreferencesHandler.loadSettings();
    }

    public static boolean isRewardSystemActive() {
        return Boolean.parseBoolean(settings.getProperty(PROP_REWARDS_ACTIVE));
    }

    private static void loadPreferences() {
        if (PATH == null || PATH.length() < 1) {
            return;
        }
        String filepath = PATH + SEP + ABM_PREFS + EXT;
        File file = new File(filepath);
        if (!file.exists()) {
            ABMPreferencesHandler.savePreferences();
        }
        try (FileInputStream in = new FileInputStream(file);){
            settings.loadFromXML(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void savePreferences() {
        if (PATH == null || PATH.length() < 1) {
            return;
        }
        String filepath = PATH + SEP + ABM_PREFS + EXT;
        File file = new File(filepath);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (FileOutputStream out = new FileOutputStream(file, false);){
            settings.storeToXML((OutputStream)out, "", StandardCharsets.UTF_8.name());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void checkSettings() {
        String bool;
        int i = ABMUtil.getInteger(settings.getProperty(PROP_MAX_ANIMALS));
        if (i < 1 || i > 1000) {
            settings.setProperty(PROP_MAX_ANIMALS, "50");
        }
        if (!(bool = settings.getProperty(PROP_INVINCIBLE_ACTIVE, "true")).matches("^true|false$")) {
            bool = "true";
        }
        settings.setProperty(PROP_INVINCIBLE_ACTIVE, bool);
        bool = settings.getProperty(PROP_RENAMING_ACTIVE, "true");
        if (!bool.matches("^true|false$")) {
            bool = "true";
        }
        settings.setProperty(PROP_RENAMING_ACTIVE, bool);
        bool = settings.getProperty(PROP_REWARDS_ACTIVE, "true");
        if (!bool.matches("^true|false$")) {
            bool = "true";
        }
        settings.setProperty(PROP_REWARDS_ACTIVE, bool);
    }

    static {
        settings = new Properties();
    }
}

