/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.CRT;
import de.chaoswg.GUI;
import de.chaoswg.GetConfigDaten;
import de.chaoswg.NetworkUtil;
import de.chaoswg.ServerBrandingErrorSprachAPI;
import de.chaoswg.SprachAPI;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeGamemodeEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.ImageInformation;

public class ServerBranding
extends Plugin
implements Listener {
    private ServerBranding plugin;
    private Server server;
    private World world;
    private CRT crt;
    private String conf;
    private int debug;
    private GetConfigDaten pluginConfig;
    private final String fileSeparator;
    private final String fs;
    private String WasserzeichenFile;
    private ImageInformation logo;
    private float WasserzeichenWidth;
    private float WasserzeichenHeight;
    private String WasserzeichenPivot;
    private float WasserzeichenOffsetWidth;
    private float WasserzeichenOffsetHeight;
    private float WasserzeichenOffsetCreativeWidth;
    private float WasserzeichenOffsetCreativeHeight;
    private final ClassAttr attr;
    private int InfoColor;
    private int InfoColor2;
    private int typeColor;
    private int tsColor;
    private int ipColor;
    private int logoLabSize;
    private int ipLabSize;
    private int tsLabSize;
    private int typeLabSize;
    private String infoPivot;
    private float InfoOffsetWidth;
    private float InfoOffsetHeight;
    private float InfoOffsetCreativeWidth;
    private float InfoOffsetCreativeHeight;
    private String name;
    private String ip;
    private String ts;
    private boolean WasserzeichenVisible;
    private boolean InfoVisible;
    private boolean showType;
    private String i1;
    private String i2;
    private String i3;
    private String showSequence;
    private HashMap<String, GUI.GuiLabelSrvInfo.ClassText> logoLabText;
    String recSprachApiVersion;
    private DateTimeFormatter dtf;
    private SprachAPI sprachApiPlugin;

    public ServerBranding() {
        this.fs = this.fileSeparator = System.getProperty("file.separator");
        this.WasserzeichenWidth = 0.1f;
        this.WasserzeichenHeight = 0.1f;
        this.WasserzeichenOffsetWidth = -1.0f;
        this.WasserzeichenOffsetHeight = -1.0f;
        this.WasserzeichenOffsetCreativeWidth = -1.0f;
        this.WasserzeichenOffsetCreativeHeight = -1.0f;
        this.InfoColor = -65281;
        this.InfoColor2 = -4194049;
        this.typeColor = -65281;
        this.tsColor = -65281;
        this.ipColor = -65281;
        this.logoLabSize = 20;
        this.ipLabSize = 18;
        this.tsLabSize = 16;
        this.typeLabSize = 14;
        this.InfoOffsetWidth = -1.0f;
        this.InfoOffsetHeight = -1.0f;
        this.InfoOffsetCreativeWidth = -1.0f;
        this.InfoOffsetCreativeHeight = -1.0f;
        this.WasserzeichenVisible = true;
        this.InfoVisible = true;
        this.showSequence = "NAME,IP,TYPE,TS,I1,I2,I3";
        this.showType = false;
        this.i1 = "";
        this.i2 = "";
        this.i3 = "";
        this.ts = "";
        this.ip = "";
        this.name = "";
        this.attr = new ClassAttr();
        this.WasserzeichenPivot = "CenterTop";
        this.WasserzeichenFile = "";
        this.infoPivot = "BottomLeft";
        this.logo = null;
    }

    int getDebug() {
        return this.debug;
    }

    public void onEnable() {
        this.plugin = this;
        this.server = this.getServer();
        this.world = this.getWorld();
        this.crt = new CRT();
        this.conf = CRT.getSpec();
        this.debug = 1;
        this.recSprachApiVersion = "1.1.6";
        String pattern = "yyyy-MM-dd HH:mm:ss";
        this.dtf = DateTimeFormatter.ofPattern(pattern);
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled ");
        }
        NetworkUtil nu = new NetworkUtil();
        nu.printAllOwnerMacs();
        String hIP = nu.getOwnerIp();
        String hName = nu.getCanonicalHostName().replace(nu.getOwnerHostName() + ".", "");
        if (!hName.equals(hIP) && this.debug > 1) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled hostFine: " + hName);
        }
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            this.sprachApiPlugin = (SprachAPI)this.plugin.getPluginByName("SprachAPI");
            if (this.crt.isSameVersion(this.recSprachApiVersion, this.sprachApiPlugin.getDescription("version"), new CRT.ClassDebug((Plugin)this.plugin, this.debug))) {
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ") OK");
                }
                String[][] pluginConfigArray = new String[][]{{"watermarkVisible", String.valueOf(this.WasserzeichenVisible)}, {"watermarkFile", this.WasserzeichenFile}, {"watermarkWidth", String.valueOf(this.WasserzeichenWidth)}, {"watermarkHeight", String.valueOf(this.WasserzeichenHeight)}, {"watermarkOffsetWidth", String.valueOf(this.WasserzeichenOffsetWidth)}, {"watermarkOffsetHeight", String.valueOf(this.WasserzeichenOffsetHeight)}, {"watermarkOffsetCreativeWidth", String.valueOf(this.WasserzeichenOffsetCreativeWidth)}, {"watermarkOffsetCreativeHeight", String.valueOf(this.WasserzeichenOffsetCreativeHeight)}, {"watermarkPivot", this.WasserzeichenPivot}, {"InfoVisible", String.valueOf(this.InfoVisible)}, {"InfoColor", String.format("%8s", Integer.toHexString(this.InfoColor & 0xFFFFFFFF)).replaceAll(" ", "")}, {"InfoColorII", String.format("%8s", Integer.toHexString(this.InfoColor2 & 0xFFFFFFFF)).replaceAll(" ", "")}, {"InfoSize", String.valueOf(this.logoLabSize)}, {"InfoPivot", this.infoPivot}, {"InfoOffsetWidth", String.valueOf(this.InfoOffsetWidth)}, {"InfoOffsetHeight", String.valueOf(this.InfoOffsetHeight)}, {"InfoOffsetCreativeWidth", String.valueOf(this.InfoOffsetCreativeWidth)}, {"InfoOffsetCreativeHeight", String.valueOf(this.InfoOffsetCreativeHeight)}, {"NAME", this.name}, {"IP", this.ip}, {"IPsize", String.valueOf(this.ipLabSize)}, {"IPcolor", String.format("%8s", Integer.toHexString(this.ipColor & 0xFFFFFFFF)).replaceAll(" ", "")}, {"TS", this.ts}, {"TSsize", String.valueOf(this.tsLabSize)}, {"TScolor", String.format("%8s", Integer.toHexString(this.tsColor & 0xFFFFFFFF)).replaceAll(" ", "")}, {"I1", this.i1}, {"I2", this.i2}, {"I3", this.i3}, {"InfoShowType", String.valueOf(this.showType)}, {"InfoShowTypeSize", String.valueOf(this.typeLabSize)}, {"InfoShowTypeColor", String.format("%8s", Integer.toHexString(this.typeColor & 0xFFFFFFFF)).replaceAll(" ", "")}, {"InfoSequence", String.valueOf(this.showSequence)}, {"Debug", String.valueOf(this.debug)}};
                this.pluginConfig = new GetConfigDaten("Plugin", pluginConfigArray, (Plugin)this, this.debug, this.conf);
                this.debug = Integer.parseInt(this.pluginConfig.getValue("Debug"));
                this.name = this.pluginConfig.getValue("NAME");
                this.ip = this.pluginConfig.getValue("IP");
                this.ip = this.ip.equals("") && !this.server.getIP().equals("") ? this.server.getIP() + ":" + this.server.getPort() : hName + ":" + this.server.getPort();
                this.ipLabSize = Integer.parseInt(this.pluginConfig.getValue("IPsize"));
                this.ipColor = (int)Long.parseLong(this.pluginConfig.getValue("IPcolor"), 16);
                this.ts = this.pluginConfig.getValue("TS");
                this.tsLabSize = Integer.parseInt(this.pluginConfig.getValue("TSsize"));
                this.tsColor = (int)Long.parseLong(this.pluginConfig.getValue("TScolor"), 16);
                this.i1 = this.pluginConfig.getValue("I1");
                this.i2 = this.pluginConfig.getValue("I2");
                this.i3 = this.pluginConfig.getValue("I3");
                this.showType = this.pluginConfig.getValue("InfoShowType").toLowerCase().equals("true");
                this.typeLabSize = Integer.parseInt(this.pluginConfig.getValue("InfoShowTypeSize"));
                this.typeColor = (int)Long.parseLong(this.pluginConfig.getValue("InfoShowTypeColor"), 16);
                this.showSequence = this.pluginConfig.getValue("InfoSequence");
                this.WasserzeichenVisible = this.pluginConfig.getValue("watermarkVisible").toLowerCase().equals("true");
                this.WasserzeichenFile = this.pluginConfig.getValue("watermarkFile");
                this.WasserzeichenWidth = Float.parseFloat(this.pluginConfig.getValue("watermarkWidth").replace(",", "."));
                this.WasserzeichenHeight = Float.parseFloat(this.pluginConfig.getValue("watermarkHeight").replace(",", "."));
                this.WasserzeichenOffsetWidth = Float.parseFloat(this.pluginConfig.getValue("watermarkOffsetWidth").replace(",", "."));
                this.WasserzeichenOffsetHeight = Float.parseFloat(this.pluginConfig.getValue("watermarkOffsetHeight").replace(",", "."));
                this.WasserzeichenOffsetCreativeWidth = Float.parseFloat(this.pluginConfig.getValue("watermarkOffsetCreativeWidth").replace(",", "."));
                this.WasserzeichenOffsetCreativeHeight = Float.parseFloat(this.pluginConfig.getValue("watermarkOffsetCreativeHeight").replace(",", "."));
                this.WasserzeichenPivot = this.pluginConfig.getValue("watermarkPivot");
                this.InfoVisible = this.pluginConfig.getValue("InfoVisible").toLowerCase().equals("true");
                this.InfoColor = (int)Long.parseLong(this.pluginConfig.getValue("InfoColor"), 16);
                this.InfoColor2 = (int)Long.parseLong(this.pluginConfig.getValue("InfoColorII"), 16);
                this.logoLabSize = Integer.parseInt(this.pluginConfig.getValue("InfoSize"));
                this.InfoOffsetWidth = Float.parseFloat(this.pluginConfig.getValue("InfoOffsetWidth").replace(",", "."));
                this.InfoOffsetHeight = Float.parseFloat(this.pluginConfig.getValue("InfoOffsetHeight").replace(",", "."));
                this.InfoOffsetCreativeWidth = Float.parseFloat(this.pluginConfig.getValue("InfoOffsetCreativeWidth").replace(",", "."));
                this.InfoOffsetCreativeHeight = Float.parseFloat(this.pluginConfig.getValue("InfoOffsetCreativeHeight").replace(",", "."));
                this.infoPivot = this.pluginConfig.getValue("InfoPivot");
                if (this.WasserzeichenFile.equals("")) {
                    this.WasserzeichenFile = !this.server.getOption("server_custom_logo").equals("") ? ".." + this.fs + ".." + this.fs + this.server.getOption("server_custom_logo") : "Logo.png";
                }
                if (this.debug > 2) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] INI " + this.server.getOption("server_custom_logo") + "\t" + this.WasserzeichenFile);
                }
                this.logo = CRT.getBild((Plugin)this.plugin, (String)"/resources/Logo.png", (String)(this.plugin.getPath() + this.fs + this.WasserzeichenFile), (int)this.debug);
                if (this.plugin.debug > 2) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled \tName[" + this.server.getName() + "] Type[" + this.server.getType() + "] ");
                }
                if (this.plugin.debug > 2) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled \tIP[" + this.server.getIP() + "] Port[" + this.server.getPort() + "] ");
                }
                this.registerEventListener(this);
            } else {
                System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Die Version von Plugin 'SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ")' ist zu klein! Bitte Aktualisieren auf Version(" + this.recSprachApiVersion + ")!");
                this.registerEventListener(new ServerBrandingErrorSprachAPI(this));
            }
        } else if (this.plugin.getPluginByName("SprachAPI") == null) {
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Das Plugin 'SprachAPI' ist nicht installiert! Bitte installieren!");
            this.registerEventListener(new ServerBrandingErrorSprachAPI(this));
        }
    }

    public void onDisable() {
        System.out.println("[" + this.plugin.getDescription("name") + "] Disabled");
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Spawn ");
        }
        Player player = event.getPlayer();
        float B = 0.0f;
        float H = 0.0f;
        float X = 0.0f;
        float Y = 0.0f;
        B = this.WasserzeichenWidth;
        H = this.WasserzeichenHeight * 1.618034f;
        if (this.WasserzeichenVisible) {
            GUI.GuiImage logoHG = new GUI.GuiImage(this.logo, X, Y, true, B, H, true);
            logoHG.setOffsetWidth(this.WasserzeichenOffsetWidth);
            logoHG.setOffsetHeight(this.WasserzeichenOffsetHeight);
            logoHG.setOffsetCreativeWidth(this.WasserzeichenOffsetCreativeWidth);
            logoHG.setOffsetCreativeHeight(this.WasserzeichenOffsetCreativeHeight);
            logoHG.setPivot(PivotPosition.valueOf((String)this.WasserzeichenPivot), player);
            player.setAttribute(this.attr.Logo, (Object)logoHG);
            player.addGuiElement(((GUI.GuiImage)player.getAttribute(this.attr.Logo)).getGuiElement());
        }
        if (this.InfoVisible) {
            int lSize;
            String[] hasSplit;
            String inStr = "";
            GUI.GuiLabelSrvInfo logoLab = new GUI.GuiLabelSrvInfo(inStr, 0.0f, 1.0f, true);
            logoLab.setOffsetWidth(this.InfoOffsetWidth);
            logoLab.setOffsetHeight(this.InfoOffsetHeight);
            logoLab.setOffsetCreativeWidth(this.InfoOffsetCreativeWidth);
            logoLab.setOffsetCreativeHeight(this.InfoOffsetCreativeHeight);
            this.logoLabText = new HashMap();
            this.logoLabText.put("NAME", new GUI.GuiLabelSrvInfo.ClassText(this.logoLabSize, !this.name.equals("") ? this.name : this.server.getName(), Font.Default, this.InfoColor, this.InfoColor2));
            this.logoLabText.put("IP", new GUI.GuiLabelSrvInfo.ClassText(this.ipLabSize, this.ip, Font.Default, this.ipColor, this.InfoColor2));
            this.logoLabText.put("TS", new GUI.GuiLabelSrvInfo.ClassText(this.tsLabSize, this.ts, Font.Default, this.tsColor, this.InfoColor2));
            this.logoLabText.put("TYPE", new GUI.GuiLabelSrvInfo.ClassText(this.typeLabSize, this.showType ? this.server.getType().name() : "", Font.Default, this.typeColor, this.InfoColor2));
            if (!this.i1.equals("")) {
                hasSplit = this.i1.split(":", 3);
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Spawn \tINI I1[" + hasSplit.length + "] " + hasSplit.toString());
                }
                if (hasSplit.length > 2) {
                    this.logoLabText.put(hasSplit[0], new GUI.GuiLabelSrvInfo.ClassText(Integer.parseInt(hasSplit[1]), CRT.replaceLang((Player)player, (String)hasSplit[2]), Font.Default, this.InfoColor, this.InfoColor2));
                } else if (hasSplit.length > 1) {
                    lSize = -1;
                    try {
                        lSize = Integer.parseInt(hasSplit[0]);
                        if (this.debug > 0) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Spawn \tINI I2.2[" + lSize + "] " + hasSplit.toString());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (lSize > 0) {
                        this.logoLabText.put("I1", new GUI.GuiLabelSrvInfo.ClassText(lSize, CRT.replaceLang((Player)player, (String)hasSplit[1]), Font.Default, this.InfoColor, this.InfoColor2));
                    } else {
                        this.logoLabText.put(hasSplit[0], new GUI.GuiLabelSrvInfo.ClassText(this.logoLabSize, CRT.replaceLang((Player)player, (String)hasSplit[1]), Font.Default, this.InfoColor, this.InfoColor2));
                    }
                } else {
                    this.logoLabText.put("I1", new GUI.GuiLabelSrvInfo.ClassText(this.logoLabSize, CRT.replaceLang((Player)player, (String)hasSplit[0]), Font.Default, this.InfoColor, this.InfoColor2));
                }
            }
            if (!this.i2.equals("")) {
                hasSplit = this.i2.split(":", 3);
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Spawn \tINI I2[" + hasSplit.length + "] " + hasSplit.toString());
                }
                if (hasSplit.length > 2) {
                    this.logoLabText.put(hasSplit[0], new GUI.GuiLabelSrvInfo.ClassText(Integer.parseInt(hasSplit[1]), CRT.replaceLang((Player)player, (String)hasSplit[2]), Font.Default, this.InfoColor, this.InfoColor2));
                } else if (hasSplit.length > 1) {
                    lSize = -1;
                    try {
                        lSize = Integer.parseInt(hasSplit[0]);
                        if (this.debug > 0) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Spawn \tINI I2.2[" + lSize + "] " + hasSplit.toString());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (lSize > 0) {
                        this.logoLabText.put("I2", new GUI.GuiLabelSrvInfo.ClassText(lSize, CRT.replaceLang((Player)player, (String)hasSplit[1]), Font.Default, this.InfoColor, this.InfoColor2));
                    } else {
                        this.logoLabText.put(hasSplit[0], new GUI.GuiLabelSrvInfo.ClassText(this.logoLabSize, CRT.replaceLang((Player)player, (String)hasSplit[1]), Font.Default, this.InfoColor, this.InfoColor2));
                    }
                } else {
                    this.logoLabText.put("I2", new GUI.GuiLabelSrvInfo.ClassText(this.logoLabSize, CRT.replaceLang((Player)player, (String)hasSplit[0]), Font.Default, this.InfoColor, this.InfoColor2));
                }
            }
            if (!this.i3.equals("")) {
                hasSplit = this.i3.split(":", 3);
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Spawn \tINI I3[" + hasSplit.length + "] " + hasSplit.toString());
                }
                if (hasSplit.length > 2) {
                    this.logoLabText.put(hasSplit[0], new GUI.GuiLabelSrvInfo.ClassText(Integer.parseInt(hasSplit[1]), CRT.replaceLang((Player)player, (String)hasSplit[2]), Font.Default, this.InfoColor, this.InfoColor2));
                } else if (hasSplit.length > 1) {
                    lSize = -1;
                    try {
                        lSize = Integer.parseInt(hasSplit[0]);
                        if (this.debug > 0) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Spawn \tINI I2.2[" + lSize + "] " + hasSplit.toString());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (lSize > 0) {
                        this.logoLabText.put("I3", new GUI.GuiLabelSrvInfo.ClassText(lSize, CRT.replaceLang((Player)player, (String)hasSplit[1]), Font.Default, this.InfoColor, this.InfoColor2));
                    } else {
                        this.logoLabText.put(hasSplit[0], new GUI.GuiLabelSrvInfo.ClassText(this.logoLabSize, CRT.replaceLang((Player)player, (String)hasSplit[1]), Font.Default, this.InfoColor, this.InfoColor2));
                    }
                } else {
                    this.logoLabText.put("I3", new GUI.GuiLabelSrvInfo.ClassText(this.logoLabSize, CRT.replaceLang((Player)player, (String)hasSplit[0]), Font.Default, this.InfoColor, this.InfoColor2));
                }
            }
            logoLab.setLabels(player, this.logoLabText, this.showSequence);
            logoLab.setPivot(PivotPosition.valueOf((String)this.infoPivot));
            player.setAttribute(this.attr.Label, (Object)logoLab);
        }
    }

    @EventMethod
    public void onGamemodeChange(PlayerChangeGamemodeEvent event) {
        GUI.GuiLabelSrvInfo _label;
        Player player;
        GUI.GuiImage _logo;
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] GamemodeChange ");
        }
        if ((_logo = (GUI.GuiImage)(player = event.getPlayer()).getAttribute(this.attr.Logo)) != null) {
            _logo.setPivotInChangeGamemode(PivotPosition.valueOf((String)this.WasserzeichenPivot), player);
        }
        if ((_label = (GUI.GuiLabelSrvInfo)player.getAttribute(this.attr.Label)) != null) {
            _label.setPivotInChangeGamemode(PivotPosition.valueOf((String)this.infoPivot), player);
        }
    }

    class ClassAttr {
        String Logo;
        String Label;

        ClassAttr() {
            this.Logo = ServerBranding.this.getDescription("name") + "-Logo";
            this.Label = ServerBranding.this.getDescription("name") + "-Label";
        }
    }
}

