/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class NetworkUtil {
    public void printAllOwnerMacs() {
        try {
            InetAddress[] ias = InetAddress.getAllByName(this.getOwnerHostName());
            if (ias != null) {
                for (InetAddress ia : ias) {
                    System.out.println(ia.getHostAddress());
                }
            }
        }
        catch (UnknownHostException e) {
            System.err.println("Unbekannter Hostname");
        }
    }

    public String getOwnerHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCanonicalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getOwnerNetworkDeviceName() {
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            if (ni != null) {
                return ni.getDisplayName();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getOwnerMac() {
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            byte[] hwa = ni.getHardwareAddress();
            if (hwa == null) {
                return null;
            }
            String mac = "";
            for (int i = 0; i < hwa.length; ++i) {
                mac = mac + String.format("%x:", hwa[i]);
            }
            if (mac.length() > 0 && !ni.isLoopback()) {
                return mac.toLowerCase().substring(0, mac.length() - 1);
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getOwnerIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }
}

