/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import java.util.ArrayList;
import net.risingworld.api.Timer;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.worldelements.World3DModel;

public class _3D {
    public static World3DModel create3DModel(ModelInformation model, ImageInformation texture, Crosshair cross, boolean LightingEnabled, boolean Interactable, CollisionShape CollisionShape2, float Scale, float TextureScale) {
        World3DModel Model = new World3DModel(model, texture);
        Model.setLightingEnabled(LightingEnabled);
        Model.setInteractable(Interactable);
        Model.setInteractionCrosshair(cross);
        Model.setCollisionShape(CollisionShape2);
        Model.setScale(Scale);
        Model.setTextureScale(TextureScale);
        return Model;
    }

    public final class World3DMultiModel
    extends World3DModel {
        private final ArrayList<World3DModel> models;
        private int debug;
        private int modelsNr;
        Timer ani;
        float interval;
        float delay;
        int repit;
        Runnable timerRun;

        public int getModelMax() {
            return this.models.size() - 1;
        }

        public int getModelsNr() {
            return this.modelsNr;
        }

        public World3DMultiModel(ArrayList<World3DModel> models) {
            super(models.get(0).getModel(), models.get(0).getTexture());
            this.debug = 3;
            this.interval = 5.0f;
            this.delay = 0.0f;
            this.repit = -1;
            this.timerRun = () -> {
                if (this.modelsNr + 1 >= models.size()) {
                    this.setModel(0);
                } else {
                    this.setModel(this.modelsNr + 1);
                }
                if (this.debug > 2) {
                    System.out.println("[] World3DMultiModel run Liste setModel " + this.modelsNr);
                }
            };
            this.ani = new Timer(this.interval, this.delay, this.repit, this.timerRun);
            if (this.debug > 1) {
                System.out.println("[] Info 0.1 World3DMultiModel");
            }
            this.models = models;
            this.modelsNr = 0;
            this.handleModels();
            this.setModel(this.modelsNr);
        }

        public World3DMultiModel(World3DMultiModel models) {
            super(models.models.get(0).getModel(), models.models.get(0).getTexture());
            this.debug = 3;
            this.interval = 5.0f;
            this.delay = 0.0f;
            this.repit = -1;
            this.timerRun = () -> {
                if (this.modelsNr + 1 >= models.models.size()) {
                    this.setModel(0);
                } else {
                    this.setModel(this.modelsNr + 1);
                }
                if (this.debug > 2) {
                    System.out.println("[] World3DMultiModel run Model setModel " + this.modelsNr);
                }
            };
            this.ani = new Timer(this.interval, this.delay, this.repit, this.timerRun);
            if (this.debug > 1) {
                System.out.println("[] Info 0.2 World3DMultiModel");
            }
            this.models = new ArrayList<World3DModel>(models.models);
            this.modelsNr = 0;
            this.setModel(this.modelsNr);
            this.handleModels();
        }

        private void handleModels() {
            this.models.forEach(modles -> {
                if (this.debug > 0) {
                    System.out.println("[] Model[" + modles.getModel().getFilename() + "]\tTextur[" + modles.getTexture().getFilename() + "]");
                }
            });
        }

        public void setModel(int modelNr) {
            if (this.models.size() > 0) {
                if (modelNr < 0) {
                    modelNr = 0;
                }
                if (modelNr >= this.models.size()) {
                    modelNr = this.models.size() - 1;
                }
                this.modelsNr = modelNr;
                if (this.debug > 1) {
                    System.out.println("[] World3DMultiModel in setModel " + this.modelsNr + "\t" + (Object)((Object)this));
                }
                this.setTexture(this.models.get(modelNr).getTexture());
                this.setModel(this.models.get(modelNr).getModel());
                this.setHittable(this.models.get(modelNr).isHittable());
                this.setInteractable(this.models.get(modelNr).isInteractable());
                this.setLightingEnabled(this.models.get(modelNr).isLightingEnabled());
                this.setListenForCollisions(this.models.get(modelNr).isListeningForCollisions());
                this.setInteractionCrosshair(this.models.get(modelNr).getInteractionCrosshair());
            }
        }
    }
}

