/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.CRT;
import de.chaoswg.SprachAPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import net.risingworld.api.Plugin;
import net.risingworld.api.objects.Player;

class MSG {
    private final Plugin plugin;
    private final String memo;
    private File memoDir;
    private int debug;
    private FilenameFilter filter;

    MSG(Plugin plugin) {
        this.plugin = plugin;
        this.memo = CRT.getSpec() + "memo";
    }

    public void onEnable(int debug) {
        this.debug = debug;
        this.memoDir = new File(this.plugin.getPath() + this.memo);
        if (this.memoDir.mkdirs() && debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Verzeichnis [" + this.memoDir.getName() + "] erstellt.");
        }
        this.filter = (dir, name) -> name.toLowerCase().endsWith(".memo");
        SprachAPI.SortedProperties textConfig = new SprachAPI.SortedProperties();
        for (File file : this.memoDir.listFiles(this.filter)) {
            if (debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] Memo File " + file.getName());
            }
            try {
                textConfig.load(new FileInputStream(file.getAbsolutePath()));
                textConfig.stringPropertyNames().forEach(t -> {
                    if (debug > 2) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] Memo File prop " + t + " = " + textConfig.getProperty((String)t));
                    }
                });
            }
            catch (IOException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Fehler " + e.getMessage());
            }
        }
    }

    public void onPlayerConnect(Player player) {
    }

    public void show(Player player, String text, BildSet bildSet, float delay) {
        this.show(player, text, bildSet, delay, false);
    }

    public void show(Player player, String text, BildSet bildSet, float delay, boolean chat) {
        this.show(player, text, bildSet, delay, chat, false);
    }

    public void show(Player player, String text, BildSet bildSet, float delay, boolean chat, boolean yell) {
        if (yell) {
            player.sendYellMessage(text.replaceAll("\\[#[0-9a-fA-F]{6}\\]", ""));
        } else if (chat) {
            player.sendTextMessage(text);
        }
    }

    public static class BildSet {
    }
}

