/*
 * Decompiled with CFR 0.152.
 */
package eu.hessenstrolche.willkommen;

import de.chaoswg.CRT;
import de.chaoswg.GetConfigDaten;
import de.chaoswg.SprachAPI;
import eu.hessenstrolche.willkommen.WillkommenClassText;
import eu.hessenstrolche.willkommen.WillkommenErrorSprachAPI;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class Willkommen
extends Plugin
implements Listener {
    Willkommen plugin;
    Server server;
    World world;
    private int debug;
    private int Timer;
    private String conf;
    private CRT crt;
    private int Schrift;
    private CRT.ClassLambadHelper lambTimerLabelEilkomm;
    private Timer showTimer;
    String requireSprachApiVersion;
    private SprachAPI sprachApiPlugin;
    private GetConfigDaten sysConfig;
    private WillkommenClassText sprachApiDaten;
    private String welcomeMessage = "";

    int getDebug() {
        return this.debug;
    }

    public void onEnable() {
        this.plugin = this;
        this.server = this.getServer();
        this.world = this.getWorld();
        this.crt = new CRT();
        this.conf = this.crt.getSpecP() + "config";
        this.debug = 1;
        this.Timer = 10;
        this.Schrift = 25;
        this.requireSprachApiVersion = "1.1.3";
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            this.sprachApiPlugin = (SprachAPI)this.plugin.getPluginByName("SprachAPI");
            if (this.crt.isSameVersion(this.requireSprachApiVersion, this.sprachApiPlugin.getDescription("version"), new CRT.ClassDebug((Plugin)this.plugin, 3))) {
                this.sprachApiDaten = new WillkommenClassText();
                this.sprachApiDaten.setDebug(this.debug);
                this.sprachApiDaten.setDir(this.conf + this.sprachApiDaten.getDir());
                this.sprachApiDaten.INI(this.plugin);
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ") OK");
                }
                String[][] sysConfigArray = new String[][]{{"command", "welkomm"}, {"Debug", String.valueOf(this.debug)}, {"Timer", String.valueOf(this.Timer)}, {"Size", String.valueOf(this.Schrift)}};
                this.sysConfig = new GetConfigDaten("System", sysConfigArray, (Plugin)this, this.debug, this.conf);
                this.debug = Integer.parseInt(this.sysConfig.getValue("Debug"));
                this.Timer = Integer.parseInt(this.sysConfig.getValue("Timer"));
                this.Schrift = Integer.parseInt(this.sysConfig.getValue("Size"));
                this.registerEventListener(this);
            } else {
                System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Die Version von Plugin 'SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ")' ist zu klein! Bitte Aktualisieren auf Version(" + this.requireSprachApiVersion + ")!");
                this.registerEventListener(new WillkommenErrorSprachAPI(this));
            }
        } else {
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Das Plugin 'SprachAPI' ist nicht installiert! Bitte installieren!");
            this.registerEventListener(new WillkommenErrorSprachAPI(this));
        }
    }

    public void onDisable() {
        this.unregisterEventListener(this);
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        GuiLabel label = new GuiLabel(0.5f, 0.5f, true);
        label.setColorCodesEnabled(true);
        label.setFontSize(this.Schrift);
        label.setPivot(PivotPosition.Center);
        label.setColor(100);
        label.setBorderColor(128);
        label.setBorderThickness(5.0f, false);
        label.setVisible(true);
        player.addGuiElement((GuiElement)label);
        player.setAttribute("welcomeLabel", (Object)label);
        this.lambTimerLabelEilkomm = new CRT.ClassLambadHelper();
        this.lambTimerLabelEilkomm.obj = player;
        ((GuiLabel)player.getAttribute("welcomeLabel")).setText("" + this.sprachApiDaten.getText(player, "MSG") + "");
        this.showTimer = new Timer(0.0f, (float)this.Timer, 0, () -> {
            if ((GuiLabel)((Player)this.lambTimerLabelEilkomm.obj).getAttribute("welcomeLabel") != null) {
                ((GuiLabel)((Player)this.lambTimerLabelEilkomm.obj).getAttribute("welcomeLabel")).setVisible(false);
            }
        });
        this.showTimer.start();
    }

    private String rwLabelText(String text, String begin) {
        return this.rwLabelText(text, begin, begin);
    }

    private String rwLabelText(String text, String begin, String end) {
        String ausgabe = null;
        String[] data = text.split("\n");
        if (data.length > 0) {
            int n;
            for (n = 0; n < data.length; ++n) {
                if (!data[n].startsWith(begin)) {
                    data[n] = begin + data[n];
                }
                if (data[n].endsWith(end)) continue;
                data[n] = data[n] + end;
            }
            ausgabe = "";
            for (n = 0; n < data.length; ++n) {
                if (n > 0) {
                    ausgabe = ausgabe + "\n";
                }
                ausgabe = ausgabe + data[n];
            }
        }
        return ausgabe;
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Player player = event.getPlayer();
        ((GuiLabel)((Player)this.lambTimerLabelEilkomm.obj).getAttribute("welcomeLabel")).destroy();
        this.showTimer.kill();
    }
}

