/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld.tools;

import de.omegazirkel.risingworld.tools.FileChangeListener;
import de.omegazirkel.risingworld.tools.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginChangeWatcher {
    private final WatchService watcher;
    private final Map<WatchKey, Path> keyPaths = new ConcurrentHashMap<WatchKey, Path>();
    private volatile Thread processingThread;
    private final FileChangeListener fcl;
    private static final Logger log = new Logger("[OZ.Tools]");

    public PluginChangeWatcher(FileChangeListener fcl) throws IOException {
        this.fcl = fcl;
        this.watcher = FileSystems.getDefault().newWatchService();
        log.out("Start WatchUpdates");
    }

    public void startListening() {
        this.processingThread = new Thread(){

            @Override
            public void run() {
                try {
                    PluginChangeWatcher.this.processFileNotifications();
                }
                catch (InterruptedException ex) {
                    log.out("Exception: " + ex.getMessage());
                    PluginChangeWatcher.this.processingThread = null;
                }
            }
        };
        this.processingThread.start();
    }

    public void shutDownListener() {
        Thread thr = this.processingThread;
        if (thr != null) {
            thr.interrupt();
        }
    }

    public void watchDir(File dir) throws IOException {
        Path p = dir.toPath();
        log.out("register " + p);
        WatchKey key = p.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keyPaths.put(key, p);
    }

    private void processFileNotifications() throws InterruptedException {
        while (true) {
            WatchKey key = this.watcher.take();
            Path dir = this.keyPaths.get(key);
            key.pollEvents().forEach(evt -> {
                Object o;
                WatchEvent.Kind eventType = evt.kind();
                if (eventType != StandardWatchEventKinds.OVERFLOW && (o = evt.context()) instanceof Path) {
                    Path path2 = (Path)o;
                    this.process(dir, path2, eventType);
                }
            });
            key.reset();
        }
    }

    private void process(Path dir, Path file, WatchEvent.Kind evtType) {
        if (evtType == StandardWatchEventKinds.ENTRY_MODIFY) {
            this.fcl.onFileChangeEvent(file);
        }
        if (evtType == StandardWatchEventKinds.ENTRY_CREATE && !file.toString().startsWith(".")) {
            this.fcl.onFileCreateEvent(file);
        }
    }
}

