/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld;

import de.omegazirkel.risingworld.GlobalIntercom;
import java.io.IOException;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;

@ClientEndpoint
public class WSClientEndpoint {
    private static WSClientEndpoint HIGHLANDER = null;
    Session session = null;
    private MessageHandler messageHandler;
    private URI endpointURI = null;
    public boolean isConnected = false;
    private ClientManager client;

    public static WSClientEndpoint getInstance(URI endpointURI) {
        if (HIGHLANDER == null) {
            HIGHLANDER = new WSClientEndpoint(endpointURI);
        }
        return HIGHLANDER;
    }

    private WSClientEndpoint(URI endpointURI) {
        this.endpointURI = endpointURI;
        this.client = ClientManager.createClient();
        ClientManager.ReconnectHandler reconnectHandler = new ClientManager.ReconnectHandler(){
            private int counter = 0;

            public boolean onDisconnect(CloseReason closeReason) {
                int i = ++this.counter;
                GlobalIntercom.log.out("WebSocket got disconnected: " + closeReason.toString(), 999);
                if (closeReason.getCloseCode() == CloseReason.CloseCodes.CLOSED_ABNORMALLY) {
                    GlobalIntercom.log.out("WebSocket reconnecting... " + i, 0);
                    return true;
                }
                GlobalIntercom.log.out("WebSocket not reconnecting.", 0);
                return false;
            }

            public boolean onConnectFailure(Exception exception) {
                int i = ++this.counter;
                GlobalIntercom.log.out("WebSocket failed to connect: " + exception.getMessage(), 999);
                GlobalIntercom.log.out("WebSocket reconnecting... " + i, 0);
                return true;
            }
        };
        this.client.getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", reconnectHandler);
        this.connect();
    }

    private void connect() {
        try {
            GlobalIntercom.log.out("WebSocket connecting to " + this.endpointURI, 0);
            this.session = this.client.connectToServer((Object)this, this.endpointURI);
        }
        catch (IOException | DeploymentException e) {
            GlobalIntercom.log.out(e.getMessage(), 999);
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        GlobalIntercom.log.out(t.toString(), 999);
    }

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        this.isConnected = true;
        GlobalIntercom.log.out("WebSocket connected!", 0);
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        this.session = null;
        this.isConnected = false;
        GlobalIntercom.log.out("WebSocket closed: " + reason.toString(), 999);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        if (this.messageHandler != null) {
            this.messageHandler.handleMessage(message);
        }
    }

    public void setMessageHandler(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void sendMessage(String message) {
        this.session.getAsyncRemote().sendText(message);
    }

    public static interface MessageHandler {
        public void handleMessage(String var1);
    }
}

