/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.omegazirkel.risingworld.ChatMessage;
import de.omegazirkel.risingworld.GlobalIntercomPlayer;
import de.omegazirkel.risingworld.PlayerCloseChannelMessage;
import de.omegazirkel.risingworld.PlayerCreateChannelMessage;
import de.omegazirkel.risingworld.PlayerJoinChannelMessage;
import de.omegazirkel.risingworld.PlayerLeaveChannelMessage;
import de.omegazirkel.risingworld.PlayerMessage;
import de.omegazirkel.risingworld.PlayerOfflineMessage;
import de.omegazirkel.risingworld.PlayerOnlineMessage;
import de.omegazirkel.risingworld.PlayerOverrideChangeMessage;
import de.omegazirkel.risingworld.PlayerRegisterMessage;
import de.omegazirkel.risingworld.PlayerUnregisterMessage;
import de.omegazirkel.risingworld.WSClientEndpoint;
import de.omegazirkel.risingworld.WSMessage;
import de.omegazirkel.risingworld.tools.I18n;
import de.omegazirkel.risingworld.tools.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;

public class GlobalIntercom
extends Plugin
implements Listener,
WSClientEndpoint.MessageHandler {
    static final String pluginVersion = "0.8.1-SNAPSHOT";
    static final String pluginName = "GlobalIntercom";
    static final Logger log = new Logger("[OZ.GI]");
    private static I18n t = null;
    static final String colorError = "[#FF0000]";
    static final String colorWarning = "[#808000]";
    static final String colorOkay = "[#00FF00]";
    static final String colorText = "[#EEEEEE]";
    static final String colorCommand = "[#997d4a]";
    static int logLevel = 0;
    static boolean restartOnUpdate = true;
    static boolean joinDefault = false;
    static URI webSocketURI;
    static String defaultChannel;
    static boolean sendMOTD;
    static String motd;
    static String colorOther;
    static String colorSelf;
    static String colorLocal;
    static WSClientEndpoint ws;
    static final Map<String, GlobalIntercomPlayer> playerMap;

    static {
        defaultChannel = "global";
        sendMOTD = false;
        motd = "[#EEEEEE]This Server uses [#00FF00]Global Intercom[#EEEEEE] Plugin. Type [#997d4a]/gi info[#EEEEEE] for more info";
        colorOther = "[#3881f7]";
        colorSelf = "[#37f7da]";
        colorLocal = "[#FFFFFF]";
        playerMap = new HashMap<String, GlobalIntercomPlayer>();
    }

    public void onEnable() {
        t = t != null ? t : new I18n((Plugin)this);
        this.registerEventListener(this);
        this.initSettings();
        this.initWebSocketClient();
    }

    private void transmitMessageWS(Player player, WSMessage<?> wsmsg) {
        GsonBuilder gsb = new GsonBuilder();
        Gson gson = gsb.create();
        String lang = player.getLanguage();
        try {
            if (GlobalIntercom.ws.isConnected) {
                String msg = gson.toJson(wsmsg);
                ws.sendMessage(msg);
            } else {
                player.sendTextMessage("[#FF0000]GlobalIntercom:> [#EEEEEE]" + t.get("MSG_WS_OFFLINE", lang));
            }
        }
        catch (Exception e) {
            player.sendTextMessage("[#FF0000]GlobalIntercom:>[#EEEEEE] " + e.getMessage());
            this.initWebSocketClient();
        }
    }

    public void onDisable() {
        try {
            if (ws != null) {
                GlobalIntercom.ws.session.close();
                ws = null;
            }
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(GlobalIntercom.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        PlayerOnlineMessage msg = new PlayerOnlineMessage(player);
        WSMessage<PlayerOnlineMessage> wsmsg = new WSMessage<PlayerOnlineMessage>("playerOnline", msg);
        this.transmitMessageWS(player, wsmsg);
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Player player = event.getPlayer();
        PlayerOfflineMessage msg = new PlayerOfflineMessage(player);
        WSMessage<PlayerOfflineMessage> wsmsg = new WSMessage<PlayerOfflineMessage>("playerOffline", msg);
        this.transmitMessageWS(player, wsmsg);
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        block42: {
            String option;
            Player player = event.getPlayer();
            String command = event.getCommand();
            String lang = event.getPlayer().getLanguage();
            GlobalIntercomPlayer giPlayer = playerMap.get(String.valueOf(player.getUID()));
            String[] cmd = command.split(" ");
            if (!cmd[0].equals("/gi")) break block42;
            switch (option = cmd[1]) {
                case "save": {
                    if (cmd.length > 2) {
                        WSMessage<PlayerMessage> wsmsg;
                        if (cmd[2].toLowerCase().contentEquals("true")) {
                            wsmsg = new WSMessage<PlayerRegisterMessage>("registerPlayer", new PlayerRegisterMessage(player));
                            this.transmitMessageWS(player, wsmsg);
                        } else {
                            wsmsg = new WSMessage<PlayerUnregisterMessage>("unregisterPlayer", new PlayerUnregisterMessage(player));
                            this.transmitMessageWS(player, wsmsg);
                        }
                    } else {
                        player.sendTextMessage("[#FF0000]GlobalIntercom:>[#EEEEEE]" + t.get("MSG_CMD_ERR_ARGUMENTS", lang).replace("PH_CMD", colorError + command + colorText).replace("PH_COMMAND_HELP", "[#997d4a]/gi save true|false\n[#EEEEEE]"));
                    }
                }
                case "create": {
                    if (cmd.length > 2) {
                        PlayerCreateChannelMessage msg = new PlayerCreateChannelMessage(player);
                        msg.channel = cmd[2].toLowerCase();
                        if (cmd.length > 3) {
                            msg.password = cmd[3];
                        }
                        WSMessage<PlayerCreateChannelMessage> wsmsg = new WSMessage<PlayerCreateChannelMessage>("playerCreateChannel", msg);
                        this.transmitMessageWS(player, wsmsg);
                        break;
                    }
                    player.sendTextMessage("[#FF0000]GlobalIntercom:>[#EEEEEE]" + t.get("MSG_CMD_ERR_ARGUMENTS", lang).replace("PH_CMD", colorError + command + colorText).replace("PH_COMMAND_HELP", "[#997d4a]/gi create channelname [password]\n[#EEEEEE]"));
                    break;
                }
                case "close": {
                    if (cmd.length > 2) {
                        PlayerCloseChannelMessage msg = new PlayerCloseChannelMessage(player);
                        msg.channel = cmd[2].toLowerCase();
                        WSMessage<PlayerCloseChannelMessage> wsmsg = new WSMessage<PlayerCloseChannelMessage>("playerCloseChannel", msg);
                        this.transmitMessageWS(player, wsmsg);
                        break;
                    }
                    player.sendTextMessage("[#FF0000]GlobalIntercom:>[#EEEEEE]" + t.get("MSG_CMD_ERR_ARGUMENTS", lang).replace("PH_CMD", colorError + command + colorText).replace("PH_COMMAND_HELP", "[#997d4a]/gi close channelname\n[#EEEEEE]"));
                    break;
                }
                case "join": {
                    PlayerJoinChannelMessage msg = new PlayerJoinChannelMessage(player);
                    msg.channel = cmd[2].toLowerCase();
                    if (cmd.length > 3) {
                        msg.password = cmd[3];
                    }
                    WSMessage<PlayerJoinChannelMessage> wsmsg = new WSMessage<PlayerJoinChannelMessage>("playerJoinChannel", msg);
                    this.transmitMessageWS(player, wsmsg);
                    break;
                }
                case "leave": {
                    PlayerLeaveChannelMessage msg = new PlayerLeaveChannelMessage(player);
                    msg.channel = cmd[2].toLowerCase();
                    WSMessage<PlayerLeaveChannelMessage> wsmsg = new WSMessage<PlayerLeaveChannelMessage>("playerLeaveChannel", msg);
                    this.transmitMessageWS(player, wsmsg);
                    break;
                }
                case "help": 
                case "info": {
                    String infoMessage = t.get("MSG_CMD_INFO", lang).replace("PH_CMD_JOIN", "[#997d4a]/gi join channelname [password][#EEEEEE]").replace("PH_CMD_LEAVE", "[#997d4a]/gi leave channelname[#EEEEEE]").replace("PH_CMD_CHAT_DEFAULT", "[#997d4a]#HelloWorld[#EEEEEE]").replace("PH_CMD_CHAT_OTHER", "[#997d4a]##other HelloWorld[#EEEEEE]").replace("PH_CMD_CHAT_LOCAL", "[#997d4a]#%local HelloWorld[#EEEEEE]").replace("PH_CMD_OVERRIDE", "[#997d4a]/gi override true|false[#EEEEEE]").replace("PH_CMD_HELP", "[#997d4a]/gi help|info[#EEEEEE]").replace("PH_CMD_STATUS", "[#997d4a]/gi status[#EEEEEE]").replace("PH_CMD_CREATE", "[#997d4a]/gi create channelname [password][#EEEEEE]").replace("PH_CMD_CLOSE", "[#997d4a]/gi close channelname[#EEEEEE]").replace("PH_CMD_SAVE", "[#997d4a]/gi save true|false[#EEEEEE]");
                    player.sendTextMessage("[#00FF00]GlobalIntercom:> " + infoMessage);
                    break;
                }
                case "status": {
                    String lastCH = "lokal";
                    if (player.hasAttribute("gilastch")) {
                        lastCH = (String)player.getAttribute("gilastch");
                    }
                    String wsStatus = colorError + t.get("STATE_DISCONNECTED", lang);
                    if (GlobalIntercom.ws.isConnected) {
                        wsStatus = colorOkay + t.get("STATE_CONNECTED", lang);
                    }
                    String saveStatus = colorError + t.get("STATE_INACTIVE", lang);
                    if (giPlayer.saveSettings) {
                        saveStatus = colorOkay + t.get("STATE_ACTIVE", lang);
                    }
                    String overrideStatus = "";
                    overrideStatus = giPlayer.override ? colorOkay + t.get("STATE_ON", lang) : colorError + t.get("STATE_OFF", lang);
                    String statusMessage = t.get("MSG_CMD_STATUS", lang).replace("PH_VERSION", "[#00FF00]0.8.1-SNAPSHOT[#EEEEEE]").replace("PH_LANGUAGE", String.valueOf(colorSelf) + lang + " / " + player.getSystemLanguage() + colorText).replace("PH_USEDLANG", String.valueOf(colorOther) + t.getLanguageUsed(lang) + colorText).replace("PH_STATE_WS", String.valueOf(wsStatus) + colorText).replace("PH_STATE_CH", colorCommand + lastCH + colorText).replace("PH_STATE_SAVE", String.valueOf(saveStatus) + colorText).replace("PH_STATE_OR", String.valueOf(overrideStatus) + colorText).replace("PH_CHLIST", colorCommand + giPlayer.getChannelList() + colorText);
                    player.sendTextMessage("[#00FF00]GlobalIntercom:> " + statusMessage);
                    break;
                }
                case "override": {
                    if (cmd.length > 2) {
                        PlayerOverrideChangeMessage msg = new PlayerOverrideChangeMessage(player);
                        msg.override = cmd[2].toLowerCase().contentEquals("true");
                        WSMessage<PlayerOverrideChangeMessage> wsmsg = new WSMessage<PlayerOverrideChangeMessage>("playerOverrideChange", msg);
                        this.transmitMessageWS(player, wsmsg);
                        break;
                    }
                    String message = "[#00FF00]GlobalIntercom:> [#EEEEEE]" + t.get("MSG_CMD_OVERRIDE_NOTSET", lang).replace("PH_CMD", "[#997d4a]/gi override [true|false] [#EEEEEE]");
                    player.sendTextMessage(message);
                    break;
                }
                default: {
                    player.sendTextMessage("[#FF0000]GlobalIntercom:> [#EEEEEE]" + t.get("MSG_ERR_CMD_UNKNOWN_OPTION", lang).replace("PH_OPTION", option));
                }
            }
        }
    }

    public boolean isGIMessage(PlayerChatEvent event) {
        boolean isValidLastChannel;
        Player player = event.getPlayer();
        String message = event.getChatMessage();
        String noColorText = message.replaceFirst("(\\[#[a-fA-F]+\\])", "");
        GlobalIntercomPlayer giPlayer = playerMap.get(String.valueOf(player.getUID()));
        boolean override = giPlayer.override;
        boolean bl = isValidLastChannel = override && player.hasAttribute("gilastch") && giPlayer.isInChannel((String)player.getAttribute("gilastch"));
        return noColorText.startsWith("#") || isValidLastChannel && !noColorText.startsWith("#%");
    }

    @EventMethod
    public void onPlayerChat(PlayerChatEvent event) {
        String chatMessage;
        String channel;
        Player player = event.getPlayer();
        Server server = this.getServer();
        String message = event.getChatMessage();
        String lang = event.getPlayer().getLanguage();
        String noColorText = message.replaceFirst("(\\[#[a-fA-F]+\\])", "");
        GlobalIntercomPlayer giPlayer = playerMap.get(String.valueOf(player.getUID()));
        if (giPlayer == null) {
            if (noColorText.startsWith("#")) {
                player.sendTextMessage("[#FF0000]GlobalIntercom:> [#EEEEEE]" + t.get("MSG_ERR_GI_INIT", lang));
                event.setCancelled(true);
            }
            return;
        }
        boolean override = giPlayer.override;
        if (noColorText.startsWith("#%")) {
            player.deleteAttribute("gilastch");
            if (noColorText.substring(2).length() > 0) {
                event.setChatMessage(String.valueOf(colorLocal) + noColorText.substring(2));
            } else {
                player.sendTextMessage("[#00FF00]GlobalIntercom:>[#EEEEEE]" + t.get("MSG_INFO_CH_DEFAULT_RESET", lang));
                event.setCancelled(true);
            }
            return;
        }
        if (noColorText.startsWith("#")) {
            if (noColorText.startsWith("##")) {
                String[] msgParts = noColorText.substring(2).split(" ", 2);
                channel = msgParts[0].toLowerCase();
                chatMessage = msgParts[1];
            } else {
                channel = defaultChannel;
                chatMessage = noColorText.substring(1);
            }
            if (channel.length() > 20) {
                player.sendTextMessage("[#FF0000]GlobalIntercom:> [#EEEEEE]" + t.get("MSG_ERR_CH_LENGTH", lang).replace("PH_CHANNEL", channel));
                event.setCancelled(true);
                return;
            }
            if (channel.length() < 3) {
                player.sendTextMessage("[#FF0000]GlobalIntercom:>[#EEEEEE]" + t.get("MSG_ERR_CH_LENGTH", lang).replace("PH_CHANNEL", channel));
                event.setCancelled(true);
                return;
            }
            if (!giPlayer.isInChannel(channel)) {
                player.sendTextMessage("[#FF0000]GlobalIntercom:>[#EEEEEE]" + t.get("MSG_ERR_CH_NOMEMBER", lang).replace("PH_CHANNEL", channel) + "\n" + t.get("MSG_INFO_CH_JOIN", lang).replace("PH_CMD_JOIN", "[#997d4a]/gi join " + channel + colorText));
                event.setCancelled(true);
                return;
            }
            if (override) {
                player.setAttribute("gilastch", (Object)channel);
            }
        } else if (player.hasAttribute("gilastch") && override) {
            channel = (String)player.getAttribute("gilastch");
            chatMessage = noColorText;
        } else {
            event.setChatMessage(String.valueOf(colorLocal) + noColorText);
            return;
        }
        if (!giPlayer.isInChannel(channel)) {
            player.deleteAttribute("gilastch");
            event.setChatMessage(String.valueOf(colorLocal) + noColorText);
            return;
        }
        event.setCancelled(true);
        ChatMessage cmsg = new ChatMessage(player, server, chatMessage, channel);
        WSMessage<ChatMessage> wsbcm = new WSMessage<ChatMessage>("broadcastMessage", cmsg);
        GsonBuilder gsb = new GsonBuilder();
        Gson gson = gsb.create();
        try {
            if (GlobalIntercom.ws.isConnected) {
                String msg = gson.toJson(wsbcm);
                ws.sendMessage(msg);
            } else {
                player.sendTextMessage("[#FF0000]GlobalIntercom:> [#EEEEEE]" + t.get("MSG_WS_OFFLINE", lang));
            }
        }
        catch (Exception e) {
            player.sendTextMessage("[#FF0000]GlobalIntercom:>[#EEEEEE] " + e.getMessage());
            this.initWebSocketClient();
        }
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        if (sendMOTD) {
            Player player = event.getPlayer();
            player.sendTextMessage(motd);
        }
    }

    private void initWebSocketClient() {
        try {
            ws = WSClientEndpoint.getInstance(webSocketURI);
            ws.setMessageHandler(this);
        }
        catch (Exception e) {
            log.out(e.getMessage(), 999);
        }
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(new InputStreamReader((InputStream)in, "UTF8"));
            in.close();
            logLevel = Integer.parseInt(settings.getProperty("logLevel"));
            webSocketURI = new URI(settings.getProperty("webSocketURI"));
            defaultChannel = settings.getProperty("defaultChannel");
            joinDefault = settings.getProperty("joinDefault").contentEquals("true");
            colorOther = settings.getProperty("colorOther");
            colorSelf = settings.getProperty("colorSelf");
            colorLocal = settings.getProperty("colorLocal");
            sendMOTD = settings.getProperty("sendMOTD").contentEquals("true");
            motd = settings.getProperty("motd");
            restartOnUpdate = settings.getProperty("restartOnUpdate").contentEquals("true");
            log.out("GlobalIntercom Plugin is enabled", 10);
        }
        catch (IOException ex) {
            log.out("IOException on initSettings: " + ex.getMessage(), 100);
        }
        catch (NumberFormatException ex) {
            log.out("NumberFormatException on initSettings: " + ex.getMessage(), 100);
        }
        catch (URISyntaxException ex) {
            log.out("Exception on initSettings: " + ex.getMessage(), 100);
        }
    }

    private void broadcastMessage(ChatMessage cmsg) {
        this.getServer().getAllPlayers().forEach(player -> {
            if (!playerMap.containsKey(String.valueOf(player.getUID()))) {
                return;
            }
            GlobalIntercomPlayer gip = playerMap.get(String.valueOf(player.getUID()));
            if (gip.isInChannel(chatMessage.chatChannel)) {
                String color = colorOther;
                if (String.valueOf(player.getUID()).contentEquals(chatMessage.playerUID)) {
                    color = colorSelf;
                }
                player.sendTextMessage(String.valueOf(color) + "[" + chatMessage.chatChannel.toUpperCase() + "] " + chatMessage.playerName + ": " + colorText + chatMessage.chatContent);
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public void handleMessage(String message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[13] lbl209 : CaseStatement: default:\u000a, @NONE, blocks:[13] lbl209 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

