/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorHandlerTask;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.JdkVersion;

public class DefaultSelectorHandler
implements SelectorHandler {
    private static final long DEFAULT_SELECT_TIMEOUT_MILLIS = 30000L;
    private static final Logger logger = Grizzly.logger(DefaultSelectorHandler.class);
    public static final boolean IS_WORKAROUND_SELECTOR_SPIN = Boolean.getBoolean(DefaultSelectorHandler.class.getName() + ".force-selector-spin-detection") || System.getProperty("os.name").equalsIgnoreCase("linux") && JdkVersion.getJdkVersion().compareTo("1.7.0") < 0;
    protected final long selectTimeout;
    private static final int SPIN_RATE_THRESHOLD = 2000;

    public DefaultSelectorHandler() {
        this(30000L, TimeUnit.MILLISECONDS);
    }

    public DefaultSelectorHandler(long selectTimeout, TimeUnit timeunit) {
        this.selectTimeout = TimeUnit.MILLISECONDS.convert(selectTimeout, timeunit);
    }

    @Override
    public long getSelectTimeout() {
        return this.selectTimeout;
    }

    @Override
    public boolean preSelect(SelectorRunner selectorRunner) throws IOException {
        return this.processPendingTasks(selectorRunner);
    }

    @Override
    public Set<SelectionKey> select(SelectorRunner selectorRunner) throws IOException {
        boolean hasPostponedTasks;
        Selector selector = selectorRunner.getSelector();
        boolean bl = hasPostponedTasks = !selectorRunner.getPostponedTasks().isEmpty();
        if (!hasPostponedTasks) {
            selector.select(this.selectTimeout);
        } else {
            selector.selectNow();
        }
        Set<SelectionKey> selectedKeys = selector.selectedKeys();
        if (IS_WORKAROUND_SELECTOR_SPIN) {
            selectorRunner.checkSelectorSpin(!selectedKeys.isEmpty() || hasPostponedTasks, 2000);
        }
        return selectedKeys;
    }

    @Override
    public void postSelect(SelectorRunner selectorRunner) throws IOException {
    }

    @Override
    public void registerKeyInterest(SelectorRunner selectorRunner, SelectionKey key, int interest) throws IOException {
        if (DefaultSelectorHandler.isSelectorRunnerThread(selectorRunner)) {
            DefaultSelectorHandler.registerKey0(key, interest);
        } else {
            selectorRunner.addPendingTask(new RegisterKeyTask(key, interest));
        }
    }

    private static void registerKey0(SelectionKey selectionKey, int interest) {
        int currentOps;
        if (selectionKey.isValid() && ((currentOps = selectionKey.interestOps()) & interest) != interest) {
            selectionKey.interestOps(currentOps | interest);
        }
    }

    @Override
    public void deregisterKeyInterest(SelectorRunner selectorRunner, SelectionKey key, int interest) throws IOException {
        int currentOps;
        if (key.isValid() && ((currentOps = key.interestOps()) & interest) != 0) {
            key.interestOps(currentOps & ~interest);
        }
    }

    @Override
    public void registerChannel(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment) throws IOException {
        SafeFutureImpl future = SafeFutureImpl.create();
        this.registerChannelAsync(selectorRunner, channel, interest, attachment, Futures.toCompletionHandler(future));
        try {
            future.get(this.selectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void registerChannelAsync(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) {
        if (DefaultSelectorHandler.isSelectorRunnerThread(selectorRunner)) {
            DefaultSelectorHandler.registerChannel0(selectorRunner, channel, interest, attachment, completionHandler);
        } else {
            this.addPendingTask(selectorRunner, new RegisterChannelOperation(channel, interest, attachment, completionHandler));
        }
    }

    @Override
    public void deregisterChannel(SelectorRunner selectorRunner, SelectableChannel channel) throws IOException {
        SafeFutureImpl future = SafeFutureImpl.create();
        this.deregisterChannelAsync(selectorRunner, channel, Futures.toCompletionHandler(future));
        try {
            future.get(this.selectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void deregisterChannelAsync(SelectorRunner selectorRunner, SelectableChannel channel, CompletionHandler<RegisterChannelResult> completionHandler) {
        if (DefaultSelectorHandler.isSelectorRunnerThread(selectorRunner)) {
            DefaultSelectorHandler.deregisterChannel0(selectorRunner, channel, completionHandler);
        } else {
            this.addPendingTask(selectorRunner, new DeregisterChannelOperation(channel, completionHandler));
        }
    }

    @Override
    public void execute(SelectorRunner selectorRunner, SelectorHandler.Task task, CompletionHandler<SelectorHandler.Task> completionHandler) {
        block5: {
            if (DefaultSelectorHandler.isSelectorRunnerThread(selectorRunner)) {
                try {
                    task.run();
                    if (completionHandler != null) {
                        completionHandler.completed(task);
                    }
                    break block5;
                }
                catch (Exception e) {
                    if (completionHandler != null) {
                        completionHandler.failed(e);
                    }
                    break block5;
                }
            }
            this.addPendingTask(selectorRunner, new RunnableTask(task, completionHandler));
        }
    }

    @Override
    public void enque(SelectorRunner selectorRunner, SelectorHandler.Task task, CompletionHandler<SelectorHandler.Task> completionHandler) {
        if (DefaultSelectorHandler.isSelectorRunnerThread(selectorRunner)) {
            Queue<SelectorHandlerTask> postponedTasks = selectorRunner.getPostponedTasks();
            postponedTasks.offer(new RunnableTask(task, completionHandler));
        } else {
            this.addPendingTask(selectorRunner, new RunnableTask(task, completionHandler));
        }
    }

    private void addPendingTask(SelectorRunner selectorRunner, SelectorHandlerTask task) {
        if (selectorRunner == null) {
            task.cancel();
            return;
        }
        selectorRunner.addPendingTask(task);
        if (selectorRunner.isStop() && selectorRunner.getPendingTasks().remove(task)) {
            task.cancel();
        }
    }

    private boolean processPendingTasks(SelectorRunner selectorRunner) throws IOException {
        return this.processPendingTaskQueue(selectorRunner, selectorRunner.obtainPostponedTasks()) && (!selectorRunner.hasPendingTasks || this.processPendingTaskQueue(selectorRunner, selectorRunner.getPendingTasks()));
    }

    private boolean processPendingTaskQueue(SelectorRunner selectorRunner, Queue<SelectorHandlerTask> selectorHandlerTasks) throws IOException {
        SelectorHandlerTask selectorHandlerTask;
        while ((selectorHandlerTask = selectorHandlerTasks.poll()) != null) {
            if (selectorHandlerTask.run(selectorRunner)) continue;
            return false;
        }
        return true;
    }

    private static void registerChannel0(SelectorRunner selectorRunner, SelectableChannel channel, int interest, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) {
        try {
            if (channel.isOpen()) {
                Selector selector = selectorRunner.getSelector();
                SelectionKey key = channel.keyFor(selector);
                if (key == null || key.isValid()) {
                    SelectionKey registeredSelectionKey = channel.register(selector, interest, attachment);
                    selectorRunner.getTransport().getSelectionKeyHandler().onKeyRegistered(registeredSelectionKey);
                    RegisterChannelResult result = new RegisterChannelResult(selectorRunner, registeredSelectionKey, channel);
                    if (completionHandler != null) {
                        completionHandler.completed(result);
                    }
                } else {
                    Queue<SelectorHandlerTask> postponedTasks = selectorRunner.getPostponedTasks();
                    RegisterChannelOperation operation = new RegisterChannelOperation(channel, interest, attachment, completionHandler);
                    postponedTasks.add(operation);
                }
            } else {
                DefaultSelectorHandler.failChannelRegistration(completionHandler, new ClosedChannelException());
            }
        }
        catch (IOException e) {
            DefaultSelectorHandler.failChannelRegistration(completionHandler, e);
        }
    }

    private static void failChannelRegistration(CompletionHandler<RegisterChannelResult> completionHandler, Throwable error) {
        if (completionHandler != null) {
            completionHandler.failed(error);
        }
    }

    private static void deregisterChannel0(SelectorRunner selectorRunner, SelectableChannel channel, CompletionHandler<RegisterChannelResult> completionHandler) {
        try {
            Exception error;
            if (channel.isOpen()) {
                Selector selector = selectorRunner.getSelector();
                SelectionKey key = channel.keyFor(selector);
                if (key != null) {
                    selectorRunner.getTransport().getSelectionKeyHandler().cancel(key);
                    selectorRunner.getTransport().getSelectionKeyHandler().onKeyDeregistered(key);
                    RegisterChannelResult result = new RegisterChannelResult(selectorRunner, key, channel);
                    if (completionHandler != null) {
                        completionHandler.completed(result);
                    }
                    return;
                }
                error = new IllegalStateException("Channel is not registered");
            } else {
                error = new ClosedChannelException();
            }
            Futures.notifyFailure(null, completionHandler, error);
        }
        catch (IOException e) {
            Futures.notifyFailure(null, completionHandler, e);
        }
    }

    @Override
    public boolean onSelectorClosed(SelectorRunner selectorRunner) {
        try {
            selectorRunner.workaroundSelectorSpin();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSelectorRunnerThread(SelectorRunner selectorRunner) {
        return selectorRunner != null && Thread.currentThread() == selectorRunner.getRunnerThread();
    }

    protected static final class DeregisterChannelOperation
    implements SelectorHandlerTask {
        private final SelectableChannel channel;
        private final CompletionHandler<RegisterChannelResult> completionHandler;

        private DeregisterChannelOperation(SelectableChannel channel, CompletionHandler<RegisterChannelResult> completionHandler) {
            this.channel = channel;
            this.completionHandler = completionHandler;
        }

        @Override
        public boolean run(SelectorRunner selectorRunner) throws IOException {
            DefaultSelectorHandler.deregisterChannel0(selectorRunner, this.channel, this.completionHandler);
            return true;
        }

        @Override
        public void cancel() {
            if (this.completionHandler != null) {
                this.completionHandler.failed(new IOException("Selector is closed"));
            }
        }
    }

    protected static final class RunnableTask
    implements SelectorHandlerTask {
        private final SelectorHandler.Task task;
        private final CompletionHandler<SelectorHandler.Task> completionHandler;

        private RunnableTask(SelectorHandler.Task task, CompletionHandler<SelectorHandler.Task> completionHandler) {
            this.task = task;
            this.completionHandler = completionHandler;
        }

        @Override
        public boolean run(SelectorRunner selectorRunner) throws IOException {
            boolean continueExecution;
            block3: {
                continueExecution = true;
                try {
                    continueExecution = this.task.run();
                    if (this.completionHandler != null) {
                        this.completionHandler.completed(this.task);
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.FINEST, "doExecutePendiongIO failed.", t);
                    if (this.completionHandler == null) break block3;
                    this.completionHandler.failed(t);
                }
            }
            return continueExecution;
        }

        @Override
        public void cancel() {
            if (this.completionHandler != null) {
                this.completionHandler.failed(new IOException("Selector is closed"));
            }
        }
    }

    protected static final class RegisterChannelOperation
    implements SelectorHandlerTask {
        private final SelectableChannel channel;
        private final int interest;
        private final Object attachment;
        private final CompletionHandler<RegisterChannelResult> completionHandler;

        private RegisterChannelOperation(SelectableChannel channel, int interest, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) {
            this.channel = channel;
            this.interest = interest;
            this.attachment = attachment;
            this.completionHandler = completionHandler;
        }

        @Override
        public boolean run(SelectorRunner selectorRunner) throws IOException {
            DefaultSelectorHandler.registerChannel0(selectorRunner, this.channel, this.interest, this.attachment, this.completionHandler);
            return true;
        }

        @Override
        public void cancel() {
            if (this.completionHandler != null) {
                this.completionHandler.failed(new IOException("Selector is closed"));
            }
        }
    }

    protected static final class RegisterKeyTask
    implements SelectorHandlerTask {
        private final SelectionKey selectionKey;
        private final int interest;

        public RegisterKeyTask(SelectionKey selectionKey, int interest) {
            this.selectionKey = selectionKey;
            this.interest = interest;
        }

        @Override
        public boolean run(SelectorRunner selectorRunner) throws IOException {
            SelectionKey localSelectionKey = this.selectionKey;
            if (IS_WORKAROUND_SELECTOR_SPIN) {
                localSelectionKey = selectorRunner.checkIfSpinnedKey(this.selectionKey);
            }
            DefaultSelectorHandler.registerKey0(localSelectionKey, this.interest);
            return true;
        }

        @Override
        public void cancel() {
        }
    }
}

