
package net.risingworld;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.Listener;

/**
 *
 * @author My Name
 */
public class MyPlugin extends Plugin implements Listener {

    public static final String pluginVersion = "0.1.0";
    public static final String pluginName = "MyPlugin";
    public static final String pluginNameShort = "MP";

    static int logLevel = 0;
    static boolean booleanExample = false;
    static String StringExample = "Hello World";

    @Override
    public void onEnable() {
        initSettings();
    }

    @Override
    public void onDisable() {

    }

    private void initSettings() {
        Properties settings = new Properties();
        FileInputStream in;
        try {
            in = new FileInputStream(getPath() + "/settings.properties");
            settings.load(in);
            in.close();
            // fill global values
            logLevel = Integer.parseInt(settings.getProperty("logLevel", "0"));
            booleanExample = settings.getProperty("booleanExample", "false").contentEquals("true");
            StringExample = settings.getProperty("StringExample", "");

        } catch (IOException ex) {
            log("IOException on initSettings: " + ex.getMessage(), 100);
            // e.printStackTrace();
        } catch (NumberFormatException ex) {
            log("NumberFormatException on initSettings: " + ex.getMessage(), 100);
        } catch (Exception ex) {
            log("Exception on initSettings: " + ex.getMessage(), 100);
        }
    }

    /**
     *
     * @param text
     * @param level
     */
    private static void log(String text, int level) {
        if (level >= logLevel) {
            System.out.println("[" + pluginNameShort + "] " + text);
        }
    }
}