/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.action;

import carsten.risingworld.abm.action.RewardActionDelegate;
import carsten.risingworld.abm.action.RewardInteraction;
import carsten.risingworld.abm.data.Rancher;
import carsten.risingworld.abm.data.RancherMap;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;

public enum RewardAction implements RewardInteraction
{
    FOX(6, 60),
    MINIPIG(19, 100),
    PENGUIN(18, 50),
    RABBIT(8, 40),
    RAT(23, 100),
    NOOP(0, 0);

    private static final List<Integer> npcTypes;
    private final int npcType;
    private final int rewardPoints;
    private RewardActionDelegate execDelegate;
    private RewardActionDelegate denyDelegate;

    private RewardAction(int p_npcType, int points) {
        this.npcType = p_npcType;
        this.rewardPoints = points;
        this.denyDelegate = this.execDelegate = this.getNullDelegate();
    }

    @Override
    public void setDelegates(RewardActionDelegate p_execDelegate, RewardActionDelegate p_denyDelegate) {
        this.execDelegate = p_execDelegate;
        this.denyDelegate = p_denyDelegate;
    }

    @Override
    public void execute(Player player, WorldItem item) {
        if (!this.isInRange(player, item)) {
            return;
        }
        if (item.getRelatedPlayer() != player) {
            return;
        }
        Rancher rancher = RancherMap.get(player.getDbID());
        int currentPoints = rancher.getRewardCounter();
        if (currentPoints >= this.rewardPoints) {
            this.execDelegate.action(player, item, this.npcType);
        } else {
            this.denyDelegate.action(player, item, this.npcType);
        }
    }

    private boolean isInRange(Player player, WorldItem item) {
        float distance = item.getPosition().distance(player.getPosition());
        return distance <= 6.0f;
    }

    public int getRewardPoints() {
        return this.rewardPoints;
    }

    @Override
    public String actionName() {
        return "action.reward." + this.name();
    }

    static {
        npcTypes = new ArrayList<Integer>(25);
        for (RewardAction action : RewardAction.values()) {
            npcTypes.add(action.npcType);
        }
    }
}

