/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm;

import carsten.risingworld.abm.ABMChatNotification;
import carsten.risingworld.abm.ABMPreferencesHandler;
import carsten.risingworld.abm.ABMResourceBundle;
import carsten.risingworld.abm.ABMTimeStamp;
import carsten.risingworld.abm.ABMUtil;
import carsten.risingworld.abm.AnimalController;
import carsten.risingworld.abm.action.Action;
import carsten.risingworld.abm.action.AnimalInteraction;
import carsten.risingworld.abm.action.FeedAction;
import carsten.risingworld.abm.action.InteractionItem;
import carsten.risingworld.abm.action.RewardAction;
import carsten.risingworld.abm.action.RewardItems;
import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalMap;
import carsten.risingworld.abm.data.AnimalType;
import carsten.risingworld.abm.event.AnimalBornEvent;
import carsten.risingworld.abm.event.AnimalFollowLockedEvent;
import carsten.risingworld.abm.event.AnimalFollowStartEvent;
import carsten.risingworld.abm.event.AnimalFollowStopEvent;
import carsten.risingworld.abm.event.AnimalOwnerChangedEvent;
import carsten.risingworld.abm.event.AnimalOwnerReleasedEvent;
import carsten.risingworld.abm.event.AnimalPregnantEvent;
import carsten.risingworld.abm.event.AnimalProlificEvent;
import carsten.risingworld.abm.event.AnimalRenamedEvent;
import carsten.risingworld.abm.event.AnimalRewardEvent;
import carsten.risingworld.abm.event.AnimalSleepEvent;
import carsten.risingworld.abm.event.PlayerAnimalLimitReachedEvent;
import carsten.risingworld.abm.event.PlayerInsufficientPointsEvent;
import carsten.risingworld.abm.gui.AreYouSureGui;
import carsten.risingworld.abm.gui.RenameGui;
import carsten.risingworld.abm.util.FW;
import carsten.risingworld.abm.util.NumberFormats;
import carsten.risingworld.api.abm.ABMCommandInterface;
import carsten.risingworld.api.abm.AnimalBreedMasterPlugin;
import carsten.risingworld.api.abm.Rancher;
import java.io.File;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.RayCastResult;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldElement;

public final class AnimalBreedMaster
extends Plugin
implements Listener,
AnimalBreedMasterPlugin,
ABMCommandInterface {
    private static final float VERSION = 0.8f;
    private static final String SEP = FileSystems.getDefault().getSeparator();
    private static final int FEED_TIMER_SCALER;
    private static final int PROGRESS_TIMER_SCALER;
    private static final int GENERAL_TIMER_SCALER;
    private static final int GENERAL_TIMER_SCALER2;
    private static final float INTERVAL;
    private static final int COLLISIONTYPES = 441;
    private static final Map<Player, CallbackRayCastResult> playerCallbackResultMap;
    private static final int NUM_FEED_OWN = 4;
    private static final int NUM_FEED_PROLIFIC = 3;
    private static final int MIN_PREG_TIME = 6000;
    private static final int REV_PREG_TIME = 120;
    private static final int PROGRESS_INTERVAL = 6;
    private static final int GENERAL_INTERVAL = 20;
    private static final int GENERAL_INTERVAL2 = 10;
    private static final int FEED_PROGRESS_BONUS_TIME = 300;
    private static final float MIN_RUN_DISTANCE = 10.0f;
    private static final float MAX_APPROACH_DISTANCE = 4.0f;
    private final Runnable timerTask_FP = this::timerTask;
    private Timer actionTimer;
    private int feedTimerLoop;
    private int progressTimerLoop;
    private int generalTimerLoop1;
    private int generalTimerLoop2;

    public AnimalBreedMaster() {
        AnimalMap.setNpcFetcher(this::getNpc);
        Action.FOLLOW.setDelegates(this::tagAnimalToFollowAction, null);
        Action.INVINCIBLE.setDelegates(this::setAnimalInvincibleAction, null);
        Action.LOCKED.setDelegates(this::lockAnimalAction, null);
        Action.RELEASE.setDelegates(this::showAnimalReleaseGui, null);
        Action.RENAME.setDelegates(this::showAnimalRenameGui, null);
        Action.REWARDPOINTS.setDelegates(this::showRewardPoints, null);
        for (FeedAction feedAction : FeedAction.values()) {
            feedAction.setDelegates(this::feedAction, this::noThanks);
        }
        for (Enum enum_ : RewardAction.values()) {
            ((RewardAction)enum_).setDelegates(this::rewardAction, this::noReward);
        }
    }

    @Override
    public AnimalBreedMasterPlugin getAnimalBreedMasterPlugin() {
        return this;
    }

    @Override
    public ABMCommandInterface getCommandInterface() {
        return this;
    }

    public void onEnable() {
        ABMPreferencesHandler.init(this);
        AnimalController.enable(this, 0.8f);
        this.registerEventListener(this);
        ABMChatNotification.enable(this);
        InteractionItem.toggleInvincibleAction();
        InteractionItem.toggleRenameAction();
        InteractionItem.toggleRewardSystem();
        if (this.actionTimer != null) {
            this.actionTimer.kill();
        }
        this.actionTimer = new Timer(INTERVAL, 1.0f, -1, this.timerTask_FP);
        this.actionTimer.start();
    }

    public void onDisable() {
        this.actionTimer.kill();
        this.unregisterEventListener(this);
        ABMChatNotification.disable();
        AnimalController.disable();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerConnectEvent(PlayerConnectEvent evt) {
        Player player = evt.getPlayer();
        ABMUtil.initBundle(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent evt) {
        Player player = evt.getPlayer();
        ABMUtil.removeBundle(player);
        playerCallbackResultMap.remove(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerSpawnEvent(PlayerSpawnEvent evt) {
        Player player = evt.getPlayer();
        AnimalBreedMaster.initPlayer(player);
        AnimalBreedMaster.loadAnimals(player.getDbID());
        AnimalController.updateRancherName(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerGuiElementClickEvent(PlayerGuiElementClickEvent evt) {
        Player player = evt.getPlayer();
        RenameGui renameGui = RenameGui.get(AnimalBreedMaster.getBundleFor(player).getLocale().getLanguage());
        AreYouSureGui areYouSureGui = AreYouSureGui.get(AnimalBreedMaster.getBundleFor(player).getLocale().getLanguage());
        if (renameGui.cancelButton == evt.getGuiElement()) {
            this.processCancelButton(player);
        } else if (renameGui.okButton == evt.getGuiElement()) {
            this.processOkButton(player);
        } else if (areYouSureGui.noButton == evt.getGuiElement()) {
            this.processAreYouSureNoButton(player);
        } else if (areYouSureGui.yesButton == evt.getGuiElement()) {
            this.processAreYouSureYesButton(player);
        }
    }

    private void processOkButton(Player player) {
        RenameGui gui = RenameGui.get(AnimalBreedMaster.getBundleFor(player).getLocale().getLanguage());
        gui.field.getCurrentText(player, (Callback)new CallbackTextFieldResult(player));
        this.disableGuiInput(player);
    }

    private void processCancelButton(Player player) {
        this.disableGuiInput(player);
    }

    private void processAreYouSureYesButton(Player player) {
        this.releaseAnimalAction(player, AnimalController.getRenameTaggedAnimal(player));
        this.disableGuiInput(player);
    }

    private void processAreYouSureNoButton(Player player) {
        this.disableGuiInput(player);
    }

    private void disableGuiInput(Player player) {
        RenameGui gui = RenameGui.get(AnimalBreedMaster.getBundleFor(player).getLocale().getLanguage());
        gui.removeFromPlayer(player);
        AreYouSureGui areYouSureGui = AreYouSureGui.get(AnimalBreedMaster.getBundleFor(player).getLocale().getLanguage());
        areYouSureGui.removeFromPlayer(player);
        player.setMouseCursorVisible(false);
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalFollowStartEvent(AnimalFollowStartEvent evt) {
        AnimalController.setFollowingTaggedAnimal(evt.getPlayer(), evt.getAnimal());
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalFollowStopEvent(AnimalFollowStopEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        AnimalController.resetFollowingTaggedAnimal(player);
        Npc npc = animal.getNpc();
        Vector3f location = new Vector3f(npc.getPosition());
        npc.setAlerted(false);
        npc.moveTo(location);
        AnimalController.updateAnimalHomeLocation(animal, location);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerNpcInteractionEvent(PlayerNpcInteractionEvent evt) {
        Player player = evt.getPlayer();
        Npc npc = evt.getNpc();
        if (npc.getType() != Npc.Type.Animal && npc.getType() != Npc.Type.Mount) {
            return;
        }
        Animal animal = AnimalController.getAnimal(npc);
        boolean processed = this.processAction(player, animal);
        evt.setCancelled(processed);
    }

    private void timerTask() {
        ABMTimeStamp.INSTANCE.tick();
        ++this.feedTimerLoop;
        ++this.progressTimerLoop;
        if ((float)this.progressTimerLoop % ((float)PROGRESS_TIMER_SCALER / this.actionTimer.getInterval()) == 0.0f) {
            this.progressTimerLoop = 0;
        }
        ++this.generalTimerLoop1;
        if ((float)this.generalTimerLoop1 % ((float)GENERAL_TIMER_SCALER / this.actionTimer.getInterval()) == 0.0f) {
            this.generalTimerLoop1 = 0;
        }
        ++this.generalTimerLoop2;
        if ((float)this.generalTimerLoop2 % ((float)GENERAL_TIMER_SCALER2 / this.actionTimer.getInterval()) == 0.0f) {
            this.generalTimerLoop2 = 0;
        }
        this.executeForEachPlayer();
        this.raycastPlayerToNpc();
        this.removeDeadAnimals();
        this.sendAnimalsHome();
        this.removeUnownedAnimals();
    }

    private List<WorldItem> findRewardItems() {
        ArrayList<WorldItem> list = new ArrayList<WorldItem>();
        Collection items = this.getWorld().getAllItems(null);
        if (!items.isEmpty()) {
            for (WorldItem item : items) {
                if (item.isDummy() || !RewardItems.list.contains(item.getName())) continue;
                list.add(item);
            }
        }
        return list;
    }

    private void exchangeRewardItems(Player player) {
        List<WorldItem> items = this.findRewardItems();
        if (!items.isEmpty()) {
            for (WorldItem item : items) {
                this.processRewardAction(player, item);
            }
        }
    }

    private void executeForEachPlayer() {
        for (Player player : this.getServer().getAllPlayers()) {
            this.showNameAction(player, AnimalController.getFollowingTaggedAnimal(player));
            this.followPlayer(player);
            if (this.progressTimerLoop != 0) continue;
            this.procreation(player);
            this.updatePregnancyProgress(player);
            this.exchangeRewardItems(player);
        }
    }

    private void removeDeadAnimals() {
        if (this.generalTimerLoop1 != 0) {
            return;
        }
        AnimalController.removeAnimalsWithoutNpc();
    }

    private void sendAnimalsHome() {
        if (this.generalTimerLoop1 != 0) {
            return;
        }
        List<Animal> list = AnimalBreedMaster.loadAllAnimals();
        for (Animal animal : list) {
            this.sendAnimalHome(animal);
        }
    }

    private void removeUnownedAnimals() {
        if (this.generalTimerLoop2 != 0) {
            return;
        }
        AnimalController.removeUnownedAnimals();
    }

    private void sendAnimalHome(Animal animal) {
        Vector3f targetPosition;
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (animal.getPlayerId() < 0) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            return;
        }
        if (npc.isLocked()) {
            return;
        }
        Vector3f currentPosition = new Vector3f(npc.getPosition());
        float distance = currentPosition.distance(targetPosition = animal.getHomeLocation());
        if (distance > 10.0f) {
            npc.moveTo(targetPosition);
        }
        npc.setAlerted(false, 30);
    }

    private boolean processAction(Player player, Animal animal) {
        Item item = player.getEquippedItem();
        if (item == null) {
            return false;
        }
        AnimalInteraction action = InteractionItem.getAction(item.getName());
        action.execute(player, animal);
        return action != Action.NOOP;
    }

    private void tagAnimalToFollowAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        Animal taggedAnimal = AnimalController.getFollowingTaggedAnimal(player);
        if (animal.getNpc().isSleeping()) {
            this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
        } else if (taggedAnimal == Animal.NULL) {
            if (!animal.getNpc().isLocked()) {
                this.triggerEvent((Event)new AnimalFollowStartEvent(player, animal));
            } else {
                this.triggerEvent((Event)new AnimalFollowLockedEvent(player, animal));
            }
        } else if (taggedAnimal == animal) {
            this.triggerEvent((Event)new AnimalFollowStopEvent(player, animal));
        }
    }

    private void showRewardPoints(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("reward.p1") + "[#ffff00]" + AnimalController.getRewardCounter(player) + "[#7fff00]" + bundle.getVal("reward.p2");
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void lockAnimalAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        animal.setLocked(!animal.isLocked());
        if (animal == AnimalController.getFollowingTaggedAnimal(player) && animal.isLocked()) {
            this.triggerEvent((Event)new AnimalFollowStopEvent(player, animal));
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("locking." + Boolean.toString(animal.isLocked()));
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void releaseAnimalAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwned()) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        this.changeOwner(animal, -1);
    }

    private void setAnimalInvincibleAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        animal.setInvincible(!animal.isInvincible());
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("invincible." + Boolean.toString(animal.isInvincible()));
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void showAnimalRenameGui(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        RenameGui gui = RenameGui.get(AnimalBreedMaster.getBundleFor(player).getLocale().getLanguage());
        gui.addToPlayer(player);
        AnimalController.setRenameTaggedAnimal(player, animal);
        gui.field.setText(AnimalBreedMaster.getNameOrDefault(player, animal));
        player.setMouseCursorVisible(true);
    }

    private void showAnimalReleaseGui(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        AreYouSureGui gui = AreYouSureGui.get(AnimalBreedMaster.getBundleFor(player).getLocale().getLanguage());
        gui.addToPlayer(player);
        AnimalController.setRenameTaggedAnimal(player, animal);
        player.setMouseCursorVisible(true);
    }

    private void feedAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
            return;
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        if (this.feedTimerLoop > FEED_TIMER_SCALER) {
            this.feedTimerLoop = 0;
        }
        if (this.feedTimerLoop > 0) {
            AnimalBreedMaster.chatMessage(player, "[#ffff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("feeding.nothungry"));
            return;
        }
        ++this.feedTimerLoop;
        Inventory inv = player.getInventory();
        byte slot = inv.getQuickslotFocus();
        inv.removeItem((int)slot, Inventory.SlotType.Quickslot, 1);
        int hunger = npc.getHunger() + 5;
        if (hunger > 100) {
            hunger = 100;
        }
        npc.setHunger(hunger);
        int health = npc.getHealth() + 20;
        if (health > 200) {
            health = 200;
        }
        npc.setHealth(health);
        player.playGameSound("player_eat_carrot", npc.getPosition());
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("feeding.yum");
        if (animal.isOwnedByPlayer(player.getDbID())) {
            msg = msg + " [#7fff00]" + bundle.getVal("feeding.thx") + player.getName() + "!";
        }
        AnimalBreedMaster.chatMessage(player, msg);
        animal.incFeedCount();
        if (!animal.isOwned()) {
            if (animal.getFeedCount() > 4) {
                this.newOwner(player, animal);
                AnimalController.increaseRewardCounter(player);
            }
        } else if (animal.isOwnedByPlayer(player.getDbID()) && !animal.isProlific()) {
            if (!animal.isPregnant()) {
                if (animal.getFeedCount() > 3) {
                    AnimalController.updateProlific(animal, true);
                    AnimalController.increaseRewardCounter(player);
                    this.triggerEvent((Event)new AnimalProlificEvent(player, animal));
                }
            } else {
                int pregnancyProgress = animal.getPregnancyProgress() + 300;
                AnimalController.updatePregnancyProgress(animal, pregnancyProgress);
            }
        }
    }

    private void noThanks(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        String msg = "[#ffff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("feeding.nothx");
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void followPlayer(Player player) {
        Animal animal = AnimalController.getFollowingTaggedAnimal(player);
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
            this.triggerEvent((Event)new AnimalFollowStopEvent(player, animal));
            return;
        }
        Vector3f currentPosition = npc.getPosition();
        AnimalController.updateAnimalHomeLocation(animal, currentPosition);
        float distance = currentPosition.distance(player.getPosition());
        Vector3f pos = new Vector3f(currentPosition).subtractLocal(player.getPosition()).normalizeLocal().multLocal(4.0f).addLocal(player.getPosition());
        float FOLLOW_DISTANCE = 20.0f;
        npc.setAlerted(false);
        if (distance > FOLLOW_DISTANCE) {
            npc.setPosition(pos);
        } else if (distance > 10.0f) {
            npc.setAlerted(true, 1);
            npc.moveTo(pos);
        } else if (distance > 4.0f) {
            npc.moveTo(pos);
        }
    }

    private CallbackRayCastResult getPlayerCallbackResult(Player player) {
        return playerCallbackResultMap.computeIfAbsent(player, x$0 -> new CallbackRayCastResult((Player)x$0));
    }

    private void raycastPlayerToNpc() {
        for (Player player : this.getServer().getAllPlayers()) {
            player.raycast(441, (Callback)this.getPlayerCallbackResult(player));
        }
    }

    private void showNameAction(Player player, Animal animal) {
        World3DText text = (World3DText)player.getAttribute("abm_3d_label");
        if (text == null) {
            return;
        }
        boolean wasIdle = (Boolean)player.getAttribute("abm_raycast_idle");
        if (wasIdle) {
            player.removeWorldElement((WorldElement)text);
        }
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        AnimalBreedMaster.showLabel(player, animal, text);
    }

    private static void showLabel(Player player, Animal animal, World3DText text) {
        int fcolor;
        boolean showLabels = (Boolean)player.getAttribute("abm_show_labels");
        if (!showLabels) {
            return;
        }
        Npc npc = animal.getNpc();
        float distance = npc.getPosition().distance(player.getPosition());
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        String t = AnimalBreedMaster.getNameOrDefault(player, animal);
        if (!animal.isOwned()) {
            fcolor = -65281;
            t = t + "\n(" + bundle.getVal("label.wild") + ")";
        } else if (animal.isOwnedByPlayer(player.getDbID())) {
            Animal taggedAnimal = AnimalController.getFollowingTaggedAnimal(player);
            if (animal == taggedAnimal) {
                t = t + "\n(" + bundle.getVal("label.following") + ")";
            } else {
                String res;
                ArrayList<String> labels = new ArrayList<String>();
                if (animal.isProlific()) {
                    labels.add(bundle.getVal("label.prolific"));
                } else if (animal.isPregnant()) {
                    float d = (float)((double)animal.getPregnancyProgress() * 100.0 / 6000.0);
                    labels.add(bundle.getVal("label.pregnant") + " " + NumberFormats.float2_1.format(d) + " %");
                }
                if (animal.getNpc().isLocked()) {
                    labels.add(bundle.getVal("label.leashed"));
                }
                if (animal.getNpc().isInvincible()) {
                    labels.add(bundle.getVal("label.invincible"));
                }
                if ((res = String.join((CharSequence)", ", labels)).length() > 0) {
                    t = t + "\n(" + res + ")";
                }
            }
            fcolor = 0xFF00FF;
        } else {
            fcolor = -1347420161;
            t = t + "\n[" + AnimalController.getAnimalsOwner(animal).getPlayerName() + "]";
        }
        int s = (int)((double)distance / (1.0 - 1.0 / Math.exp((double)distance / Math.E)));
        float y = 2.0f;
        Vector3f v = new Vector3f(npc.getPosition()).addLocal(0.0f, y, 0.0f);
        if (distance < 100.0f) {
            text.setFontsize(s);
            text.setFontColor(fcolor);
            text.setPosition(v);
            text.setText(t);
            player.addWorldElement((WorldElement)text);
        }
    }

    private void procreation(Player player) {
        Map<Integer, List<Animal>> prolificMap = AnimalController.getProlificAnimals(player.getDbID());
        for (int npcType : prolificMap.keySet()) {
            ArrayList list = new ArrayList(prolificMap.get(npcType));
            if (list.size() < 2) continue;
            list.sort((a1, a2) -> this.sortByDistance((Animal)a1, (Animal)a2, player));
            Animal partner1 = (Animal)list.get(0);
            AnimalController.updateProlific(partner1, false);
            AnimalController.updatePregnancyProgress(partner1, 1);
            AnimalController.increaseRewardCounter(player);
            this.triggerEvent((Event)new AnimalPregnantEvent(player, partner1));
        }
    }

    private int sortByDistance(Animal a1, Animal a2, Player player) {
        Npc n1 = a1.getNpc();
        Npc n2 = a2.getNpc();
        if (n1 == null || n2 == null) {
            return 0;
        }
        float distance1 = player.getPosition().distance(n1.getPosition());
        float distance2 = player.getPosition().distance(n2.getPosition());
        return Float.compare(distance1, distance2);
    }

    private void updatePregnancyProgress(Player player) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        Animal p = null;
        for (Animal animal : list) {
            int pregnancyProgress;
            if (AnimalController.removeAnimalIfDead(animal) || (pregnancyProgress = animal.getPregnancyProgress()) <= 0) continue;
            if ((pregnancyProgress += 6) > 6000) {
                Npc npc = animal.getNpc();
                if (npc.isSleeping()) {
                    pregnancyProgress -= 120;
                } else {
                    p = animal;
                }
            }
            AnimalController.updatePregnancyProgress(animal, pregnancyProgress);
        }
        this.giveBirth(player, p);
    }

    private void giveBirth(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        if (list.size() < AnimalBreedMaster.getMaxOwnableAnimals()) {
            AnimalController.updatePregnancyProgress(animal, 0);
            Npc npc = animal.getNpc();
            Vector3f pos = new Vector3f(npc.getPosition()).addLocal(npc.getViewDirection().multLocal(2.0f));
            Quaternion q = new Quaternion();
            q.lookAt(npc.getViewDirection());
            Animal newAnimal = this.spawnAnimal(player, npc.getTypeID(), pos, q);
            AnimalController.increaseOffspringCounter(player);
            AnimalController.increaseRewardCounter(player);
            this.triggerEvent((Event)new AnimalBornEvent(player, newAnimal));
            this.newOwner(player, newAnimal);
        } else {
            AnimalController.updatePregnancyProgress(animal, 1);
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, bundle.getVal("birth.fail")));
        }
    }

    private Animal spawnAnimal(Player player, int type, Vector3f pos, Quaternion quat) {
        Npc newNpc = this.getWorld().spawnNpc((short)type, pos, quat);
        String name = ABMUtil.getDefaultName(player, newNpc);
        return AnimalController.newAnimal(player, newNpc, name);
    }

    private void noReward(Player player, WorldItem item, int type) {
        String animalName = AnimalType.name(type);
        int requiredPoints = AnimalType.reward(type);
        int currentPoints = AnimalController.getRewardCounter(player);
        this.triggerEvent((Event)new PlayerInsufficientPointsEvent(player, animalName, requiredPoints, currentPoints));
    }

    private void rewardAction(Player player, WorldItem item, int type) {
        Vector3f pos = new Vector3f(item.getPosition());
        Quaternion q = new Quaternion();
        item.destroy();
        Animal newAnimal = this.spawnAnimal(player, type, pos, q);
        AnimalController.decRewardCounter(player, type);
        this.triggerEvent((Event)new AnimalRewardEvent(player, newAnimal));
        this.newOwner(player, newAnimal);
    }

    private void processRewardAction(Player player, WorldItem item) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        if (list.size() < AnimalBreedMaster.getMaxOwnableAnimals()) {
            RewardAction action = RewardItems.getAction(item.getName());
            action.execute(player, item);
        } else {
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, bundle.getVal("reward.fail")));
        }
    }

    private static String getNameOrDefault(Player player, Animal animal) {
        return ABMUtil.getNameOrDefault(player, animal);
    }

    private static int getMaxOwnableAnimals() {
        return ABMPreferencesHandler.getMaxAnimals();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerCommand(PlayerCommandEvent evt) {
        if (this.processAdminOnlyCommands(evt)) {
            return;
        }
        if (this.processUserCommands(evt)) {
            return;
        }
    }

    private boolean processAdminOnlyCommands(PlayerCommandEvent evt) {
        Player admin = evt.getPlayer();
        if (!admin.isAdmin()) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return true;
        }
        String cmd = st.nextToken();
        if (!"abm".equals(cmd)) {
            return true;
        }
        boolean ret = true;
        switch (cmd = st.nextToken()) {
            case "admin": {
                admin.sendTextMessage("processing admin commands");
                break;
            }
            case "erase": {
                if (st.countTokens() <= 0) break;
                int playerId = ABMUtil.getInteger(st.nextToken());
                AnimalController.deleteAllAnimalsFromPlayer(playerId);
                break;
            }
            case "listplayers": 
            case "listranchers": {
                this.listRanchersCmd(admin, st);
                break;
            }
            case "listanimals": {
                this.listAnimalsAdminCmd(admin, st);
                break;
            }
            case "gotoanimal": {
                this.gotoAnimalCmd(admin, st);
                break;
            }
            case "goback": {
                this.gobackCmd(admin, st);
                break;
            }
            case "changeowner": {
                this.changeOwnerCmd(admin, st);
                break;
            }
            case "reset": {
                this.resetCmd(admin, st);
                break;
            }
            case "rename": 
            case "renaming": {
                String bool;
                if (st.countTokens() <= 0 || !(bool = st.nextToken()).matches("^true|false$")) break;
                ABMPreferencesHandler.setRenamingActive(bool);
                InteractionItem.toggleRenameAction();
                admin.sendTextMessage("[#ffff00]renaming set to [#7fff00]" + ABMPreferencesHandler.isRenamingActive());
                break;
            }
            case "invincible": {
                String bool;
                if (st.countTokens() <= 0 || !(bool = st.nextToken()).matches("^true|false$")) break;
                ABMPreferencesHandler.setInvincibleActionActive(bool);
                InteractionItem.toggleInvincibleAction();
                admin.sendTextMessage("[#ffff00]invincible set to [#7fff00]" + ABMPreferencesHandler.isInvincibleActionActive());
                break;
            }
            case "rewsys": {
                String bool;
                if (st.countTokens() <= 0 || !(bool = st.nextToken()).matches("^true|false$")) break;
                ABMPreferencesHandler.setRewardSystemActive(bool);
                InteractionItem.toggleRewardSystem();
                admin.sendTextMessage("[#ffff00]reward system set to [#7fff00]" + ABMPreferencesHandler.isRewardSystemActive());
                break;
            }
            case "warpallhome": {
                this.warpAllAnimalsHome();
                break;
            }
            case "helpfile": {
                this.writeHelp(admin);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private boolean processUserCommands(PlayerCommandEvent evt) {
        Player player = evt.getPlayer();
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return true;
        }
        String cmd = st.nextToken();
        if (!"abm".equals(cmd)) {
            return true;
        }
        boolean ret = true;
        switch (cmd = st.nextToken()) {
            case "user": {
                player.sendTextMessage("processing user commands");
                break;
            }
            case "help": {
                this.printHelp(player);
                break;
            }
            case "count": {
                if (st.countTokens() <= 0) break;
                AnimalBreedMaster.countAnimalsCmd(player, st.nextToken());
                break;
            }
            case "list": {
                if (st.countTokens() <= 0) break;
                AnimalBreedMaster.listAnimalsCmd(player, st.nextToken());
                break;
            }
            case "warphome": {
                if (st.countTokens() <= 0) break;
                this.warpHomeCommand(player, st.nextToken());
                break;
            }
            case "lang": {
                if (st.countTokens() <= 0) break;
                String lang = st.nextToken();
                ABMUtil.initBundle(player, lang);
                break;
            }
            case "label": 
            case "labels": 
            case "showlabel": 
            case "showlabels": {
                String onOff;
                if (st.countTokens() <= 0 || !(onOff = st.nextToken()).matches("off|on")) break;
                player.setAttribute("abm_show_labels", (Object)"on".equals(onOff));
                break;
            }
            case "chat": 
            case "showchat": {
                String onOff;
                if (st.countTokens() <= 0 || !(onOff = st.nextToken()).matches("off|on")) break;
                player.setAttribute("abm_show_chat_msg", (Object)"on".equals(onOff));
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private static void countAnimalsCmd(Player player, String animalType) {
        String hl = "Counting " + animalType + ":";
        String us = String.join((CharSequence)"", Collections.nCopies(hl.length(), "-"));
        player.sendTextMessage("");
        player.sendTextMessage("[#7fff00]" + hl);
        player.sendTextMessage("[#7fff00]" + us);
        List<Animal> animals = AnimalBreedMaster.loadAnimals(player.getDbID());
        if (animals.size() < 1) {
            player.sendTextMessage("[#ffff00]  No animals found.");
            return;
        }
        Map<String, List<Animal>> animalMap = AnimalBreedMaster.createAnimalMap(animals);
        if ("all".equals(animalType)) {
            Set<String> names = animalMap.keySet();
            for (String name : names) {
                player.sendTextMessage("[#ffff00]  " + name + " count: [#7fff00]" + animalMap.get(name).size());
            }
            player.sendTextMessage("[#ffff00]  total: [#7fff00]" + animals.size() + "[#ffff00] of max. [#7fff00]" + AnimalBreedMaster.getMaxOwnableAnimals());
        } else if (animalMap.containsKey(animalType)) {
            player.sendTextMessage("[#ffff00]  " + animalType + " count: [#7fff00]" + animalMap.get(animalType).size());
        } else {
            player.sendTextMessage("[#ffff00]  No animals of type [#7fff00]" + animalType + "[#ffff00] found.");
        }
    }

    private static void listAnimalsCmd(Player player, String animalType) {
        String hl = "Listing " + animalType + ":";
        String us = String.join((CharSequence)"", Collections.nCopies(hl.length(), "-"));
        player.sendTextMessage("");
        player.sendTextMessage("[#7fff00]" + hl);
        player.sendTextMessage("[#7fff00]" + us);
        List<Animal> animals = AnimalBreedMaster.loadAnimals(player.getDbID());
        if (animals.size() < 1) {
            player.sendTextMessage("[#ffff00]  No animals found.");
            return;
        }
        Map<String, List<Animal>> animalMap = AnimalBreedMaster.createAnimalMap(animals);
        if ("all".equals(animalType)) {
            Collection<List<Animal>> lists = animalMap.values();
            for (List<Animal> subList : lists) {
                AnimalBreedMaster.listAnimalsSubList(player, subList);
            }
        } else if (animalMap.containsKey(animalType)) {
            AnimalBreedMaster.listAnimalsSubList(player, animalMap.get(animalType));
        } else {
            player.sendTextMessage("[#ffff00]  No animals of type [#7fff00]" + animalType + "[#ffff00] found.");
        }
    }

    private static void listAnimalsSubList(Player player, List<Animal> list) {
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        int lfd = 1;
        for (Animal animal : list) {
            Npc npc = animal.getNpc();
            if (npc == null) continue;
            String type = AnimalType.name(AnimalType.filterNpcType(npc.getTypeID()));
            Vector3f currentPosition = npc.getPosition();
            String distance = String.format("%3.0f", Float.valueOf(currentPosition.distance(player.getPosition()) / 2.0f));
            String xPos = String.format("%4.0f", Float.valueOf(currentPosition.getX()));
            String yPos = String.format("%4.0f", Float.valueOf(currentPosition.getY()));
            String zPos = String.format("%4.0f", Float.valueOf(currentPosition.getZ()));
            player.sendTextMessage("[#ffff00]  " + type + " " + String.format("%2d", lfd) + ": ID: [#7fff00]" + animal.getNpcId() + "[#ffff00], Pos: X[#7fff00]" + xPos + "[#ffff00], Y[#7fff00]" + yPos + "[#ffff00], Z[#7fff00]" + zPos + "[#ffff00] Dist: [#7fff00]" + distance + "m[#ffff00] (" + animal.getNpcName() + ")");
            ++lfd;
        }
    }

    private static Map<String, List<Animal>> createAnimalMap(List<Animal> animals) {
        HashMap<String, List<Animal>> cntMap = new HashMap<String, List<Animal>>();
        for (Animal animal : animals) {
            Npc npc = animal.getNpc();
            if (npc == null) continue;
            String type = AnimalType.name(AnimalType.filterNpcType(npc.getTypeID()));
            cntMap.putIfAbsent(type, new ArrayList());
            cntMap.get(type).add(animal);
        }
        return cntMap;
    }

    private void listItems(Player player) {
        Collection items = this.getWorld().getAllItems(null);
        for (WorldItem item : items) {
            if (item.isDummy()) continue;
            player.sendTextMessage("item: " + item.getName() + " rel: " + item.getRelatedPlayer().getName());
            player.sendTextMessage("dist: " + item.getPosition().distance(item.getRelatedPlayer().getPosition()));
        }
    }

    private void warpHomeCommand(Player player, String token) {
        if ("all".equals(token)) {
            this.warpAllPlayerAnimalsHome(player);
            return;
        }
        int animalId = ABMUtil.getInteger(token);
        if (animalId > 0) {
            this.warpAnimalHome(player, animalId);
        }
    }

    private void warpAllPlayerAnimalsHome(Player player) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        for (Animal animal : list) {
            this.warpAnimalHome(player, animal.getNpcId());
        }
    }

    private void warpAnimalHome(Player player, int animalId) {
        if (animalId < 1) {
            return;
        }
        Npc npc = this.getWorld().getNpc(animalId);
        if (npc == null) {
            return;
        }
        Animal animal = AnimalController.getAnimal(npc);
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        Vector3f targetPosition = animal.getHomeLocation();
        npc.setPosition(targetPosition);
    }

    private void warpAllAnimalsHome() {
        List<Animal> list = AnimalBreedMaster.loadAllAnimals();
        for (Animal animal : list) {
            Vector3f pos;
            Npc npc;
            if (animal.getPlayerId() < 0 || (npc = this.getWorld().getNpc(animal.getNpcId())) == null || Float.isNaN((pos = animal.getHomeLocation()).getX() + pos.getZ() + pos.getZ())) continue;
            npc.setPosition(pos);
        }
    }

    private void processDebugCommands(PlayerCommandEvent evt) {
        Player player = evt.getPlayer();
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return;
        }
        String cmd = st.nextToken();
        if (!"abm".equals(cmd)) {
            return;
        }
        switch (cmd = st.nextToken()) {
            case "debug": {
                player.sendTextMessage("processing debug commands");
                break;
            }
            case "items": {
                this.listItems(player);
                break;
            }
            case "pos": {
                this.printPosition(player);
                break;
            }
            case "procreation": {
                this.procreation(player);
                break;
            }
            case "worlditems": {
                this.exchangeRewardItems(player);
                break;
            }
            case "mouseon": {
                player.sendTextMessage("mouse cursor visible");
                player.setMouseCursorVisible(true);
                break;
            }
            case "mouseoff": {
                player.sendTextMessage("mouse cursor invisible");
                player.setMouseCursorVisible(false);
                break;
            }
            case "npcdef": {
                FW.setWithTimestamp(false);
                List npcDefs = Definitions.getAllNpcDefinitions();
                for (Definitions.NpcDefinition definition : npcDefs) {
                    String out = definition.getID() + " " + definition.getName() + " " + definition.getAttackReaction() + " " + definition.getNpcType();
                    AnimalBreedMaster.chatMessage(player, out);
                    FW.writeToFile(out);
                }
                break;
            }
        }
    }

    private void printPosition(Player player) {
        player.sendTextMessage("pos:" + player.getChunkPosition() + " " + player.getBlockPosition() + " " + player.getPosition());
    }

    private Npc getNpc(int npcId) {
        return this.getWorld().getNpc(npcId);
    }

    private static void chatMessage(Player player, String message) {
        ABMUtil.chatMessage(player, message);
    }

    private static List<Animal> loadAllAnimals() {
        return AnimalController.getAllAnimals();
    }

    private static List<Animal> loadAnimals(int loadPlayerId) {
        return AnimalController.getPlayersAnimals(loadPlayerId);
    }

    @Override
    public int countAnimals(int playerId) {
        return AnimalController.getRancher(playerId).countAnimals();
    }

    @Override
    public List<Rancher> listRanchers() {
        ArrayList<Rancher> ranchers = new ArrayList<Rancher>();
        ranchers.addAll(AnimalController.getAllRanchers());
        return ranchers;
    }

    @Override
    public List<carsten.risingworld.api.abm.Animal> listAnimals(int playerDbId) {
        ArrayList<carsten.risingworld.api.abm.Animal> animals = new ArrayList<carsten.risingworld.api.abm.Animal>();
        animals.addAll(AnimalBreedMaster.loadAnimals(playerDbId));
        return animals;
    }

    @Override
    public boolean changeOwner(carsten.risingworld.api.abm.Animal animal, int newPlayerId) {
        Player newPlayer = this.getServer().getPlayer(newPlayerId);
        if (this.countAnimals(newPlayerId) < AnimalBreedMaster.getMaxOwnableAnimals()) {
            Player oldPlayer = this.getServer().getPlayer(animal.getPlayerId());
            AnimalController.updatePlayerId((Animal)animal, newPlayerId);
            AnimalController.updateAnimalHomeLocation((Animal)animal);
            if (oldPlayer != null) {
                this.triggerEvent((Event)new AnimalOwnerReleasedEvent(oldPlayer, (Animal)animal));
            }
            if (newPlayer != null) {
                this.triggerEvent((Event)new AnimalOwnerChangedEvent(newPlayer, (Animal)animal));
            }
            return true;
        }
        if (newPlayer != null) {
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(newPlayer, AnimalBreedMaster.getBundleFor(newPlayer).getString("owner.fail")));
        }
        return false;
    }

    @Override
    public boolean changeOwnerAllAnimals(int oldPlayerId, int newPlayerId) {
        Animal animal;
        List<Animal> list = AnimalBreedMaster.loadAnimals(oldPlayerId);
        boolean success = false;
        Iterator<Animal> iterator = list.iterator();
        while (iterator.hasNext() && (success = this.changeOwner(animal = iterator.next(), newPlayerId))) {
        }
        return success;
    }

    @Override
    public carsten.risingworld.api.abm.Animal getAnimalByGlobalNpcId(int npcGlobalId) {
        return AnimalController.getAnimal(npcGlobalId);
    }

    @Override
    public boolean resetLock(int npcId) {
        Animal animal = (Animal)this.getAnimalByGlobalNpcId(npcId);
        animal.setLocked(false);
        return !animal.isLocked();
    }

    @Override
    public boolean resetLockAllAnimals(int playerId) {
        Animal animal;
        List<Animal> list = AnimalBreedMaster.loadAnimals(playerId);
        boolean success = false;
        Iterator<Animal> iterator = list.iterator();
        while (iterator.hasNext() && (success = this.resetLock((animal = iterator.next()).getNpcId()))) {
        }
        return success;
    }

    @Override
    public boolean resetInvincible(int npcId) {
        Animal animal = (Animal)this.getAnimalByGlobalNpcId(npcId);
        animal.setInvincible(false);
        return !animal.isInvincible();
    }

    @Override
    public boolean resetInvincibleAllAnimals(int playerId) {
        Animal animal;
        List<Animal> list = AnimalBreedMaster.loadAnimals(playerId);
        boolean success = false;
        Iterator<Animal> iterator = list.iterator();
        while (iterator.hasNext() && (success = this.resetInvincible((animal = iterator.next()).getNpcId()))) {
        }
        return success;
    }

    private void resetCmd(Player player, StringTokenizer st) {
        if (st.countTokens() > 0) {
            String token = st.nextToken();
            if (token.matches("^lock$")) {
                this.resetLockCmd(player, st);
            } else if (token.matches("^invincible$")) {
                this.resetInvincibleCmd(player, st);
            }
        } else {
            player.sendTextMessage("[#ff7f3f]USAGE:");
            player.sendTextMessage("[#ffff3f]/abmapi reset lock rancher ID [#3fff3f]unleashes all animals from player with given ID");
            player.sendTextMessage("[#ffff3f]/abmapi reset lock animal ID [#3fff3f]unleashes one animal with given ID");
            player.sendTextMessage("[#ffff3f]/abmapi reset invincible rancher ID [#3fff3f]makes all animals from player with given ID vulnerable");
            player.sendTextMessage("[#ffff3f]/abmapi reset invincible animal ID [#3fff3f]makes one animal with given ID vulnerable");
            player.sendTextMessage("");
        }
    }

    private void resetLockCmd(Player player, StringTokenizer st) {
        if (st.countTokens() > 1) {
            String token = st.nextToken();
            int id = ABMUtil.getInteger(st.nextToken());
            if (token.matches("^player|rancher$")) {
                boolean success = this.resetLockAllAnimals(id);
                player.sendTextMessage("[#ffff3f]reset lock rancher [#3fff3f]" + id + " " + (success ? " [#3fff3f]SUCCESS" : " [#ff7f3f]FAILED"));
            } else if (token.matches("^animal$")) {
                boolean success = this.resetLock(id);
                player.sendTextMessage("[#ffff3f]reset lock animal [#3fff3f]" + id + " " + (success ? " [#3fff3f]SUCCESS" : " [#ff7f3f]FAILED"));
            }
        } else {
            player.sendTextMessage("[#ff7f3f]USAGE:");
            player.sendTextMessage("[#ffff3f]/abmapi reset lock rancher ID [#3fff3f]unleashes all animals from player with given ID");
            player.sendTextMessage("[#ffff3f]/abmapi reset lock animal ID [#3fff3f]unleashes one animal with given ID");
            player.sendTextMessage("");
        }
    }

    private void resetInvincibleCmd(Player player, StringTokenizer st) {
        if (st.countTokens() > 1) {
            String token = st.nextToken();
            int id = ABMUtil.getInteger(st.nextToken());
            if (token.matches("^player|rancher$")) {
                boolean success = this.resetInvincibleAllAnimals(id);
                player.sendTextMessage("[#ffff3f]reset invincible rancher " + id + " " + (success ? " [#3fff3f]SUCCESS" : " [#ff7f3f]FAILED"));
            } else if (token.matches("^animal$")) {
                boolean success = this.resetInvincible(id);
                player.sendTextMessage("[#ffff3f]reset invincible animal " + id + " " + (success ? " [#3fff3f]SUCCESS" : " [#ff7f3f]FAILED"));
            }
        } else {
            player.sendTextMessage("[#ff7f3f]USAGE:");
            player.sendTextMessage("[#ffff3f]/abmapi reset invincible rancher ID [#3fff3f]makes all animals from player with given ID vulnerable");
            player.sendTextMessage("[#ffff3f]/abmapi reset invincible animal ID [#3fff3f]makes one animal with given ID vulnerable");
            player.sendTextMessage("");
        }
    }

    private void renameAnimal(Player player, Animal animal, String p_newName) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        String oldName = animal.getNpcName();
        String newName = p_newName;
        if (newName == null) {
            newName = ABMUtil.getDefaultName(player, animal.getNpc());
        }
        AnimalController.updateAnimalName(animal, newName);
        this.triggerEvent((Event)new AnimalRenamedEvent(player, animal, oldName));
    }

    private void newOwner(Player player, Animal animal) {
        boolean success = this.changeOwner(animal, player.getDbID());
        if (success) {
            AnimalController.updateAnimalName(animal, AnimalBreedMaster.getNameOrDefault(player, animal));
        } else {
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, AnimalBreedMaster.getBundleFor(player).getString("owner.fail")));
        }
    }

    private void changeOwnerCmd(Player player, StringTokenizer st) {
        if (st.countTokens() > 2) {
            String token = st.nextToken();
            int id1 = ABMUtil.getInteger(st.nextToken());
            int id2 = ABMUtil.getInteger(st.nextToken());
            if (token.matches("^player|rancher$")) {
                boolean success = this.changeOwnerAllAnimals(id1, id2);
                player.sendTextMessage("[#ffff3f]changeowner rancher: old rancher " + id1 + " > new rancher " + id2 + (success ? " [#3fff3f]SUCCESS" : " [#ff7f3f]FAILED"));
            } else if (token.matches("^animal$")) {
                Animal animal = AnimalController.getAnimal(id1);
                boolean success = this.changeOwner(animal, id2);
                player.sendTextMessage("[#ffff3f]changeowner animal id " + id1 + " > new rancher " + id2 + (success ? " [#3fff3f]SUCCESS" : " [#ff7f3f]FAILED"));
            }
        } else {
            player.sendTextMessage("[#FF7F3F]USAGE:");
            player.sendTextMessage("[#ffff3f]/abm changeowner rancher OLD_ID NEW_ID [#3fff3f]transfers animals from player OLD_ID to NEW_ID");
            player.sendTextMessage("      [#3fff3f](set NEW_ID = -1 to release all animals to the wild)");
            player.sendTextMessage("[#ffff3f]/abm changeowner animal NPC_ID PLAYER_ID [#3fff3f]transfers animal NPC_ID to player PLAYER_ID");
            player.sendTextMessage("      [#3fff3f](set PLAYER_ID = -1 to release the animal to the wild)");
            player.sendTextMessage("");
        }
    }

    private void listRanchersCmd(Player player, StringTokenizer st) {
        List ranchers = this.listRanchers().stream().filter(p_rancher -> p_rancher.countAnimals() > 0).collect(Collectors.toList());
        String token1 = "";
        if (st.countTokens() > 0) {
            String token = st.nextToken().toLowerCase();
            ranchers = ranchers.stream().filter(p_rancher -> p_rancher.getPlayerName().toLowerCase().startsWith(token)).collect(Collectors.toList());
            token1 = token;
        }
        player.sendTextMessage("[#ffff3f]listranchers [#3fff3f]" + token1);
        for (Rancher rancher : ranchers) {
            player.sendTextMessage("ID: " + rancher.getPlayerId() + " name: " + rancher.getPlayerName() + " [#3fff3f]# animals: " + rancher.countAnimals());
        }
    }

    private void listAnimalsAdminCmd(Player player, StringTokenizer st) {
        if (st.countTokens() > 0) {
            int playerId = ABMUtil.getInteger(st.nextToken());
            List<carsten.risingworld.api.abm.Animal> animals = this.listAnimals(playerId);
            player.sendTextMessage("[#ffff3f]list animals for player id [#3fff3f]" + playerId + " [#00FF00]size: " + animals.size());
            for (carsten.risingworld.api.abm.Animal animal : animals) {
                Npc npc = animal.getNpc();
                if (npc == null) continue;
                Vector3f currentPosition = npc.getPosition();
                String distance = String.format("%3.0f", Float.valueOf(currentPosition.distance(player.getPosition()) / 2.0f));
                String xPos = String.format("%4.0f", Float.valueOf(currentPosition.getX()));
                String yPos = String.format("%4.0f", Float.valueOf(currentPosition.getY()));
                String zPos = String.format("%4.0f", Float.valueOf(currentPosition.getZ()));
                String name = animal.getNpcName().length() > 0 ? animal.getNpcName() : "(no name)";
                player.sendTextMessage("ID: " + animal.getNpcId() + " " + name + " [#00FF00]type: " + animal.getType() + (animal.isLocked() ? " [#7FFF00]locked" : "") + (animal.isInvincible() ? " [#FF7F00]invincible" : "") + "[#ffff00], Pos: X[#7fff00]" + xPos + "[#ffff00], Y[#7fff00]" + yPos + "[#ffff00], Z[#7fff00]" + zPos + "[#ffff00] Dist: [#7fff00]" + distance + "m");
            }
        }
    }

    private void gotoAnimalCmd(Player player, StringTokenizer st) {
        if (st.countTokens() > 0) {
            int id = ABMUtil.getInteger(st.nextToken());
            Animal animal = AnimalController.getAnimal(id);
            Npc npc = animal.getNpc();
            if (npc == null) {
                return;
            }
            Vector3f pos = (Vector3f)player.getAttribute("abm_last_pos");
            if (pos == null) {
                player.setAttribute("abm_last_pos", (Object)new Vector3f(player.getPosition()));
            }
            AnimalBreedMaster.chatMessage(player, "[#ffff3f]gotoanimal [#3fff3f]" + id);
            player.setPosition(npc.getPosition());
        } else {
            player.sendTextMessage("[#FF7F3F]USAGE:");
            player.sendTextMessage("[#ffff3f]/abm gotoanimal NPC_ID [#3fff3f]teleports the player to the animal");
            player.sendTextMessage("");
        }
    }

    private void gobackCmd(Player player, StringTokenizer st) {
        Vector3f pos = (Vector3f)player.getAttribute("abm_last_pos");
        if (pos == null) {
            AnimalBreedMaster.chatMessage(player, "no back position saved");
            return;
        }
        AnimalBreedMaster.chatMessage(player, "[#ffff3f]goback");
        player.deleteAttribute("abm_last_pos");
        player.setPosition(pos);
    }

    private void printRewardList(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        for (String itemName : RewardItems.getItems()) {
            String actionName = RewardItems.getAction(itemName).actionName();
            int points = RewardItems.getAction(itemName).getRewardPoints();
            player.sendTextMessage("* [#ffff00]" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(actionName) + "[#7fff00]" + points + "[#ffff00]" + bundle.getVal("action.reward.rp"));
        }
    }

    private void printItemInteraction(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        for (String itemName : InteractionItem.getItems()) {
            player.sendTextMessage("* [#ffff00]" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(InteractionItem.getAction(itemName).actionName()));
        }
    }

    private void printHelp(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        player.sendTextMessage("");
        player.sendTextMessage("");
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage(bundle.getVal("help.title"));
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("* ");
        player.sendTextMessage("* " + bundle.getVal("help.descr.line1"));
        player.sendTextMessage("* " + bundle.getVal("help.descr.line2"));
        player.sendTextMessage("* ");
        player.sendTextMessage("* [#7fff00]" + bundle.getVal("help.itemlist.head"));
        this.printItemInteraction(player);
        if (ABMPreferencesHandler.isRewardSystemActive()) {
            player.sendTextMessage("* ");
            player.sendTextMessage("* [#7fff00]" + bundle.getVal("help.rewardlist.head1"));
            player.sendTextMessage("* [#7fff00]" + bundle.getVal("help.rewardlist.head2"));
            this.printRewardList(player);
            player.sendTextMessage("* ");
            player.sendTextMessage("* [#ffff00]" + bundle.getVal("reward.p1") + "[#7fff00]" + AnimalController.getRewardCounter(player) + "[#ffff00]" + bundle.getVal("reward.p2"));
        }
        player.sendTextMessage("* ");
        player.sendTextMessage("* " + bundle.getVal("help.readme"));
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("");
        player.sendTextMessage("" + bundle.getVal("help.scrollinfo"));
        player.sendTextMessage("");
    }

    private void writeHelp(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getBundleFor(player);
        FW.defFilepath = this.getPath() + SEP + "help_" + bundle.getLocale().getLanguage() + ".txt";
        new File(FW.defFilepath).delete();
        FW.setWithTimestamp(false);
        FW.writeToFile("*************************************************************************");
        FW.writeToFile(bundle.getVal("help.title"));
        FW.writeToFile("*************************************************************************");
        FW.writeToFile("");
        FW.writeToFile(bundle.getVal("help.descr.line1"));
        FW.writeToFile(bundle.getVal("help.descr.line2"));
        FW.writeToFile("");
        FW.writeToFile(bundle.getVal("help.itemlist.head"));
        FW.writeToFile("***********************************");
        for (String itemName : InteractionItem.getItems()) {
            FW.writeToFile("" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(InteractionItem.getAction(itemName).actionName()));
        }
        FW.writeToFile("");
        FW.writeToFile(bundle.getVal("help.rewardlist.head1"));
        FW.writeToFile(bundle.getVal("help.rewardlist.head2"));
        FW.writeToFile("***********************************");
        for (String itemName : RewardItems.getItems()) {
            String actionName = RewardItems.getAction(itemName).actionName();
            int points = RewardItems.getAction(itemName).getRewardPoints();
            FW.writeToFile("" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(actionName) + points + bundle.getVal("action.reward.rp"));
        }
        FW.setWithTimestamp(true);
        AnimalBreedMaster.chatMessage(player, "helpfile written to: " + FW.defFilepath);
    }

    private static ABMResourceBundle getBundleFor(Player player) {
        return ABMUtil.getBundleFor(player);
    }

    private static void initPlayer(Player player) {
        player.setAttribute("abm_3d_label", (Object)AnimalBreedMaster.createLabel());
        player.setAttribute("abm_raycast_idle", (Object)true);
        player.setAttribute("abm_show_labels", (Object)true);
        player.setAttribute("abm_show_chat_msg", (Object)true);
    }

    private static World3DText createLabel() {
        World3DText text = new World3DText("");
        text.setFontColor(0xAA00FF);
        text.setBillboard(true);
        text.setAlwaysVisible(true);
        text.setVisibleRange(100.0f);
        return text;
    }

    static {
        INTERVAL = 1.0f;
        FEED_TIMER_SCALER = (int)(4.0f / INTERVAL);
        PROGRESS_TIMER_SCALER = (int)(6.0f / INTERVAL);
        GENERAL_TIMER_SCALER = (int)(20.0f / INTERVAL);
        GENERAL_TIMER_SCALER2 = (int)(10.0f / INTERVAL);
        playerCallbackResultMap = new HashMap<Player, CallbackRayCastResult>(20);
    }

    class CallbackRayCastResult
    implements Callback<RayCastResult> {
        private int CNT = 0;
        private final Player player;

        CallbackRayCastResult(Player p_player) {
            this.player = p_player;
        }

        public void onCall(RayCastResult result) {
            if (result == null) {
                return;
            }
            if (result.getDistance() > 100.0f) {
                return;
            }
            Object collisionObject = result.getCollisionObject();
            Npc npc = null;
            if (collisionObject != null && collisionObject instanceof Npc) {
                npc = (Npc)collisionObject;
            }
            if (npc == null || npc.getType() != Npc.Type.Animal) {
                this.player.setAttribute("abm_raycast_idle", (Object)true);
                return;
            }
            Animal animal = AnimalController.getAnimal(npc);
            AnimalBreedMaster.this.showNameAction(this.player, animal);
            this.player.setAttribute("abm_raycast_idle", (Object)false);
        }
    }

    class CallbackTextFieldResult
    implements Callback<String> {
        private final Player player;

        CallbackTextFieldResult(Player p_player) {
            this.player = p_player;
        }

        public void onCall(String result) {
            if (result == null) {
                return;
            }
            AnimalBreedMaster.this.renameAnimal(this.player, AnimalController.getRenameTaggedAnimal(this.player), result);
        }
    }
}

