/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.action;

import carsten.risingworld.abm.action.ActionDelegate;
import carsten.risingworld.abm.action.AnimalInteraction;
import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalType;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;

public enum FeedAction implements AnimalInteraction
{
    PIG(1),
    COW(2),
    GOAT(3),
    SHEEP(4),
    FOX(6),
    BEAR(7),
    RABBIT(8),
    CHICKEN(10),
    ELEPHANT(11),
    JAGUAR(14),
    TIGER(17),
    MINIPIG(19),
    RAT(23),
    HORSE(31),
    CAMEL(33),
    DONKEY(35),
    OTHER(0);

    private static final List<Integer> npcTypes;
    private final int npcType;
    private ActionDelegate execDelegate;
    private ActionDelegate denyDelegate;

    private FeedAction(int p_npcType) {
        this.npcType = p_npcType;
        this.denyDelegate = this.execDelegate = this.getNullDelegate();
    }

    @Override
    public void setDelegates(ActionDelegate p_execDelegate, ActionDelegate p_denyDelegate) {
        this.execDelegate = p_execDelegate;
        this.denyDelegate = p_denyDelegate;
    }

    @Override
    public void execute(Player player, Animal animal) {
        Npc npc = animal.getNpc();
        if (this.npcType == AnimalType.filterNpcType(npc.getTypeID()) || this == OTHER && !npcTypes.contains(npc.getTypeID())) {
            this.execDelegate.action(player, animal);
        } else {
            this.denyDelegate.action(player, animal);
        }
    }

    @Override
    public String actionName() {
        return "action.feed." + this.name();
    }

    static {
        npcTypes = new ArrayList<Integer>(25);
        for (FeedAction action : FeedAction.values()) {
            if (action == OTHER) continue;
            npcTypes.add(action.npcType);
        }
    }
}

