/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm;

import carsten.risingworld.abm.ABMResourceBundle;
import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalType;
import java.util.Locale;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;

public class ABMUtil {
    static String getDefaultName(Player player, Npc npc) {
        if (npc == null) {
            return "";
        }
        ABMResourceBundle bundle = ABMUtil.getBundleFor(player);
        String name = npc.getName();
        if (name == null) {
            name = "";
        }
        if (name.length() <= 0) {
            name = bundle.getVal("animal." + AnimalType.name(npc.getTypeID())) + " " + npc.getGlobalID();
        }
        return name;
    }

    public static String getNameOrDefault(Player player, Animal animal) {
        if (animal == null) {
            return "";
        }
        Npc npc = animal.getNpc();
        String name = animal.getNpcName();
        if (name.length() <= 0) {
            name = ABMUtil.getDefaultName(player, npc);
        }
        return name;
    }

    private static ABMResourceBundle loadBundle(Player player, String lang) {
        return (ABMResourceBundle)ABMResourceBundle.getBundle(ABMResourceBundle.class.getName(), new Locale(lang));
    }

    static ABMResourceBundle initBundle(Player player) {
        return ABMUtil.initBundle(player, player.getLanguage());
    }

    static ABMResourceBundle initBundle(Player player, String lang) {
        ABMUtil.removeBundle(player);
        ABMResourceBundle bundle = ABMUtil.loadBundle(player, lang);
        player.setAttribute("abm_bundle", (Object)bundle);
        return bundle;
    }

    static void removeBundle(Player player) {
        player.deleteAttribute("abm_bundle");
    }

    static ABMResourceBundle getBundleFor(Player player) {
        ABMResourceBundle bundle = (ABMResourceBundle)player.getAttribute("abm_bundle");
        if (bundle == null) {
            bundle = ABMUtil.initBundle(player);
        }
        return bundle;
    }

    static void chatMessage(Player player, String message) {
        if (!((Boolean)player.getAttribute("abm_show_chat_msg")).booleanValue()) {
            return;
        }
        player.sendTextMessage(message);
    }

    static int getInteger(String str) {
        int i;
        if (str == null) {
            str = "";
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        return i;
    }
}

