/*
 * Decompiled with CFR 0.152.
 */
package risingworldshutdown;

import java.time.LocalTime;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import risingworldshutdown.XMLReader;

public class RisingWorldShutdown
extends Plugin {
    private Timer heartbeat_timer;
    private Timer shutdown_timer;
    private int hour;
    private int minute;
    private Server server;
    private int remaining_time = 60;

    public void onEnable() {
        String path = this.getPath();
        XMLReader xmlr = new XMLReader(path);
        this.hour = XMLReader.hour;
        this.minute = XMLReader.minute;
        System.out.println("PLUGIN: Shutdown event scheduled for: " + this.hour + ":" + this.minute);
        this.server = this.getServer();
        this.heartbeat_timer = new Timer(60.0f, 0.0f, -1, () -> {
            if (LocalTime.now().getHour() == this.hour && LocalTime.now().getMinute() == this.minute) {
                this.heartbeat_timer.kill();
                this.shutdown_timer.start();
            }
        });
        this.heartbeat_timer.start();
        this.shutdown_timer = new Timer(10.0f, 0.0f, -1, () -> {
            this.getServer().getAllPlayers().forEach(player -> {
                player.sendYellMessage("SERVER RESTARTING IN " + this.remaining_time + " SECONDS.");
                player.playGameSound("message");
                if (this.remaining_time <= 0) {
                    this.server.saveAll();
                    this.server.shutdown();
                }
            });
            this.remaining_time -= 10;
        });
    }

    public void onDisable() {
    }
}

