/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm;

import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalDataBase;
import carsten.risingworld.abm.data.AnimalMap;
import carsten.risingworld.abm.data.AnimalType;
import carsten.risingworld.abm.data.Rancher;
import carsten.risingworld.abm.data.RancherMap;
import carsten.risingworld.abm.data.UnitOfWork;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.risingworld.api.Plugin;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

class AnimalController {
    private AnimalController() {
    }

    static void enable(Plugin plugin, float currentVersion) {
        AnimalDataBase.INSTANCE.initDataBase(plugin, currentVersion);
        UnitOfWork.INSTANCE.start();
        AnimalMap.preloadAll();
    }

    static void disable() {
        AnimalController.removeAnimalsWithoutNpc();
        UnitOfWork.INSTANCE.stop();
        AnimalDataBase.INSTANCE.closeDataBase();
        RancherMap.clearAll();
        AnimalMap.clearAll();
    }

    static void deleteAllAnimalsFromPlayer(int playerId) {
        List<Animal> copy = AnimalController.getPlayersAnimals(playerId);
        for (Animal animal : copy) {
            AnimalController.updatePlayerId(animal, -1);
        }
    }

    static void removeAnimalsWithoutNpc() {
        ArrayList<Animal> list = new ArrayList<Animal>(AnimalMap.getAll());
        for (Animal animal : list) {
            AnimalController.removeAnimalIfDead(animal);
        }
    }

    static boolean removeAnimalIfDead(Animal animal) {
        if (animal == null || animal == Animal.NULL) {
            return true;
        }
        Npc npc = animal.getNpc();
        if (npc == null || npc.isDead()) {
            AnimalController.updatePlayerId(animal, -1);
            return true;
        }
        return false;
    }

    static Animal getAnimal(Npc npc) {
        return AnimalMap.get(npc.getGlobalID());
    }

    static List<Animal> getAllAnimals() {
        return new ArrayList<Animal>(AnimalMap.getAll());
    }

    static List<Animal> getPlayersAnimals(int playerId) {
        return RancherMap.get(playerId).getAnimals();
    }

    private static void addToPlayersAnimals(int playerId, Animal animal) {
        RancherMap.get(playerId).addAnimal(animal);
    }

    private static void removeFromPlayersAnimals(int playerId, Animal animal) {
        RancherMap.get(playerId).removeAnimal(animal);
    }

    static Map<Integer, List<Animal>> getProlificAnimals(int playerId) {
        return RancherMap.get(playerId).getProlificAnimals();
    }

    static Animal newAnimal(Player player, Npc npc, String name) {
        Animal animal = AnimalMap.get(npc.getGlobalID());
        AnimalController.updatePlayerId(animal, player.getDbID());
        AnimalController.updateAnimalName(animal, name);
        AnimalController.updateOffspring(animal);
        AnimalController.updateAnimalHomeLocation(animal);
        return animal;
    }

    static void updateAnimalName(Animal animal, String name) {
        String oldName = animal.getNpcName();
        animal.setNpcName(name);
        if (!oldName.equals(animal.getNpcName())) {
            UnitOfWork.INSTANCE.registerDirty(animal);
        }
    }

    static void updatePlayerId(Animal animal, int newPlayerId) {
        int oldPlayerId = animal.getPlayerId();
        animal.setPlayerId(newPlayerId);
        animal.resetFeedCount();
        if (oldPlayerId < 0) {
            UnitOfWork.INSTANCE.registerNew(animal);
        } else {
            AnimalController.removeFromPlayersAnimals(oldPlayerId, animal);
            UnitOfWork.INSTANCE.registerDirty(animal);
        }
        if (newPlayerId < 0) {
            AnimalMap.remove(animal);
            UnitOfWork.INSTANCE.registerRemoved(animal);
        } else {
            AnimalController.addToPlayersAnimals(newPlayerId, animal);
        }
    }

    private static void updateOffspring(Animal animal) {
        if (!animal.isOffspring()) {
            animal.setOffspring();
            UnitOfWork.INSTANCE.registerDirty(animal);
        }
    }

    static void updateProlific(Animal animal, boolean prolific) {
        if (animal.isProlific() != prolific) {
            animal.setProlific(prolific);
            UnitOfWork.INSTANCE.registerDirty(animal);
            RancherMap.get(animal.getPlayerId()).removeProlificAnimal(animal);
            RancherMap.get(animal.getPlayerId()).addProlificAnimal(animal);
        }
    }

    static void updatePregnancyProgress(Animal animal, int time) {
        animal.setPregnancyProgress(time);
        UnitOfWork.INSTANCE.registerDirty(animal);
    }

    static void updateAnimalHomeLocation(Animal animal) {
        AnimalController.updateAnimalHomeLocation(animal, animal.getNpc().getPosition());
    }

    static void updateAnimalHomeLocation(Animal animal, Vector3f pos) {
        animal.setHomeLocation(pos);
        UnitOfWork.INSTANCE.registerDirty(animal);
    }

    static void updateRancherName(Player player) {
        Rancher rancher = RancherMap.get(player.getDbID());
        String oldName = rancher.getPlayerName();
        rancher.setPlayerName(player.getName());
        if (!oldName.equals(rancher.getPlayerName())) {
            UnitOfWork.INSTANCE.registerDirty(rancher);
        }
    }

    static void increaseOffspringCounter(Player player) {
        Rancher rancher = RancherMap.get(player.getDbID());
        rancher.incOffspringCounter();
        UnitOfWork.INSTANCE.registerDirty(rancher);
    }

    static void increaseRewardCounter(Player player) {
        Rancher rancher = RancherMap.get(player.getDbID());
        rancher.incRewardCounter();
        UnitOfWork.INSTANCE.registerDirty(rancher);
    }

    static Rancher getRancher(Player player) {
        return RancherMap.get(player.getDbID());
    }

    static Rancher getAnimalsOwner(Animal animal) {
        return RancherMap.get(animal.getPlayerId());
    }

    static Animal getFollowingTaggedAnimal(Player player) {
        return RancherMap.get(player.getDbID()).getFollowingTaggedAnimal();
    }

    static void setFollowingTaggedAnimal(Player player, Animal animal) {
        RancherMap.get(player.getDbID()).setFollowingTaggedAnimal(animal);
    }

    static void resetFollowingTaggedAnimal(Player player) {
        RancherMap.get(player.getDbID()).resetFollowingTaggedAnimal();
    }

    static Animal getRenameTaggedAnimal(Player player) {
        return RancherMap.get(player.getDbID()).getRenameTaggedAnimal();
    }

    static void setRenameTaggedAnimal(Player player, Animal animal) {
        RancherMap.get(player.getDbID()).setRenameTaggedAnimal(animal);
    }

    static void resetRenameTaggedAnimal(Player player) {
        RancherMap.get(player.getDbID()).resetRenameTaggedAnimal();
    }

    static int getRewardCounter(Player player) {
        return RancherMap.get(player.getDbID()).getRewardCounter();
    }

    static void decRewardCounter(Player player, int type) {
        Rancher rancher = RancherMap.get(player.getDbID());
        int counter = rancher.getRewardCounter() - AnimalType.reward(type);
        if (counter < 0) {
            counter = 0;
        }
        rancher.setRewardCounter(counter);
        UnitOfWork.INSTANCE.registerDirty(rancher);
    }
}

