/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm;

import carsten.risingworld.abm.ABMResourceBundle;
import carsten.risingworld.abm.AnimalController;
import carsten.risingworld.abm.action.Action;
import carsten.risingworld.abm.action.AnimalInteraction;
import carsten.risingworld.abm.action.FeedAction;
import carsten.risingworld.abm.action.InteractionItem;
import carsten.risingworld.abm.action.RewardAction;
import carsten.risingworld.abm.action.RewardItems;
import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalMap;
import carsten.risingworld.abm.data.AnimalType;
import carsten.risingworld.abm.event.AnimalBornEvent;
import carsten.risingworld.abm.event.AnimalFollowEvent;
import carsten.risingworld.abm.event.AnimalOwnerChangedEvent;
import carsten.risingworld.abm.event.AnimalPregnantEvent;
import carsten.risingworld.abm.event.AnimalProlificEvent;
import carsten.risingworld.abm.event.AnimalRenamedEvent;
import carsten.risingworld.abm.event.AnimalRewardEvent;
import carsten.risingworld.abm.event.AnimalSleepEvent;
import carsten.risingworld.abm.event.PlayerAnimalLimitReachedEvent;
import carsten.risingworld.abm.event.PlayerInsufficientPointsEvent;
import carsten.risingworld.abm.gui.RenameGui;
import carsten.risingworld.abm.util.FW;
import carsten.risingworld.abm.util.NumberFormats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.RayCastResult;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldElement;

public class AnimalBreedMaster
extends Plugin
implements Listener {
    private static final float VERSION = 0.71f;
    private static final String SEP = FileSystems.getDefault().getSeparator();
    private static final String ABM_PREFS = "AnimalBreedMaster.prefs";
    private static final String EXT = ".xml";
    private static final String PROP_MAX_ANIMALS = "max_animals_per_player";
    private static final String PROP_RENAMING_ACTIVE = "rename_action_active";
    private static final String PROP_INVINCIBLE_ACTIVE = "invincible_action_active";
    private static final String PROP_REWARDS_ACTIVE = "reward_system_active";
    private static final int FEED_TIMER_SCALER;
    private static final int PROGRESS_TIMER_SCALER;
    private static final int GENERAL_TIMER_SCALER;
    private static final float INTERVALL;
    private static final int COLLISIONTYPES = 249;
    private static final Map<Player, CallbackRayCastResult> playerCallbackResultMap;
    private static final int NUM_FEED_OWN = 4;
    private static final int NUM_FEED_PROLIFIC = 3;
    private static final int MIN_PREG_TIME = 6000;
    private static final int REV_PREG_TIME = 120;
    private static final int PROGRESS_INTERVAL = 6;
    private static final int GENERAL_INTERVAL = 20;
    private static final int FEED_PROGRESS_BONUS_TIME = 300;
    private static final float MIN_RUN_DISTANCE = 10.0f;
    private static final float MAX_APPROACH_DISTANCE = 4.0f;
    private final Runnable timerTask_FP = this::timerTask;
    private final Properties settings = new Properties();
    private Timer actionTimer;
    private int feedTimerLoop;
    private int progressTimerLoop;
    private int generalTimerLoop1;
    private static int maxOwnableAnimals;
    private boolean renameActionActive;
    private boolean invincibleActionActive;
    private boolean rewSysActive;

    public AnimalBreedMaster() {
        AnimalMap.setNpcFetcher(this::getNpc);
        Action.FOLLOW.setDelegate(this::tagAnimalToFollowAction);
        Action.INVINCIBLE.setDelegate(this::setAnimalInvincibleAction);
        Action.LOCKED.setDelegate(this::lockAnimalAction);
        Action.RENAME.setDelegate(this::showAnimalRenameGui);
        Action.REWARDPOINTS.setDelegate(this::showRewardPoints);
        for (FeedAction feedAction : FeedAction.values()) {
            feedAction.setDelegates(this::feedAction, this::noThanks);
        }
        for (Enum enum_ : RewardAction.values()) {
            ((RewardAction)enum_).setDelegates(this::rewardAction, this::noReward);
        }
    }

    public void onEnable() {
        this.loadSettings();
        this.initController();
        this.registerEventListener(this);
        this.toggleInvincibleAction();
        this.toggleRenameAction();
        this.toggleRewardSystem();
        if (this.actionTimer != null) {
            this.actionTimer.kill();
        }
        this.actionTimer = new Timer(INTERVALL, 1.0f, -1, this.timerTask_FP);
        this.actionTimer.start();
    }

    public void onDisable() {
        this.actionTimer.kill();
        this.unregisterEventListener(this);
        AnimalController.disable();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerConnectEvent(PlayerConnectEvent evt) {
        Player player = evt.getPlayer();
        AnimalBreedMaster.initBundle(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent evt) {
        Player player = evt.getPlayer();
        AnimalBreedMaster.removeBundle(player);
        playerCallbackResultMap.remove(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerSpawnEvent(PlayerSpawnEvent evt) {
        Player player = evt.getPlayer();
        AnimalBreedMaster.initPlayer(player);
        AnimalBreedMaster.loadAnimals(player.getDbID());
        AnimalController.updateRancherName(player);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerGuiElementClickEvent(PlayerGuiElementClickEvent evt) {
        Player player = evt.getPlayer();
        RenameGui gui = RenameGui.get(AnimalBreedMaster.getPlayerBundle(player).getLocale().getLanguage());
        if (gui.cancelButton == evt.getGuiElement()) {
            this.processCancelButton(player);
        } else if (gui.okButton == evt.getGuiElement()) {
            this.processOkButton(player);
        }
    }

    private void processOkButton(Player player) {
        RenameGui gui = RenameGui.get(AnimalBreedMaster.getPlayerBundle(player).getLocale().getLanguage());
        gui.field.getCurrentText(player, (Callback)new CallbackTextFieldResult(player));
        this.disableGuiInput(player);
    }

    private void processCancelButton(Player player) {
        this.disableGuiInput(player);
    }

    private void disableGuiInput(Player player) {
        RenameGui gui = RenameGui.get(AnimalBreedMaster.getPlayerBundle(player).getLocale().getLanguage());
        gui.removeFromPlayer(player);
        player.setMouseCursorVisible(false);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerInsufficientPointsEvent(PlayerInsufficientPointsEvent evt) {
        Player player = evt.getPlayer();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        AnimalBreedMaster.chatMessage(player, "[#ffff00]" + bundle.getVal("reward.insuff") + "[#7fff00]" + evt.getRequiredPoints() + "[#ffff00]" + bundle.getVal("reward.insuff." + evt.getAnimalName()) + bundle.getVal("reward.insuff.curr") + "[#7fff00]" + evt.getCurrentPoints() + "[#ffff00]!");
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerAnimalLimitReachedEvent(PlayerAnimalLimitReachedEvent evt) {
        Player player = evt.getPlayer();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        AnimalBreedMaster.chatMessage(player, "[#ffff00]" + evt.getMessage() + ": " + bundle.getVal("owner.limit") + " (" + AnimalBreedMaster.getMaxOwnableAnimals() + ")");
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalRenamedEvent(AnimalRenamedEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        AnimalBreedMaster.chatMessage(player, "[#7fff00]" + bundle.getVal("rename.old") + evt.getOldName() + " [#ffff00]" + bundle.getVal("rename.new") + animal.getNpcName());
        AnimalController.resetRenameTaggedAnimal(player);
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalBornEvent(AnimalBornEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.playGameSound("fireworks_start", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        AnimalBreedMaster.chatMessage(player, "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("birth.ok"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalRewardEvent(AnimalRewardEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.playGameSound("fireworks_start", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        player.playGameSound("fireworks_explosion", animal.getNpc().getPosition());
        AnimalBreedMaster.chatMessage(player, "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("reward.ok") + " [#ffff00]" + bundle.getVal("congratulations"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalProlificEvent(AnimalProlificEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        AnimalBreedMaster.chatMessage(player, "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("prolific"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalPregnantEvent(AnimalPregnantEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        AnimalBreedMaster.chatMessage(player, "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("pregnant"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalOwnerChangedEvent(AnimalOwnerChangedEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        AnimalBreedMaster.chatMessage(player, "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("owner.new"));
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalFollowEvent(AnimalFollowEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String name = AnimalBreedMaster.getNameOrDefault(player, animal);
        switch (evt.getMode()) {
            case "start": {
                AnimalBreedMaster.chatMessage(player, "[#7fff00]" + name + "[#7fff00]" + bundle.getVal("following.start"));
                break;
            }
            case "stop": {
                AnimalController.resetFollowingTaggedAnimal(player);
                Npc npc = animal.getNpc();
                Vector3f location = new Vector3f(npc.getPosition());
                npc.setAlerted(false);
                npc.moveTo(location);
                AnimalController.updateAnimalHomeLocation(animal, location);
                AnimalBreedMaster.chatMessage(player, "[#ffff00]" + name + "[#ffff00]" + bundle.getVal("following.stop"));
                break;
            }
            case "locked": {
                AnimalBreedMaster.chatMessage(player, "[#ffff00]" + name + "[#ffff00]" + bundle.getVal("animal.says") + bundle.getVal("following.locked"));
            }
        }
    }

    @EventMethod(value=Threading.Async)
    public void onAnimalSleepEvent(AnimalSleepEvent evt) {
        Player player = evt.getPlayer();
        Animal animal = evt.getAnimal();
        String name = AnimalBreedMaster.getNameOrDefault(player, animal);
        AnimalBreedMaster.chatMessage(player, "[#ffff00]" + name + "[#ffff00]: ...zzzzz zzzzz");
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerNpcInteractionEvent(PlayerNpcInteractionEvent evt) {
        Player player = evt.getPlayer();
        Npc npc = evt.getNpc();
        if (npc.getType() != Npc.Type.Animal) {
            return;
        }
        Animal animal = AnimalController.getAnimal(npc);
        this.processAction(player, animal);
    }

    private void timerTask() {
        ++this.feedTimerLoop;
        ++this.progressTimerLoop;
        if ((float)this.progressTimerLoop % ((float)PROGRESS_TIMER_SCALER / this.actionTimer.getInterval()) == 0.0f) {
            this.progressTimerLoop = 0;
        }
        ++this.generalTimerLoop1;
        if ((float)this.generalTimerLoop1 % ((float)GENERAL_TIMER_SCALER / this.actionTimer.getInterval()) == 0.0f) {
            this.generalTimerLoop1 = 0;
        }
        this.executeForEachPlayer();
        this.raycastPlayerToNpc();
        this.removeDeadAnimals();
        this.sendAnimalsHome();
    }

    private List<WorldItem> findRewardItems() {
        ArrayList<WorldItem> list = new ArrayList<WorldItem>();
        Collection items = this.getWorld().getAllItems(null);
        if (!items.isEmpty()) {
            for (WorldItem item : items) {
                if (item.isDummy() || !RewardItems.list.contains(item.getName())) continue;
                list.add(item);
            }
        }
        return list;
    }

    private void exchangeRewardItems(Player player) {
        List<WorldItem> items = this.findRewardItems();
        if (!items.isEmpty()) {
            for (WorldItem item : items) {
                this.processRewardAction(player, item);
            }
        }
    }

    private void executeForEachPlayer() {
        for (Player player : this.getServer().getAllPlayers()) {
            this.showNameAction(player, AnimalController.getFollowingTaggedAnimal(player));
            this.followPlayer(player);
            if (this.progressTimerLoop != 0) continue;
            this.procreation(player);
            this.updatePregnancyProgress(player);
            this.exchangeRewardItems(player);
        }
    }

    private void sendAnimalsHome() {
        if (this.generalTimerLoop1 != 0) {
            return;
        }
        List<Animal> list = AnimalBreedMaster.loadAllAnimals();
        for (Animal animal : list) {
            this.sendAnimalHome(animal);
        }
    }

    private void sendAnimalHome(Animal animal) {
        Vector3f targetPosition;
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (animal.getPlayerId() < 0) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            return;
        }
        Vector3f currentPosition = new Vector3f(npc.getPosition());
        float distance = currentPosition.distance(targetPosition = animal.getHomeLocation());
        if (distance > 10.0f) {
            npc.moveTo(targetPosition);
        }
        npc.setAlerted(false, 30);
    }

    private void processAction(Player player, Animal animal) {
        Item item = player.getEquippedItem();
        if (item == null) {
            return;
        }
        AnimalInteraction action = InteractionItem.getAction(item.getName());
        action.execute(player, animal);
    }

    private void tagAnimalToFollowAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        Animal taggedAnimal = AnimalController.getFollowingTaggedAnimal(player);
        if (animal.getNpc().isSleeping()) {
            this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
        } else if (taggedAnimal == Animal.NULL) {
            String mode = "locked";
            if (!animal.getNpc().isLocked()) {
                mode = "start";
                AnimalController.setFollowingTaggedAnimal(player, animal);
            }
            this.triggerEvent((Event)new AnimalFollowEvent(player, animal, mode));
        } else if (taggedAnimal == animal) {
            this.triggerEvent((Event)new AnimalFollowEvent(player, animal, "stop"));
        }
    }

    private void showRewardPoints(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("reward.p1") + "[#ffff00]" + AnimalController.getRewardCounter(player) + "[#7fff00]" + bundle.getVal("reward.p2");
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void lockAnimalAction(Player player, Animal animal) {
        Npc npc;
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        boolean isLocked = (npc = animal.getNpc()).isLocked();
        npc.setLocked(!isLocked);
        if (animal == AnimalController.getFollowingTaggedAnimal(player) && npc.isLocked()) {
            this.triggerEvent((Event)new AnimalFollowEvent(player, animal, "stop"));
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("locking." + Boolean.toString(npc.isLocked()));
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void setAnimalInvincibleAction(Player player, Animal animal) {
        Npc npc;
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        boolean isInvincible = (npc = animal.getNpc()).isInvincible();
        npc.setInvincible(!isInvincible);
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("invincible." + Boolean.toString(npc.isInvincible()));
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void showAnimalRenameGui(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        RenameGui gui = RenameGui.get(AnimalBreedMaster.getPlayerBundle(player).getLocale().getLanguage());
        gui.addToPlayer(player);
        AnimalController.setRenameTaggedAnimal(player, animal);
        gui.field.setText(AnimalBreedMaster.getNameOrDefault(player, animal));
        player.setMouseCursorVisible(true);
    }

    private void feedAction(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
            return;
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        if (this.feedTimerLoop > FEED_TIMER_SCALER) {
            this.feedTimerLoop = 0;
        }
        if (this.feedTimerLoop > 0) {
            AnimalBreedMaster.chatMessage(player, "[#ffff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("feeding.nothungry"));
            return;
        }
        ++this.feedTimerLoop;
        Inventory inv = player.getInventory();
        byte slot = inv.getQuickslotFocus();
        inv.removeItem((int)slot, Inventory.SlotType.Quickslot, 1);
        int hunger = npc.getHunger() + 5;
        if (hunger > 100) {
            hunger = 100;
        }
        npc.setHunger(hunger);
        int health = npc.getHealth() + 20;
        if (health > 200) {
            health = 200;
        }
        npc.setHealth(health);
        player.playGameSound("player_eat_carrot", npc.getPosition());
        String msg = "[#7fff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("animal.says") + bundle.getVal("feeding.yum");
        if (animal.isOwnedByPlayer(player.getDbID())) {
            msg = msg + " [#7fff00]" + bundle.getVal("feeding.thx") + player.getName() + "!";
        }
        AnimalBreedMaster.chatMessage(player, msg);
        animal.incFeedCount();
        if (!animal.isOwned()) {
            if (animal.getFeedCount() > 4) {
                this.changeOwner(player, animal);
                AnimalController.increaseRewardCounter(player);
            }
        } else if (animal.isOwnedByPlayer(player.getDbID()) && !animal.isProlific()) {
            if (!animal.isPregnant()) {
                if (animal.getFeedCount() > 3) {
                    AnimalController.updateProlific(animal, true);
                    AnimalController.increaseRewardCounter(player);
                    this.triggerEvent((Event)new AnimalProlificEvent(player, animal));
                }
            } else {
                int pregnancyProgress = animal.getPregnancyProgress() + 300;
                AnimalController.updatePregnancyProgress(animal, pregnancyProgress);
            }
        }
    }

    private void noThanks(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String msg = "[#ffff00]" + AnimalBreedMaster.getNameOrDefault(player, animal) + bundle.getVal("feeding.nothx");
        AnimalBreedMaster.chatMessage(player, msg);
    }

    private void followPlayer(Player player) {
        Animal animal = AnimalController.getFollowingTaggedAnimal(player);
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        Npc npc = animal.getNpc();
        if (npc.isSleeping()) {
            this.triggerEvent((Event)new AnimalSleepEvent(player, animal));
            this.triggerEvent((Event)new AnimalFollowEvent(player, animal, "stop"));
            return;
        }
        Vector3f currentPosition = npc.getPosition();
        AnimalController.updateAnimalHomeLocation(animal, currentPosition);
        float distance = currentPosition.distance(player.getPosition());
        Vector3f pos = new Vector3f(currentPosition).subtractLocal(player.getPosition()).normalizeLocal().multLocal(4.0f).addLocal(player.getPosition());
        npc.setAlerted(false);
        if (distance > Action.FOLLOW.getMaxDistance()) {
            npc.setPosition(pos);
        } else if (distance > 10.0f) {
            npc.setAlerted(true, 1);
            npc.moveTo(pos);
        } else if (distance > 4.0f) {
            npc.moveTo(pos);
        }
    }

    private CallbackRayCastResult getPlayerCallbackResult(Player player) {
        return playerCallbackResultMap.computeIfAbsent(player, x$0 -> new CallbackRayCastResult((Player)x$0));
    }

    private void raycastPlayerToNpc() {
        for (Player player : this.getServer().getAllPlayers()) {
            player.raycast(249, (Callback)this.getPlayerCallbackResult(player));
        }
    }

    private void removeDeadAnimals() {
        if (this.generalTimerLoop1 != 0) {
            return;
        }
        AnimalController.removeAnimalsWithoutNpc();
    }

    private void showNameAction(Player player, Animal animal) {
        World3DText text = (World3DText)player.getAttribute("abm_3d_label");
        if (text == null) {
            return;
        }
        boolean wasIdle = (Boolean)player.getAttribute("abm_raycast_idle");
        if (wasIdle) {
            player.removeWorldElement((WorldElement)text);
        }
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        AnimalBreedMaster.showLabel(player, animal, text);
    }

    private static void showLabel(Player player, Animal animal, World3DText text) {
        int fcolor;
        boolean showLabels = (Boolean)player.getAttribute("abm_show_labels");
        if (!showLabels) {
            return;
        }
        Npc npc = animal.getNpc();
        float distance = npc.getPosition().distance(player.getPosition());
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String t = AnimalBreedMaster.getNameOrDefault(player, animal);
        if (!animal.isOwned()) {
            fcolor = -65281;
            t = t + "\n(" + bundle.getVal("label.wild") + ")";
        } else if (animal.isOwnedByPlayer(player.getDbID())) {
            Animal taggedAnimal = AnimalController.getFollowingTaggedAnimal(player);
            if (animal == taggedAnimal) {
                t = t + "\n(" + bundle.getVal("label.following") + ")";
            } else {
                String res;
                ArrayList<String> labels = new ArrayList<String>();
                if (animal.isProlific()) {
                    labels.add(bundle.getVal("label.prolific"));
                } else if (animal.isPregnant()) {
                    float d = (float)((double)animal.getPregnancyProgress() * 100.0 / 6000.0);
                    labels.add(bundle.getVal("label.pregnant") + " " + NumberFormats.float2_1.format(d) + " %");
                }
                if (animal.getNpc().isLocked()) {
                    labels.add(bundle.getVal("label.leashed"));
                }
                if (animal.getNpc().isInvincible()) {
                    labels.add(bundle.getVal("label.invincible"));
                }
                if ((res = String.join((CharSequence)", ", labels)).length() > 0) {
                    t = t + "\n(" + res + ")";
                }
            }
            fcolor = 0xFF00FF;
        } else {
            fcolor = -1347420161;
            t = t + "\n[" + AnimalController.getAnimalsOwner(animal).getPlayerName() + "]";
        }
        int s = (int)((double)distance / (1.0 - 1.0 / Math.exp((double)distance / Math.E)));
        float y = 2.0f;
        Vector3f v = new Vector3f(npc.getPosition()).addLocal(0.0f, y, 0.0f);
        if (distance < 100.0f) {
            text.setFontsize(s);
            text.setFontColor(fcolor);
            text.setPosition(v);
            text.setText(t);
            player.addWorldElement((WorldElement)text);
        }
    }

    private void procreation(Player player) {
        Map<Integer, List<Animal>> prolificMap = AnimalController.getProlificAnimals(player.getDbID());
        for (int npcType : prolificMap.keySet()) {
            ArrayList list = new ArrayList(prolificMap.get(npcType));
            if (list.size() < 2) continue;
            list.sort((a1, a2) -> this.sortByDistance((Animal)a1, (Animal)a2, player));
            Animal partner1 = (Animal)list.get(0);
            AnimalController.updateProlific(partner1, false);
            AnimalController.updatePregnancyProgress(partner1, 1);
            AnimalController.increaseRewardCounter(player);
            this.triggerEvent((Event)new AnimalPregnantEvent(player, partner1));
        }
    }

    private int sortByDistance(Animal a1, Animal a2, Player player) {
        Npc n1 = a1.getNpc();
        Npc n2 = a2.getNpc();
        if (n1 == null || n2 == null) {
            return 0;
        }
        float distance1 = player.getPosition().distance(n1.getPosition());
        float distance2 = player.getPosition().distance(n2.getPosition());
        return Float.compare(distance1, distance2);
    }

    private void updatePregnancyProgress(Player player) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        Animal p = null;
        for (Animal animal : list) {
            if (AnimalController.removeAnimalIfDead(animal)) continue;
            int pregnancyProgress = animal.getPregnancyProgress();
            if (pregnancyProgress > 0) {
                pregnancyProgress += 6;
            }
            if (pregnancyProgress > 6000) {
                Npc npc = animal.getNpc();
                if (npc.isSleeping()) {
                    pregnancyProgress -= 120;
                } else {
                    pregnancyProgress = 0;
                    p = animal;
                }
            }
            AnimalController.updatePregnancyProgress(animal, pregnancyProgress);
        }
        this.giveBirth(player, p);
    }

    private void giveBirth(Player player, Animal animal) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        if (list.size() < AnimalBreedMaster.getMaxOwnableAnimals()) {
            AnimalController.updatePregnancyProgress(animal, 0);
            Npc npc = animal.getNpc();
            Vector3f pos = new Vector3f(npc.getPosition()).addLocal(npc.getViewDirection().multLocal(2.0f));
            Quaternion q = new Quaternion();
            q.lookAt(npc.getViewDirection());
            Animal newAnimal = this.spawnAnimal(player, npc.getTypeID(), pos, q);
            AnimalController.increaseOffspringCounter(player);
            AnimalController.increaseRewardCounter(player);
            this.triggerEvent((Event)new AnimalBornEvent(player, newAnimal));
            this.changeOwner(player, newAnimal);
        } else {
            AnimalController.updatePregnancyProgress(animal, 1);
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, bundle.getVal("birth.fail")));
        }
    }

    private Animal spawnAnimal(Player player, int type, Vector3f pos, Quaternion quat) {
        Npc newNpc = this.getWorld().spawnNpc((short)type, pos, quat);
        String name = AnimalBreedMaster.getDefaultName(player, newNpc);
        return AnimalController.newAnimal(player, newNpc, name);
    }

    private void noReward(Player player, WorldItem item, int type) {
        String animalName = AnimalType.name(type);
        int requiredPoints = AnimalType.reward(type);
        int currentPoints = AnimalController.getRewardCounter(player);
        this.triggerEvent((Event)new PlayerInsufficientPointsEvent(player, animalName, requiredPoints, currentPoints));
    }

    private void rewardAction(Player player, WorldItem item, int type) {
        Vector3f pos = new Vector3f(item.getPosition());
        Quaternion q = new Quaternion();
        item.destroy();
        Animal newAnimal = this.spawnAnimal(player, type, pos, q);
        AnimalController.decRewardCounter(player, type);
        this.triggerEvent((Event)new AnimalRewardEvent(player, newAnimal));
        this.changeOwner(player, newAnimal);
    }

    private void processRewardAction(Player player, WorldItem item) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        if (list.size() < AnimalBreedMaster.getMaxOwnableAnimals()) {
            RewardAction action = RewardItems.getAction(item.getName());
            action.execute(player, item);
        } else {
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, bundle.getVal("reward.fail")));
        }
    }

    private static String getNameOrDefault(Player player, Animal animal) {
        if (animal == null) {
            return "";
        }
        Npc npc = animal.getNpc();
        String name = animal.getNpcName();
        if (name.length() <= 0) {
            name = AnimalBreedMaster.getDefaultName(player, npc);
        }
        return name;
    }

    private static String getDefaultName(Player player, Npc npc) {
        if (npc == null) {
            return "";
        }
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        String name = npc.getName();
        if (name.length() <= 0) {
            name = bundle.getVal("animal." + AnimalType.name(npc.getTypeID())) + " " + npc.getGlobalID();
        }
        return name;
    }

    private static int getMaxOwnableAnimals() {
        return maxOwnableAnimals;
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerCommand(PlayerCommandEvent evt) {
        if (this.processAdminOnlyCommands(evt)) {
            return;
        }
        if (this.processUserCommands(evt)) {
            return;
        }
    }

    private boolean processAdminOnlyCommands(PlayerCommandEvent evt) {
        Player admin = evt.getPlayer();
        if (!admin.isAdmin()) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return true;
        }
        String cmd = st.nextToken();
        if (!"abm".equals(cmd)) {
            return true;
        }
        boolean ret = true;
        switch (cmd = st.nextToken()) {
            case "admin": {
                admin.sendTextMessage("processing admin commands");
                break;
            }
            case "erase": {
                if (st.countTokens() <= 0) break;
                int playerId = AnimalBreedMaster.getInteger(st.nextToken());
                AnimalController.deleteAllAnimalsFromPlayer(playerId);
                break;
            }
            case "changeowner": {
                if (st.countTokens() <= 1) break;
                int playerId1 = AnimalBreedMaster.getInteger(st.nextToken());
                int playerId2 = AnimalBreedMaster.getInteger(st.nextToken());
                this.changeOwnerAllAnimals(admin, playerId1, playerId2);
                break;
            }
            case "rename": 
            case "renaming": {
                String bool;
                if (st.countTokens() <= 0 || !(bool = st.nextToken()).matches("^true|false$")) break;
                this.settings.setProperty(PROP_RENAMING_ACTIVE, bool);
                this.saveSettings();
                this.loadSettings();
                this.toggleRenameAction();
                admin.sendTextMessage("[#ffff00]renaming set to [#7fff00]" + this.settings.getProperty(PROP_RENAMING_ACTIVE));
                break;
            }
            case "invincible": {
                String bool;
                if (st.countTokens() <= 0 || !(bool = st.nextToken()).matches("^true|false$")) break;
                this.settings.setProperty(PROP_INVINCIBLE_ACTIVE, bool);
                this.saveSettings();
                this.loadSettings();
                this.toggleInvincibleAction();
                admin.sendTextMessage("[#ffff00]invincible set to [#7fff00]" + this.settings.getProperty(PROP_INVINCIBLE_ACTIVE));
                break;
            }
            case "rewsys": {
                String bool;
                if (st.countTokens() <= 0 || !(bool = st.nextToken()).matches("^true|false$")) break;
                this.settings.setProperty(PROP_REWARDS_ACTIVE, bool);
                this.saveSettings();
                this.loadSettings();
                this.toggleRewardSystem();
                admin.sendTextMessage("[#ffff00]reward system set to [#7fff00]" + this.settings.getProperty(PROP_REWARDS_ACTIVE));
                break;
            }
            case "warpallhome": {
                this.warpAllAnimalsHome();
                break;
            }
            case "clearnames": {
                AnimalBreedMaster.clearGlobalNames(admin);
                break;
            }
            case "helpfile": {
                this.writeHelp(admin);
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private static void clearGlobalNames(Player player) {
        List<Animal> list = AnimalBreedMaster.loadAllAnimals();
        for (Animal animal : list) {
            Npc npc = animal.getNpc();
            if (npc == null) continue;
            String old = npc.getName();
            npc.setName(null);
            if (!"".equals(old)) {
                AnimalBreedMaster.chatMessage(player, "old: <" + old + "> new: <" + npc.getName() + ">");
            }
            npc.setName("");
            npc.setLocked(false);
        }
        AnimalBreedMaster.chatMessage(player, "global names cleared");
    }

    private boolean processUserCommands(PlayerCommandEvent evt) {
        Player player = evt.getPlayer();
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return true;
        }
        String cmd = st.nextToken();
        if (!"abm".equals(cmd)) {
            return true;
        }
        boolean ret = true;
        switch (cmd = st.nextToken()) {
            case "user": {
                player.sendTextMessage("processing user commands");
                break;
            }
            case "help": {
                this.printHelp(player);
                break;
            }
            case "count": {
                if (st.countTokens() <= 0) break;
                AnimalBreedMaster.countAnimals(player, st.nextToken());
                break;
            }
            case "list": {
                if (st.countTokens() <= 0) break;
                AnimalBreedMaster.listAnimals(player, st.nextToken());
                break;
            }
            case "warphome": {
                if (st.countTokens() <= 0) break;
                this.warpHomeCommand(player, st.nextToken());
                break;
            }
            case "lang": {
                if (st.countTokens() <= 0) break;
                String lang = st.nextToken();
                ABMResourceBundle bundle = (ABMResourceBundle)ABMResourceBundle.getBundle(ABMResourceBundle.class.getName(), new Locale(lang));
                AnimalBreedMaster.removeBundle(player);
                player.setAttribute("abm_bundle", (Object)bundle);
                break;
            }
            case "label": 
            case "labels": 
            case "showlabel": 
            case "showlabels": {
                String onOff;
                if (st.countTokens() <= 0 || !(onOff = st.nextToken()).matches("off|on")) break;
                player.setAttribute("abm_show_labels", (Object)"on".equals(onOff));
                break;
            }
            case "chat": 
            case "showchat": {
                String onOff;
                if (st.countTokens() <= 0 || !(onOff = st.nextToken()).matches("off|on")) break;
                player.setAttribute("abm_show_chat_msg", (Object)"on".equals(onOff));
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    private static void countAnimals(Player player, String animalType) {
        String hl = "Counting " + animalType + ":";
        String us = String.join((CharSequence)"", Collections.nCopies(hl.length(), "-"));
        player.sendTextMessage("");
        player.sendTextMessage("[#7fff00]" + hl);
        player.sendTextMessage("[#7fff00]" + us);
        List<Animal> animals = AnimalBreedMaster.loadAnimals(player.getDbID());
        if (animals.size() < 1) {
            player.sendTextMessage("[#ffff00]  No animals found.");
            return;
        }
        Map<String, List<Animal>> animalMap = AnimalBreedMaster.createAnimalMap(animals);
        if ("all".equals(animalType)) {
            Set<String> names = animalMap.keySet();
            for (String name : names) {
                player.sendTextMessage("[#ffff00]  " + name + " count: [#7fff00]" + animalMap.get(name).size());
            }
            player.sendTextMessage("[#ffff00]  total: [#7fff00]" + animals.size() + "[#ffff00] of max. [#7fff00]" + AnimalBreedMaster.getMaxOwnableAnimals());
        } else if (animalMap.containsKey(animalType)) {
            player.sendTextMessage("[#ffff00]  " + animalType + " count: [#7fff00]" + animalMap.get(animalType).size());
        } else {
            player.sendTextMessage("[#ffff00]  No animals of type [#7fff00]" + animalType + "[#ffff00] found.");
        }
    }

    private static void listAnimals(Player player, String animalType) {
        String hl = "Listing " + animalType + ":";
        String us = String.join((CharSequence)"", Collections.nCopies(hl.length(), "-"));
        player.sendTextMessage("");
        player.sendTextMessage("[#7fff00]" + hl);
        player.sendTextMessage("[#7fff00]" + us);
        List<Animal> animals = AnimalBreedMaster.loadAnimals(player.getDbID());
        if (animals.size() < 1) {
            player.sendTextMessage("[#ffff00]  No animals found.");
            return;
        }
        Map<String, List<Animal>> animalMap = AnimalBreedMaster.createAnimalMap(animals);
        if ("all".equals(animalType)) {
            Collection<List<Animal>> lists = animalMap.values();
            for (List<Animal> subList : lists) {
                AnimalBreedMaster.listAnimalsSubList(player, subList);
            }
        } else if (animalMap.containsKey(animalType)) {
            AnimalBreedMaster.listAnimalsSubList(player, animalMap.get(animalType));
        } else {
            player.sendTextMessage("[#ffff00]  No animals of type [#7fff00]" + animalType + "[#ffff00] found.");
        }
    }

    private static void listAnimalsSubList(Player player, List<Animal> list) {
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        int lfd = 1;
        for (Animal animal : list) {
            Npc npc = animal.getNpc();
            if (npc == null) continue;
            String type = AnimalType.name(AnimalType.filterNpcType(npc.getTypeID()));
            Vector3f currentPosition = npc.getPosition();
            String distance = String.format("%3.0f", Float.valueOf(currentPosition.distance(player.getPosition()) / 2.0f));
            String xPos = String.format("%4.0f", Float.valueOf(currentPosition.getX()));
            String yPos = String.format("%4.0f", Float.valueOf(currentPosition.getY()));
            String zPos = String.format("%4.0f", Float.valueOf(currentPosition.getZ()));
            player.sendTextMessage("[#ffff00]  " + type + " " + String.format("%2d", lfd) + ": ID: [#7fff00]" + animal.getNpcId() + "[#ffff00], Pos: X[#7fff00]" + xPos + "[#ffff00], Y[#7fff00]" + yPos + "[#ffff00], Z[#7fff00]" + zPos + "[#ffff00] Dist: [#7fff00]" + distance + "m[#ffff00] (" + animal.getNpcName() + ")");
            ++lfd;
        }
    }

    private static Map<String, List<Animal>> createAnimalMap(List<Animal> animals) {
        HashMap<String, List<Animal>> cntMap = new HashMap<String, List<Animal>>();
        for (Animal animal : animals) {
            Npc npc = animal.getNpc();
            if (npc == null) continue;
            String type = AnimalType.name(AnimalType.filterNpcType(npc.getTypeID()));
            cntMap.putIfAbsent(type, new ArrayList());
            cntMap.get(type).add(animal);
        }
        return cntMap;
    }

    private void listItems(Player player) {
        Collection items = this.getWorld().getAllItems(null);
        for (WorldItem item : items) {
            if (item.isDummy()) continue;
            player.sendTextMessage("item: " + item.getName() + " rel: " + item.getRelatedPlayer().getName());
            player.sendTextMessage("dist: " + item.getPosition().distance(item.getRelatedPlayer().getPosition()));
        }
    }

    private void warpHomeCommand(Player player, String token) {
        if ("all".equals(token)) {
            this.warpAllPlayerAnimalsHome(player);
            return;
        }
        int animalId = AnimalBreedMaster.getInteger(token);
        if (animalId > 0) {
            this.warpAnimalHome(player, animalId);
        }
    }

    private void warpAllPlayerAnimalsHome(Player player) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(player.getDbID());
        for (Animal animal : list) {
            this.warpAnimalHome(player, animal.getNpcId());
        }
    }

    private void warpAnimalHome(Player player, int animalId) {
        if (animalId < 1) {
            return;
        }
        Npc npc = this.getWorld().getNpc(animalId);
        if (npc == null) {
            return;
        }
        Animal animal = AnimalController.getAnimal(npc);
        if (!animal.isOwnedByPlayer(player.getDbID())) {
            return;
        }
        Vector3f targetPosition = animal.getHomeLocation();
        npc.setPosition(targetPosition);
    }

    private void warpAllAnimalsHome() {
        List<Animal> list = AnimalBreedMaster.loadAllAnimals();
        for (Animal animal : list) {
            Vector3f pos;
            Npc npc;
            if (animal.getPlayerId() < 0 || (npc = this.getWorld().getNpc(animal.getNpcId())) == null || Float.isNaN((pos = animal.getHomeLocation()).getX() + pos.getZ() + pos.getZ())) continue;
            npc.setPosition(pos);
        }
    }

    private void processDebugCommands(PlayerCommandEvent evt) {
        Player player = evt.getPlayer();
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return;
        }
        String cmd = st.nextToken();
        if (!"abm".equals(cmd)) {
            return;
        }
        switch (cmd = st.nextToken()) {
            case "debug": {
                player.sendTextMessage("processing debug commands");
                break;
            }
            case "items": {
                this.listItems(player);
                break;
            }
            case "pos": {
                this.printPosition(player);
                break;
            }
            case "procreation": {
                this.procreation(player);
                break;
            }
            case "worlditems": {
                this.exchangeRewardItems(player);
                break;
            }
            case "mouseon": {
                player.sendTextMessage("mouse cursor visible");
                player.setMouseCursorVisible(true);
                break;
            }
            case "mouseoff": {
                player.sendTextMessage("mouse cursor invisible");
                player.setMouseCursorVisible(false);
                break;
            }
        }
    }

    private void printPosition(Player player) {
        player.sendTextMessage("pos:" + player.getChunkPosition() + " " + player.getBlockPosition() + " " + player.getPosition());
    }

    private Npc getNpc(int npcId) {
        return this.getWorld().getNpc(npcId);
    }

    private static void chatMessage(Player player, String message) {
        if (!((Boolean)player.getAttribute("abm_show_chat_msg")).booleanValue()) {
            return;
        }
        player.sendTextMessage(message);
    }

    private static List<Animal> loadAllAnimals() {
        return AnimalController.getAllAnimals();
    }

    private static List<Animal> loadAnimals(int loadPlayerId) {
        return AnimalController.getPlayersAnimals(loadPlayerId);
    }

    private static int countAnimals(int playerId) {
        return AnimalBreedMaster.loadAnimals(playerId).size();
    }

    private void renameAnimal(Player player, Animal animal, String p_newName) {
        if (AnimalController.removeAnimalIfDead(animal)) {
            return;
        }
        String oldName = animal.getNpcName();
        String newName = p_newName;
        if (newName == null) {
            newName = AnimalBreedMaster.getDefaultName(player, animal.getNpc());
        }
        AnimalController.updateAnimalName(animal, newName);
        this.triggerEvent((Event)new AnimalRenamedEvent(player, animal, oldName));
    }

    private void changeOwner(Player player, Animal animal) {
        if (AnimalBreedMaster.countAnimals(player.getDbID()) < AnimalBreedMaster.getMaxOwnableAnimals()) {
            AnimalController.updatePlayerId(animal, player.getDbID());
            AnimalController.updateAnimalName(animal, AnimalBreedMaster.getNameOrDefault(player, animal));
            AnimalController.updateAnimalHomeLocation(animal);
            this.triggerEvent((Event)new AnimalOwnerChangedEvent(player, animal));
        } else {
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(player, AnimalBreedMaster.getPlayerBundle(player).getString("owner.fail")));
        }
    }

    private void changeOwnerAllAnimals(Player admin, int oldPlayerId, int newPlayerId) {
        List<Animal> list = AnimalBreedMaster.loadAnimals(oldPlayerId);
        for (Animal animal : list) {
            if (AnimalBreedMaster.countAnimals(newPlayerId) < AnimalBreedMaster.getMaxOwnableAnimals()) {
                String txt = "[#ffff00] Animal:" + animal.getNpcId() + " Old Player:" + animal.getPlayerId();
                AnimalController.updatePlayerId(animal, newPlayerId);
                admin.sendTextMessage(txt + " New Player:" + animal.getPlayerId());
                continue;
            }
            this.triggerEvent((Event)new PlayerAnimalLimitReachedEvent(admin, AnimalBreedMaster.getPlayerBundle(admin).getString("owner.fail")));
        }
    }

    private void printRewardList(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        for (String itemName : RewardItems.getItems()) {
            String actionName = RewardItems.getAction(itemName).actionName();
            int points = RewardItems.getAction(itemName).getRewardPoints();
            player.sendTextMessage("* [#ffff00]" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(actionName) + "[#7fff00]" + points + "[#ffff00]" + bundle.getVal("action.reward.rp"));
        }
    }

    private void printItemInteraction(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        for (String itemName : InteractionItem.getItems()) {
            player.sendTextMessage("* [#ffff00]" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(InteractionItem.getAction(itemName).actionName()));
        }
    }

    private void printHelp(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        player.sendTextMessage("");
        player.sendTextMessage("");
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage(bundle.getVal("help.title"));
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("* ");
        player.sendTextMessage("* " + bundle.getVal("help.descr.line1"));
        player.sendTextMessage("* " + bundle.getVal("help.descr.line2"));
        player.sendTextMessage("* ");
        player.sendTextMessage("* [#7fff00]" + bundle.getVal("help.itemlist.head"));
        this.printItemInteraction(player);
        if (this.rewSysActive) {
            player.sendTextMessage("* ");
            player.sendTextMessage("* [#7fff00]" + bundle.getVal("help.rewardlist.head1"));
            player.sendTextMessage("* [#7fff00]" + bundle.getVal("help.rewardlist.head2"));
            this.printRewardList(player);
            player.sendTextMessage("* ");
            player.sendTextMessage("* [#ffff00]" + bundle.getVal("reward.p1") + "[#7fff00]" + AnimalController.getRewardCounter(player) + "[#ffff00]" + bundle.getVal("reward.p2"));
        }
        player.sendTextMessage("* ");
        player.sendTextMessage("* " + bundle.getVal("help.readme"));
        player.sendTextMessage("*************************************************************************");
        player.sendTextMessage("");
        player.sendTextMessage("" + bundle.getVal("help.scrollinfo"));
        player.sendTextMessage("");
    }

    private void writeHelp(Player player) {
        ABMResourceBundle bundle = AnimalBreedMaster.getPlayerBundle(player);
        FW.defFilepath = this.getPath() + SEP + "help_" + bundle.getLocale().getLanguage() + ".txt";
        new File(FW.defFilepath).delete();
        FW.setWithTimestamp(false);
        FW.writeToFile("*************************************************************************");
        FW.writeToFile(bundle.getVal("help.title"));
        FW.writeToFile("*************************************************************************");
        FW.writeToFile("");
        FW.writeToFile(bundle.getVal("help.descr.line1"));
        FW.writeToFile(bundle.getVal("help.descr.line2"));
        FW.writeToFile("");
        FW.writeToFile(bundle.getVal("help.itemlist.head"));
        FW.writeToFile("***********************************");
        for (String itemName : InteractionItem.getItems()) {
            FW.writeToFile("" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(InteractionItem.getAction(itemName).actionName()));
        }
        FW.writeToFile("");
        FW.writeToFile(bundle.getVal("help.rewardlist.head1"));
        FW.writeToFile(bundle.getVal("help.rewardlist.head2"));
        FW.writeToFile("***********************************");
        for (String itemName : RewardItems.getItems()) {
            String actionName = RewardItems.getAction(itemName).actionName();
            int points = RewardItems.getAction(itemName).getRewardPoints();
            FW.writeToFile("" + bundle.getVal("item." + itemName) + ": " + bundle.getVal(actionName) + points + bundle.getVal("action.reward.rp"));
        }
        FW.setWithTimestamp(true);
        AnimalBreedMaster.chatMessage(player, "helpfile written to: " + FW.defFilepath);
    }

    private void toggleRenameAction() {
        if (this.renameActionActive) {
            InteractionItem.activateRenameAction();
        } else {
            InteractionItem.deactivateRenameAction();
        }
    }

    private void toggleInvincibleAction() {
        if (this.invincibleActionActive) {
            InteractionItem.activateInvincibleAction();
        } else {
            InteractionItem.deactivateInvincibleAction();
        }
    }

    private void toggleRewardSystem() {
        if (this.rewSysActive) {
            InteractionItem.activateRewardActions();
            RewardItems.activateRewardActions();
        } else {
            InteractionItem.deactivateRewardActions();
            RewardItems.deactivateRewardActions();
        }
    }

    private void initController() {
        AnimalController.enable(this, 0.71f);
    }

    private static ABMResourceBundle getPlayerBundle(Player player) {
        ABMResourceBundle bundle = (ABMResourceBundle)player.getAttribute("abm_bundle");
        if (bundle == null) {
            bundle = AnimalBreedMaster.initBundle(player);
        }
        return bundle;
    }

    private static ABMResourceBundle initBundle(Player player) {
        ABMResourceBundle bundle = (ABMResourceBundle)ABMResourceBundle.getBundle(ABMResourceBundle.class.getName(), new Locale(player.getLanguage()));
        player.setAttribute("abm_bundle", (Object)bundle);
        return bundle;
    }

    private static void removeBundle(Player player) {
        player.deleteAttribute("abm_bundle");
    }

    private static void initPlayer(Player player) {
        player.setAttribute("abm_3d_label", (Object)AnimalBreedMaster.createLabel());
        player.setAttribute("abm_raycast_idle", (Object)true);
        player.setAttribute("abm_show_labels", (Object)true);
        player.setAttribute("abm_show_chat_msg", (Object)true);
    }

    private static World3DText createLabel() {
        World3DText text = new World3DText("");
        text.setFontColor(0xAA00FF);
        text.setBillboard(true);
        text.setAlwaysVisible(true);
        text.setVisibleRange(100.0f);
        return text;
    }

    private static int getInteger(String str) {
        int i;
        if (str == null) {
            str = "";
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        return i;
    }

    private void loadSettings() {
        this.loadPreferences(ABM_PREFS, this.settings);
        this.checkSettings();
        this.savePreferences(ABM_PREFS, this.settings);
        maxOwnableAnimals = AnimalBreedMaster.getInteger(this.settings.getProperty(PROP_MAX_ANIMALS));
        this.renameActionActive = Boolean.parseBoolean(this.settings.getProperty(PROP_RENAMING_ACTIVE));
        this.invincibleActionActive = Boolean.parseBoolean(this.settings.getProperty(PROP_INVINCIBLE_ACTIVE));
        this.rewSysActive = Boolean.parseBoolean(this.settings.getProperty(PROP_REWARDS_ACTIVE));
    }

    private void saveSettings() {
        this.savePreferences(ABM_PREFS, this.settings);
    }

    private void checkSettings() {
        String bool;
        int i = AnimalBreedMaster.getInteger(this.settings.getProperty(PROP_MAX_ANIMALS));
        if (i < 1 || i > 1000) {
            this.settings.setProperty(PROP_MAX_ANIMALS, "50");
        }
        if (!(bool = this.settings.getProperty(PROP_INVINCIBLE_ACTIVE, "true")).matches("^true|false$")) {
            bool = "true";
        }
        this.settings.setProperty(PROP_INVINCIBLE_ACTIVE, bool);
        bool = this.settings.getProperty(PROP_RENAMING_ACTIVE, "true");
        if (!bool.matches("^true|false$")) {
            bool = "true";
        }
        this.settings.setProperty(PROP_RENAMING_ACTIVE, bool);
        bool = this.settings.getProperty(PROP_REWARDS_ACTIVE, "true");
        if (!bool.matches("^true|false$")) {
            bool = "true";
        }
        this.settings.setProperty(PROP_REWARDS_ACTIVE, bool);
    }

    private void loadPreferences(String filename, Properties props) {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filepath = path + SEP + filename + EXT;
        File file = new File(filepath);
        if (!file.exists()) {
            this.savePreferences(filename, props);
        }
        try (FileInputStream in = new FileInputStream(file);){
            props.loadFromXML(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void savePreferences(String filename, Properties props) {
        String path = this.getPath();
        if (path == null || path.length() < 1) {
            return;
        }
        String filepath = path + SEP + filename + EXT;
        File file = new File(filepath);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (FileOutputStream out = new FileOutputStream(file, false);){
            props.storeToXML((OutputStream)out, "", StandardCharsets.UTF_8.name());
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        INTERVALL = 1.0f;
        FEED_TIMER_SCALER = (int)(4.0f / INTERVALL);
        PROGRESS_TIMER_SCALER = (int)(6.0f / INTERVALL);
        GENERAL_TIMER_SCALER = (int)(20.0f / INTERVALL);
        playerCallbackResultMap = new HashMap<Player, CallbackRayCastResult>(20);
    }

    class CallbackRayCastResult
    implements Callback<RayCastResult> {
        private final Player player;

        CallbackRayCastResult(Player p_player) {
            this.player = p_player;
        }

        public void onCall(RayCastResult result) {
            if (result == null) {
                return;
            }
            if (result.getDistance() > 100.0f) {
                return;
            }
            Object collisionObject = result.getCollisionObject();
            Npc npc = null;
            if (collisionObject != null && collisionObject instanceof Npc) {
                npc = (Npc)collisionObject;
            }
            if (npc == null || npc.getType() != Npc.Type.Animal) {
                this.player.setAttribute("abm_raycast_idle", (Object)true);
                return;
            }
            Animal animal = AnimalController.getAnimal(npc);
            AnimalBreedMaster.this.showNameAction(this.player, animal);
            this.player.setAttribute("abm_raycast_idle", (Object)false);
        }
    }

    class CallbackTextFieldResult
    implements Callback<String> {
        private final Player player;

        CallbackTextFieldResult(Player p_player) {
            this.player = p_player;
        }

        public void onCall(String result) {
            if (result == null) {
                return;
            }
            AnimalBreedMaster.this.renameAnimal(this.player, AnimalController.getRenameTaggedAnimal(this.player), result);
        }
    }
}

