/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.data;

import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.Rancher;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import net.risingworld.api.Plugin;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.utils.Vector3f;

public enum AnimalDataBase {
    INSTANCE;

    private static final String SEP;
    private Plugin plugin;
    private String fileName;
    private String filePath;
    private String backupFilePath;
    private Database db;
    private Connection connection;
    private float currentVersion;
    private String currentSeed;

    public final void initDataBase(Plugin p_plugin, float p_currentVersion) {
        this.plugin = p_plugin;
        this.fileName = "abm_" + this.plugin.getWorld().getName() + ".db";
        this.filePath = this.plugin.getPath() + SEP + "data" + SEP;
        this.backupFilePath = this.filePath + "backup" + SEP;
        new File(this.backupFilePath).mkdirs();
        File dataFile = new File(this.filePath + this.fileName);
        this.db = this.plugin.getSQLiteConnection(dataFile.getAbsolutePath());
        this.connection = this.db.getConnection();
        this.currentVersion = p_currentVersion;
        this.currentSeed = this.plugin.getWorld().getSeed();
        this.createTables();
    }

    @PreDestroy
    public final void closeDataBase() {
        if (this.db == null) {
            return;
        }
        this.db.close();
    }

    private static Animal loadAnimal(ResultSet result) throws SQLException {
        int npcId = result.getInt("NpcId");
        String npcName = result.getString("npcName");
        int playerId = result.getInt("PlayerId");
        boolean offspring = result.getInt("isOffspring") == 1;
        boolean prolific = result.getInt("isProlific") == 1;
        int pregnancyProgress = result.getInt("pregnancyProgress");
        float xLoc = result.getFloat("xLoc");
        float yLoc = result.getFloat("yLoc");
        float zLoc = result.getFloat("zLoc");
        return new Animal(npcId, npcName, playerId, offspring, prolific, pregnancyProgress, xLoc, yLoc, zLoc);
    }

    public final List<Animal> selectAllAnimals() {
        ArrayList<Animal> list = new ArrayList<Animal>();
        try (PreparedStatement prep = this.connection.prepareStatement("SELECT * FROM animal WHERE 1;");){
            this.connection.setAutoCommit(true);
            ResultSet result = prep.executeQuery();
            while (result.next()) {
                list.add(AnimalDataBase.loadAnimal(result));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public final List<Animal> selectAnimalByPlayer(int playerId) {
        ArrayList<Animal> list = new ArrayList<Animal>();
        try (PreparedStatement prep = this.connection.prepareStatement("SELECT * FROM animal WHERE PlayerId=?;");){
            this.connection.setAutoCommit(true);
            prep.setInt(1, playerId);
            ResultSet result = prep.executeQuery();
            while (result.next()) {
                list.add(AnimalDataBase.loadAnimal(result));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public final Animal selectAnimalByNpc(int npcId) {
        Animal animal = Animal.NULL;
        try (PreparedStatement prep = this.connection.prepareStatement("SELECT * FROM animal WHERE NpcId=?;");){
            this.connection.setAutoCommit(true);
            prep.setInt(1, npcId);
            ResultSet result = prep.executeQuery();
            if (result.next()) {
                animal = AnimalDataBase.loadAnimal(result);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return animal;
    }

    public final void updateAnimals(List<Animal> list) {
        if (list.size() <= 0) {
            return;
        }
        try (PreparedStatement prep = this.connection.prepareStatement("UPDATE animal SET npcName=?, PlayerId=?, isOffspring=?, isProlific=?, pregnancyProgress=?, xLoc=?, yLoc=?, zLoc=? WHERE NpcId=?;");){
            this.connection.setAutoCommit(false);
            for (Animal animal : list) {
                int pi = 1;
                prep.setString(pi++, animal.getNpcName());
                prep.setInt(pi++, animal.getPlayerId());
                prep.setInt(pi++, animal.isOffspring() ? 1 : 0);
                prep.setInt(pi++, animal.isProlific() ? 1 : 0);
                prep.setInt(pi++, animal.getPregnancyProgress());
                prep.setFloat(pi++, animal.getXLocation());
                prep.setFloat(pi++, animal.getYLocation());
                prep.setFloat(pi++, animal.getZLocation());
                prep.setInt(pi++, animal.getNpcId());
                prep.addBatch();
            }
            prep.executeBatch();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void insertAnimals(List<Animal> list) {
        if (list.size() <= 0) {
            return;
        }
        try (PreparedStatement prep = this.connection.prepareStatement("INSERT OR REPLACE INTO animal (NpcId, npcName, PlayerId, isOffspring, isProlific, pregnancyProgress, xLoc, yLoc, zLoc) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);");){
            this.connection.setAutoCommit(false);
            for (Animal animal : list) {
                int pi = 1;
                prep.setInt(pi++, animal.getNpcId());
                prep.setString(pi++, animal.getNpcName());
                prep.setInt(pi++, animal.getPlayerId());
                prep.setInt(pi++, animal.isOffspring() ? 1 : 0);
                prep.setInt(pi++, animal.isProlific() ? 1 : 0);
                prep.setInt(pi++, animal.getPregnancyProgress());
                prep.setFloat(pi++, animal.getXLocation());
                prep.setFloat(pi++, animal.getYLocation());
                prep.setFloat(pi++, animal.getZLocation());
                prep.addBatch();
            }
            prep.executeBatch();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void deleteAnimals(List<Animal> list) {
        if (list.size() <= 0) {
            return;
        }
        try (PreparedStatement prep = this.connection.prepareStatement("DELETE FROM animal WHERE NpcId=?;");){
            this.connection.setAutoCommit(false);
            for (Animal animal : list) {
                prep.setInt(1, animal.getNpcId());
                prep.addBatch();
            }
            prep.executeBatch();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static Rancher loadRancher(ResultSet result) throws SQLException {
        int playerId = result.getInt("PlayerId");
        String playerName = result.getString("playerName");
        int offspringCounter = result.getInt("offspringCounter");
        int rewardCounter = result.getInt("rewardCounter");
        return new Rancher(playerId, playerName, offspringCounter, rewardCounter);
    }

    public final List<Rancher> selectRanchers() {
        ArrayList<Rancher> list = new ArrayList<Rancher>();
        try (PreparedStatement prep = this.connection.prepareStatement("SELECT * FROM rancher WHERE 1;");){
            this.connection.setAutoCommit(true);
            ResultSet result = prep.executeQuery();
            while (result.next()) {
                Rancher rancher = AnimalDataBase.loadRancher(result);
                list.add(rancher);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return list;
    }

    public final Rancher selectRancher(int playerId) {
        Rancher rancher = Rancher.NULL;
        try (PreparedStatement prep = this.connection.prepareStatement("SELECT * FROM rancher WHERE PlayerId=?;");){
            this.connection.setAutoCommit(true);
            prep.setInt(1, playerId);
            ResultSet result = prep.executeQuery();
            if (result.next()) {
                rancher = AnimalDataBase.loadRancher(result);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rancher;
    }

    public final void updateRanchers(List<Rancher> list) {
        if (list.size() <= 0) {
            return;
        }
        try (PreparedStatement prep = this.connection.prepareStatement("UPDATE rancher SET playerName=?, offspringCounter=?, rewardCounter=? WHERE PlayerId=?;");){
            this.connection.setAutoCommit(false);
            for (Rancher rancher : list) {
                int pi = 1;
                prep.setString(pi++, rancher.getPlayerName());
                prep.setInt(pi++, rancher.getOffspringCounter());
                prep.setInt(pi++, rancher.getRewardCounter());
                prep.setInt(pi++, rancher.getPlayerId());
                prep.addBatch();
            }
            prep.executeBatch();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void insertRanchers(List<Rancher> list) {
        if (list.size() <= 0) {
            return;
        }
        try (PreparedStatement prep = this.connection.prepareStatement("INSERT OR REPLACE INTO rancher (PlayerId, playerName, offspringCounter, rewardCounter) VALUES (?, ?, ?, ?);");){
            this.connection.setAutoCommit(false);
            for (Rancher rancher : list) {
                int pi = 1;
                prep.setInt(pi++, rancher.getPlayerId());
                prep.setString(pi++, rancher.getPlayerName());
                prep.setInt(pi++, rancher.getOffspringCounter());
                prep.setInt(pi++, rancher.getRewardCounter());
                prep.addBatch();
            }
            prep.executeBatch();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void deleteRanchers(List<Rancher> list) {
        if (list.size() <= 0) {
            return;
        }
        try (PreparedStatement prep = this.connection.prepareStatement("DELETE FROM rancher WHERE PlayerId=?;");){
            this.connection.setAutoCommit(false);
            for (Rancher rancher : list) {
                prep.setInt(1, rancher.getPlayerId());
                prep.addBatch();
            }
            prep.executeBatch();
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void createTables() {
        if (this.db == null) {
            return;
        }
        this.createInfoTable();
        if (!this.isSameSeed()) {
            this.db.execute("DROP TABLE `animal`;");
            this.db.execute("DROP TABLE `rancher`;");
        }
        this.createAnimalTable_V0_20();
        this.createRancherTable();
        float version = this.getCurrentVersion();
        if ((double)version <= 0.12) {
            this.createBackup();
            this.db.execute("ALTER TABLE `animal` RENAME TO `animal_old`;");
            this.createAnimalTable_V0_20();
            this.db.execute("INSERT INTO `animal` SELECT NpcId, npcName, PlayerId, isOffspring, isProlific, pregnancyProgress, 0.0 AS xLoc, 0.0 AS yLoc, 0.0 AS zLoc FROM `animal_old` WHERE 1;");
            this.db.execute("DROP TABLE `animal_old`;");
            this.saveCurrentLocations();
        }
        this.updateVersion(Float.toString(this.currentVersion));
        this.updateSeed(this.currentSeed);
    }

    private void saveCurrentLocations() {
        World world = this.plugin.getWorld();
        List<Animal> list = this.selectAllAnimals();
        for (Animal animal : list) {
            Npc npc = world.getNpc(animal.getNpcId());
            if (npc == null) continue;
            Vector3f pos = npc.getPosition();
            animal.setXLocation(pos.getX());
            animal.setYLocation(pos.getY());
            animal.setZLocation(pos.getZ());
        }
        this.updateAnimals(list);
    }

    public final void createBackup() {
        File sourceFile = new File(this.filePath + this.fileName);
        File targetFile = new File(this.backupFilePath + this.fileName);
        try {
            Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSameSeed() {
        try (ResultSet result = this.db.executeQuery("SELECT `value` FROM `rancher_info` WHERE `key`='seed';");){
            if (result.next()) {
                String seed = result.getString("value");
                boolean bl2 = seed.equals(this.currentSeed);
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException p_e) {
            p_e.printStackTrace();
            return true;
        }
    }

    private float getCurrentVersion() {
        float version = 0.0f;
        try (ResultSet result = this.db.executeQuery("SELECT `value` FROM `rancher_info` WHERE `key`='version';");){
            version = result.next() ? AnimalDataBase.getFloat(result.getString("value")) : Float.POSITIVE_INFINITY;
        }
        catch (SQLException p_e) {
            p_e.printStackTrace();
        }
        return version;
    }

    private void updateVersion(String version) {
        try (PreparedStatement prep = this.connection.prepareStatement("INSERT OR REPLACE INTO `rancher_info` (`key`, `value`) VALUES (?, ?);");){
            this.connection.setAutoCommit(true);
            int pi = 1;
            prep.setString(pi++, "version");
            prep.setString(pi++, version);
            prep.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void updateSeed(String seed) {
        try (PreparedStatement prep = this.connection.prepareStatement("INSERT OR REPLACE INTO `rancher_info` (`key`, `value`) VALUES (?, ?);");){
            this.connection.setAutoCommit(true);
            int pi = 1;
            prep.setString(pi++, "seed");
            prep.setString(pi++, seed);
            prep.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void createInfoTable() {
        this.db.execute("CREATE TABLE IF NOT EXISTS `rancher_info` (`key` TEXT NOT NULL,`value` TEXT NOT NULL,PRIMARY KEY(`key`));");
    }

    private void createAnimalTable_V0_20() {
        this.db.execute("CREATE TABLE IF NOT EXISTS `animal` (`NpcId` INTEGER NOT NULL,`npcName` TEXT NOT NULL DEFAULT '',`PlayerId` INTEGER NOT NULL,`isOffspring` TEXT NOT NULL DEFAULT 0,`isProlific` INTEGER NOT NULL DEFAULT 0,`pregnancyProgress` INTEGER NOT NULL DEFAULT 0,`xLoc` REAL NOT NULL DEFAULT 0.0,`yLoc` REAL NOT NULL DEFAULT 0.0,`zLoc` REAL NOT NULL DEFAULT 0.0,PRIMARY KEY(`NpcId`));");
    }

    private void createRancherTable() {
        this.db.execute("CREATE TABLE IF NOT EXISTS `rancher` (`PlayerId` INTEGER NOT NULL,`playerName` TEXT NOT NULL DEFAULT '',`offspringCounter` INTEGER NOT NULL DEFAULT 0,`rewardCounter` INTEGER NOT NULL DEFAULT 0,PRIMARY KEY(`PlayerId`));");
    }

    private static float getFloat(String str) {
        float f;
        if (str == null) {
            str = "";
        }
        try {
            f = Float.parseFloat(str);
        }
        catch (NumberFormatException ex) {
            f = Float.POSITIVE_INFINITY;
        }
        return f;
    }

    static {
        SEP = FileSystems.getDefault().getSeparator();
    }
}

