/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkMultiple;

public class PngChunkFDAT
extends PngChunkMultiple {
    public static final String ID = "fdAT";
    private int seqNum;
    private byte[] buffer;
    int datalen;

    public PngChunkFDAT(ImageInfo info) {
        super(ID, info);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_IDAT;
    }

    public ChunkRaw createRawChunk() {
        if (this.buffer == null) {
            throw new PngjException("not buffered");
        }
        ChunkRaw c = this.createEmptyChunk(this.datalen + 4, false);
        c.data = this.buffer;
        return c;
    }

    public void parseFromRaw(ChunkRaw chunk) {
        this.seqNum = PngHelperInternal.readInt4fromBytes(chunk.data, 0);
        this.datalen = chunk.len - 4;
        this.buffer = chunk.data;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int seqNum) {
        this.seqNum = seqNum;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    public int getDatalen() {
        return this.datalen;
    }

    public void setDatalen(int datalen) {
        this.datalen = datalen;
    }
}

