/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer;

import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngWriter;
import ch.sfu.mapviewer.MapSpecification;
import ch.sfu.mapviewer.PngSpecification;
import ch.sfu.mapviewer.SaveProgressDialog;
import ch.sfu.mapviewer.TileRowGetter;
import ch.sfu.mapviewer.maptiles.MapTilesInfo;
import ch.sfu.mapviewer.maptiles.MapTilesInfoLoader;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;

public class MapViewer {
    private MapTilesInfo tiles;
    private TileRowGetter trg;
    private MapSpecification mapSpec;
    private JLabel label;
    private BufferedImage img;
    private JFrame frame;

    public MapViewer() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle("Select RW Map directory");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) == 0) {
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
        } else {
            System.out.println("No directory selected - exiting");
            System.exit(0);
        }
        this.tiles = new MapTilesInfoLoader().loadMapTilesInfo("" + chooser.getSelectedFile());
        this.mapSpec = new MapSpecification();
        this.label = new JLabel();
        this.trg = new TileRowGetter(this.tiles);
    }

    public static void main(String[] args) {
        new MapViewer().showMap();
    }

    private void showMap() {
        System.out.println("x Min: " + this.tiles.getMinX());
        System.out.println("x Max: " + this.tiles.getMaxX());
        System.out.println("y Min: " + this.tiles.getMinY());
        System.out.println("y Max: " + this.tiles.getMaxY());
        System.out.println("Delta x: " + (this.tiles.getMaxX() - this.tiles.getMinX()));
        System.out.println("Delta y: " + (this.tiles.getMaxY() - this.tiles.getMinY()));
        System.out.println("Anzahl Tiles: " + this.tiles.getTileCount());
        this.img = this.trg.loadImages(this.mapSpec);
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(new FlowLayout());
        this.label.setIcon(new ImageIcon(this.img));
        this.frame.getContentPane().add(this.label);
        this.adjustTitle();
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(3);
        this.frame.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                PngSpecification pngSpec;
                if (e.getKeyChar() == '-') {
                    MapViewer.this.zoomOut();
                }
                if (e.getKeyChar() == '+') {
                    MapViewer.this.zoomIn();
                }
                if (e.getKeyChar() == 'w') {
                    MapViewer.this.moveUp();
                }
                if (e.getKeyChar() == 's') {
                    MapViewer.this.moveDown();
                }
                if (e.getKeyChar() == 'd') {
                    MapViewer.this.moveRight();
                }
                if (e.getKeyChar() == 'a') {
                    MapViewer.this.moveLeft();
                }
                if (e.getKeyChar() == 'p') {
                    pngSpec = MapViewer.this.mapSpec.getPngSpecification();
                    MapViewer.this.createScaledImage("Map_" + MapViewer.this.mapSpec.getX() + "_" + MapViewer.this.mapSpec.getY() + "_" + MapViewer.this.mapSpec.getZoomFactor() + ".png", pngSpec);
                }
                if (e.getKeyChar() == 'm') {
                    pngSpec = MapViewer.this.tiles.getPngSpecification();
                    MapViewer.this.createScaledImage("Map_" + MapViewer.this.mapSpec.getZoomFactor() + ".png", pngSpec);
                }
                MapViewer.this.adjustTitle();
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    protected void zoomIn() {
        if (this.mapSpec.getZoomFactor() > 1) {
            this.mapSpec.setZoomFactor(this.mapSpec.getZoomFactor() >> 1);
            this.refreshImg();
        }
    }

    protected void zoomOut() {
        if (this.mapSpec.getZoomFactor() < 16) {
            this.mapSpec.setZoomFactor(this.mapSpec.getZoomFactor() << 1);
            this.refreshImg();
        }
    }

    protected void moveUp() {
        this.mapSpec.setY(this.mapSpec.getY() + 1);
        this.img = this.trg.scrollUp(this.mapSpec, this.img);
        this.label.setIcon(new ImageIcon(this.img));
    }

    protected void moveDown() {
        this.mapSpec.setY(this.mapSpec.getY() - 1);
        this.img = this.trg.scrollDown(this.mapSpec, this.img);
        this.label.setIcon(new ImageIcon(this.img));
    }

    protected void moveLeft() {
        this.mapSpec.setX(this.mapSpec.getX() + 1);
        this.img = this.trg.moveLeft(this.mapSpec, this.img);
        this.label.setIcon(new ImageIcon(this.img));
    }

    protected void moveRight() {
        this.mapSpec.setX(this.mapSpec.getX() - 1);
        this.img = this.trg.moveRight(this.mapSpec, this.img);
        this.label.setIcon(new ImageIcon(this.img));
    }

    protected void adjustTitle() {
        this.frame.setTitle(this.mapSpec.getTitle());
    }

    protected void refreshImg() {
        this.img = this.trg.loadImages(this.mapSpec);
        this.label.setIcon(new ImageIcon(this.img));
    }

    protected void createScaledImage(final String fileName, final PngSpecification pngSpec) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingWorker<Object, Integer> worker = new SwingWorker<Object, Integer>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        ImageInfo imi = MapViewer.this.createImageInfo(pngSpec);
                        TileRowGetter trg = new TileRowGetter(MapViewer.this.tiles);
                        try {
                            PngWriter png = new PngWriter((OutputStream)new FileOutputStream(fileName), imi);
                            ImageLineInt iline = new ImageLineInt(imi);
                            int indexY = 0;
                            for (int y = pngSpec.getMaxY(); y >= pngSpec.getMinY(); --y) {
                                ++indexY;
                                BufferedImage tileLine = trg.getTilesRowImage(y, pngSpec.getMaxX(), pngSpec.getMinX(), pngSpec.getScaleFactor());
                                int[] dataBuffer = ((DataBufferInt)tileLine.getRaster().getDataBuffer()).getData();
                                for (int tileY = 0; tileY < 256 / pngSpec.getScaleFactor(); ++tileY) {
                                    int startPos = tileY * imi.cols;
                                    ImageLineHelper.setPixelsRGBA8((ImageLineInt)iline, (int[])Arrays.copyOfRange(dataBuffer, startPos, startPos + imi.cols));
                                    png.writeRow((IImageLine)iline);
                                }
                                this.setProgress(100 * indexY / pngSpec.getTilesY());
                            }
                            png.end();
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                };
                SaveProgressDialog dialog = new SaveProgressDialog(null, worker, fileName, pngSpec.getTilesY());
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
    }

    private ImageInfo createImageInfo(PngSpecification spec) {
        int tileWidth = spec.getTilesX();
        int tileHeigth = spec.getTilesY();
        int pixelWidth = tileWidth * 256 / spec.getScaleFactor();
        int pixelHeight = tileHeigth * 256 / spec.getScaleFactor();
        return new ImageInfo(pixelWidth, pixelHeight, 8, true);
    }
}

