/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer;

import ch.sfu.mapviewer.PngSpecification;

public class MapSpecification {
    private int x;
    private int y;
    private int zoomFactor;
    private int tilesX;
    private int tilesY;
    private int scaleFactor;
    private static final int TILES_X = 5;
    private static final int TILES_Y = 3;
    public static final int TILE_SIZE = 256;
    private static final int INITIAL_ZOOM = 4;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 16;

    public MapSpecification() {
        this.reset();
        this.setTilesX(5);
        this.setTilesY(3);
    }

    public void reset() {
        this.setX(8);
        this.setY(20);
        this.setZoomFactor(4);
        this.setScaleFactor(1);
    }

    public void setZoomFactor(int zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public int getTilesX() {
        return this.getZoomFactor() * this.tilesX;
    }

    public int getTilesY() {
        return this.getZoomFactor() * this.tilesY;
    }

    public int getScaledTileSize() {
        return 256 / this.getZoomFactor();
    }

    public int getMapWidth() {
        return this.tilesX << 8;
    }

    public int getMapHeight() {
        return this.tilesY << 8;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getTitle() {
        return "ZoomFactor: " + this.getZoomFactor() + " X: " + this.getX() + " Y: " + this.getY();
    }

    public void setTilesX(int tilesX) {
        this.tilesX = tilesX;
    }

    public void setTilesY(int tilesY) {
        this.tilesY = tilesY;
    }

    public int getAbsTilesY() {
        return this.tilesY;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public int getMinX() {
        return this.getX() - this.getTilesX();
    }

    public int getMinY() {
        return this.getY() - this.getTilesY();
    }

    public PngSpecification getPngSpecification() {
        return new PngSpecification(this.getMinX(), this.getX(), this.getMinY(), this.getY(), 1);
    }
}

