/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.IDatChunkWriter;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import java.util.zip.Deflater;

public class CompressorStreamDeflater
extends CompressorStream {
    protected Deflater deflater;
    protected byte[] buf1;
    protected boolean deflaterIsOwn = true;

    public CompressorStreamDeflater(IDatChunkWriter idatCw, int maxBlockLen, long totalLen, Deflater def) {
        super(idatCw, maxBlockLen, totalLen);
        this.deflater = def == null ? new Deflater() : def;
        this.deflaterIsOwn = def == null;
    }

    public CompressorStreamDeflater(IDatChunkWriter idatCw, int maxBlockLen, long totalLen) {
        this(idatCw, maxBlockLen, totalLen, null);
    }

    public CompressorStreamDeflater(IDatChunkWriter idatCw, int maxBlockLen, long totalLen, int deflaterCompLevel, int deflaterStrategy) {
        this(idatCw, maxBlockLen, totalLen, new Deflater(deflaterCompLevel));
        this.deflaterIsOwn = true;
        this.deflater.setStrategy(deflaterStrategy);
    }

    public void mywrite(byte[] data, int off, int len) {
        if (this.deflater.finished() || this.done || this.closed) {
            throw new PngjOutputException("write beyond end of stream");
        }
        this.deflater.setInput(data, off, len);
        this.bytesIn += (long)len;
        while (!this.deflater.needsInput()) {
            this.deflate();
        }
    }

    protected void deflate() {
        int n;
        int off;
        byte[] buf;
        if (this.idatChunkWriter != null) {
            buf = this.idatChunkWriter.getBuf();
            off = this.idatChunkWriter.getOffset();
            n = this.idatChunkWriter.getAvailLen();
        } else {
            if (this.buf1 == null) {
                this.buf1 = new byte[4096];
            }
            buf = this.buf1;
            off = 0;
            n = this.buf1.length;
        }
        int len = this.deflater.deflate(buf, off, n);
        if (len > 0) {
            if (this.idatChunkWriter != null) {
                this.idatChunkWriter.incrementOffset(len);
            }
            this.bytesOut += (long)len;
        }
    }

    public void done() {
        if (this.done) {
            return;
        }
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
        }
        this.done = true;
        if (this.idatChunkWriter != null) {
            this.idatChunkWriter.close();
        }
    }

    public void close() {
        this.done();
        try {
            if (this.deflaterIsOwn) {
                this.deflater.end();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
    }

    public void reset() {
        this.deflater.reset();
        super.reset();
    }
}

