/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.IDatChunkWriter;
import java.io.OutputStream;

public abstract class CompressorStream
extends OutputStream {
    protected IDatChunkWriter idatChunkWriter;
    public final int blockLen;
    public final long totalbytes;
    boolean closed = false;
    protected boolean done = false;
    protected long bytesIn = 0L;
    protected long bytesOut = 0L;
    protected int block = -1;
    private byte[] firstBytes;
    protected boolean storeFirstByte = false;

    public CompressorStream(IDatChunkWriter idatCw, int blockLen, long totalbytes) {
        this.idatChunkWriter = idatCw;
        if (blockLen < 0) {
            blockLen = 4096;
        }
        if (totalbytes < 0L) {
            totalbytes = Long.MAX_VALUE;
        }
        if (blockLen < 1 || totalbytes < 1L) {
            throw new RuntimeException(" maxBlockLen or totalLen invalid");
        }
        this.blockLen = blockLen;
        this.totalbytes = totalbytes;
    }

    public void close() {
        this.done();
        if (this.idatChunkWriter != null) {
            this.idatChunkWriter.close();
        }
        this.closed = true;
    }

    public abstract void done();

    public final void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    public final void write(byte[] data, int off, int len) {
        ++this.block;
        if (len <= this.blockLen) {
            this.mywrite(data, off, len);
            if (this.storeFirstByte && this.block < this.firstBytes.length) {
                this.firstBytes[this.block] = data[off];
            }
        } else {
            while (len > 0) {
                this.mywrite(data, off, this.blockLen);
                off += this.blockLen;
                len -= this.blockLen;
            }
        }
        if (this.bytesIn >= this.totalbytes) {
            this.done();
        }
    }

    public abstract void mywrite(byte[] var1, int var2, int var3);

    public final double getCompressionRatio() {
        return this.bytesOut == 0L ? 1.0 : (double)this.bytesOut / (double)this.bytesIn;
    }

    public final long getBytesRaw() {
        return this.bytesIn;
    }

    public final long getBytesCompressed() {
        return this.bytesOut;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDone() {
        return this.done;
    }

    public byte[] getFirstBytes() {
        return this.firstBytes;
    }

    public void setStoreFirstByte(boolean storeFirstByte, int nblocks) {
        this.storeFirstByte = storeFirstByte;
        if (this.storeFirstByte) {
            if (this.firstBytes == null || this.firstBytes.length < nblocks) {
                this.firstBytes = new byte[nblocks];
            }
        } else {
            this.firstBytes = null;
        }
    }

    public void reset() {
        this.done();
        this.bytesIn = 0L;
        this.bytesOut = 0L;
        this.block = -1;
        this.done = false;
    }

    public void write(int i) {
        this.write(new byte[]{(byte)i});
    }
}

