/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjInputException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;
import java.io.ByteArrayInputStream;

public class PngChunkIHDR
extends PngChunkSingle {
    public static final String ID = "IHDR";
    private int cols;
    private int rows;
    private int bitspc;
    private int colormodel;
    private int compmeth;
    private int filmeth;
    private int interlaced;

    public PngChunkIHDR(ImageInfo info) {
        super(ID, info);
        if (info != null) {
            this.fillFromInfo(info);
        }
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NA;
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw c = new ChunkRaw(13, ChunkHelper.b_IHDR, true);
        int offset = 0;
        PngHelperInternal.writeInt4tobytes(this.cols, c.data, offset);
        PngHelperInternal.writeInt4tobytes(this.rows, c.data, offset += 4);
        offset += 4;
        c.data[offset++] = (byte)this.bitspc;
        c.data[offset++] = (byte)this.colormodel;
        c.data[offset++] = (byte)this.compmeth;
        c.data[offset++] = (byte)this.filmeth;
        c.data[offset++] = (byte)this.interlaced;
        return c;
    }

    public void parseFromRaw(ChunkRaw c) {
        if (c.len != 13) {
            throw new PngjException("Bad IDHR len " + c.len);
        }
        ByteArrayInputStream st = c.getAsByteStream();
        this.cols = PngHelperInternal.readInt4(st);
        this.rows = PngHelperInternal.readInt4(st);
        this.bitspc = PngHelperInternal.readByte(st);
        this.colormodel = PngHelperInternal.readByte(st);
        this.compmeth = PngHelperInternal.readByte(st);
        this.filmeth = PngHelperInternal.readByte(st);
        this.interlaced = PngHelperInternal.readByte(st);
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getBitspc() {
        return this.bitspc;
    }

    public void setBitspc(int bitspc) {
        this.bitspc = bitspc;
    }

    public int getColormodel() {
        return this.colormodel;
    }

    public void setColormodel(int colormodel) {
        this.colormodel = colormodel;
    }

    public int getCompmeth() {
        return this.compmeth;
    }

    public void setCompmeth(int compmeth) {
        this.compmeth = compmeth;
    }

    public int getFilmeth() {
        return this.filmeth;
    }

    public void setFilmeth(int filmeth) {
        this.filmeth = filmeth;
    }

    public int getInterlaced() {
        return this.interlaced;
    }

    public void setInterlaced(int interlaced) {
        this.interlaced = interlaced;
    }

    public boolean isInterlaced() {
        return this.getInterlaced() == 1;
    }

    public void fillFromInfo(ImageInfo info) {
        this.setCols(this.imgInfo.cols);
        this.setRows(this.imgInfo.rows);
        this.setBitspc(this.imgInfo.bitDepth);
        int colormodel = 0;
        if (this.imgInfo.alpha) {
            colormodel += 4;
        }
        if (this.imgInfo.indexed) {
            ++colormodel;
        }
        if (!this.imgInfo.greyscale) {
            colormodel += 2;
        }
        this.setColormodel(colormodel);
        this.setCompmeth(0);
        this.setFilmeth(0);
        this.setInterlaced(0);
    }

    public ImageInfo createImageInfo() {
        this.check();
        boolean alpha = (this.getColormodel() & 4) != 0;
        boolean palette = (this.getColormodel() & 1) != 0;
        boolean grayscale = this.getColormodel() == 0 || this.getColormodel() == 4;
        return new ImageInfo(this.getCols(), this.getRows(), this.getBitspc(), alpha, grayscale, palette);
    }

    public void check() {
        if (this.cols < 1 || this.rows < 1 || this.compmeth != 0 || this.filmeth != 0) {
            throw new PngjInputException("bad IHDR: col/row/compmethod/filmethod invalid");
        }
        if (this.bitspc != 1 && this.bitspc != 2 && this.bitspc != 4 && this.bitspc != 8 && this.bitspc != 16) {
            throw new PngjInputException("bad IHDR: bitdepth invalid");
        }
        if (this.interlaced < 0 || this.interlaced > 1) {
            throw new PngjInputException("bad IHDR: interlace invalid");
        }
        switch (this.colormodel) {
            case 0: {
                break;
            }
            case 3: {
                if (this.bitspc != 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            case 2: 
            case 4: 
            case 6: {
                if (this.bitspc == 8 || this.bitspc == 16) break;
                throw new PngjInputException("bad IHDR: bitdepth invalid");
            }
            default: {
                throw new PngjInputException("bad IHDR: invalid colormodel");
            }
        }
    }
}

