/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer.maptiles;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class TileLoader {
    private int tileSize;

    public TileLoader(int tileSize) {
        this.tileSize = tileSize;
    }

    private int getTileSize() {
        return this.tileSize;
    }

    public BufferedImage loadTile(String fileName) {
        BufferedImage image = new BufferedImage(this.getTileSize(), this.getTileSize(), 2);
        byte[] buffer = new byte[1024];
        try {
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(fileName));
            while ((len = gzis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
            out.close();
            gzis.close();
            byte[] data = out.toByteArray();
            for (int py = 0; py < this.getTileSize(); ++py) {
                for (int px = 0; px < this.getTileSize(); ++px) {
                    int index = (py << 10) + (px << 2);
                    int r = 0xFF & data[index];
                    int g = 0xFF & data[index + 1];
                    int b = 0xFF & data[index + 2];
                    int a = 0xFF & data[index + 3];
                    int col = a << 24 | r << 16 | g << 8 | b;
                    image.setRGB(px, 255 - py, col);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return image;
    }
}

