/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveProgressDialog
extends JDialog {
    private static final long serialVersionUID = 20671229598334241L;
    private JLabel message;
    private JLabel subMessage;
    private JProgressBar progressBar;

    public SaveProgressDialog(Component parent, SwingWorker<Object, Integer> worker, String fileName, int rowCount) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent));
        this.setModal(true);
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(8, 8, 8, 8));
        this.message = new JLabel("Saving File " + fileName);
        this.subMessage = new JLabel("Processing row 999 of 9999");
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)this.message, gbc);
        ++gbc.gridy;
        this.add((Component)this.subMessage, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.progressBar, gbc);
        this.pack();
        this.subMessage.setText("Processing row 0 of " + rowCount);
        worker.addPropertyChangeListener(new PropertyChangeHandler(rowCount));
        switch (worker.getState()) {
            case PENDING: {
                worker.execute();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private int rowCount;

        public PropertyChangeHandler(int rowCount) {
            this.rowCount = rowCount;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("state")) {
                SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)evt.getNewValue());
                switch (state) {
                    case DONE: {
                        SaveProgressDialog.this.dispose();
                    }
                }
            } else if (evt.getPropertyName().equals("progress")) {
                int newValue = (Integer)evt.getNewValue();
                SaveProgressDialog.this.subMessage.setText("Processing row " + newValue * this.rowCount / 100 + " of " + this.rowCount);
                SaveProgressDialog.this.progressBar.setValue(newValue);
            }
        }
    }
}

