/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;

public class SaveProgressDialog
extends JDialog {
    private JLabel message;
    private JLabel subMessage;
    private JProgressBar progressBar;

    public SaveProgressDialog(Component parent, SwingWorker worker, String fileName, int rowCount) {
        super(parent == null ? null : SwingUtilities.getWindowAncestor(parent));
        this.setModal(true);
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(8, 8, 8, 8));
        this.message = new JLabel("Saving File " + fileName);
        this.subMessage = new JLabel("Processing row 1 of " + rowCount);
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)this.message, gbc);
        ++gbc.gridy;
        this.add((Component)this.subMessage, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.progressBar, gbc);
        this.pack();
        worker.addPropertyChangeListener(new PropertyChangeHandler(rowCount));
        switch (worker.getState()) {
            case PENDING: {
                worker.execute();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private int currentRow = 1;
        private int rowCount;

        public PropertyChangeHandler(int rowCount) {
            this.rowCount = rowCount;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("state")) {
                SwingWorker.StateValue state = (SwingWorker.StateValue)((Object)evt.getNewValue());
                switch (state) {
                    case DONE: {
                        SaveProgressDialog.this.dispose();
                    }
                }
            } else if (evt.getPropertyName().equals("progress")) {
                ++this.currentRow;
                SaveProgressDialog.this.subMessage.setText("Processing row " + this.currentRow + " of " + this.rowCount);
                SaveProgressDialog.this.progressBar.setValue((Integer)evt.getNewValue());
            }
        }
    }
}

