/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer.maptiles;

import ch.sfu.mapviewer.maptiles.MapTileKey;
import ch.sfu.mapviewer.maptiles.TileLoader;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class MapTilesInfo {
    private Map<MapTileKey, String> mapTiles;
    private TileLoader loader;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private String pathName;
    public static final int TILESIZE = 256;

    public MapTilesInfo(String pathName) {
        this.pathName = pathName;
        this.minX = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.mapTiles = new HashMap<MapTileKey, String>();
        this.loader = new TileLoader(256);
    }

    public void addMapTile(String fileName) {
        String[] parts = fileName.split("_");
        int xValue = Integer.parseInt(parts[1]);
        int yValue = Integer.parseInt(parts[2]);
        this.setMinX(Math.min(this.getMinX(), xValue));
        this.setMaxX(Math.max(this.getMaxX(), xValue));
        this.setMinY(Math.min(this.getMinY(), yValue));
        this.setMaxY(Math.max(this.getMaxY(), yValue));
        MapTileKey newKey = new MapTileKey(xValue, yValue);
        this.mapTiles.put(newKey, fileName);
    }

    public boolean exists(int x, int y) {
        MapTileKey searchKey = new MapTileKey(x, y);
        return this.exists(searchKey);
    }

    public String getMapTileFilename(int x, int y) {
        MapTileKey searchKey = new MapTileKey(x, y);
        return this.exists(searchKey) ? this.getPathName() + "/" + this.mapTiles.get(searchKey) : null;
    }

    public int getTileCount() {
        return this.mapTiles.size();
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    private boolean exists(MapTileKey key) {
        return this.mapTiles.containsKey(key);
    }

    private void setMinX(int minX) {
        this.minX = minX;
    }

    private void setMinY(int minY) {
        this.minY = minY;
    }

    private void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    private void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    private String getPathName() {
        return this.pathName;
    }

    public BufferedImage loadTile(int x, int y) {
        return this.loader.loadTile(this.getMapTileFilename(x, y));
    }
}

