/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer;

import ch.sfu.mapviewer.MapSpecification;
import ch.sfu.mapviewer.maptiles.MapTilesInfo;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class TileRowGetter {
    private MapTilesInfo tileInfo;

    public TileRowGetter(MapTilesInfo tileInfo) {
        this.tileInfo = tileInfo;
    }

    public BufferedImage getTilesRowImage(MapSpecification spec, int y) {
        BufferedImage bi = new BufferedImage(spec.getTilesX() * 256, 256, 2);
        int bi_XIndex = 0;
        for (int indexX = 0; indexX < spec.getTilesX(); ++indexX) {
            if (this.tileInfo.exists(spec.getX() - indexX, y)) {
                BufferedImage tile = this.tileInfo.loadTile(spec.getX() - indexX, y);
                this.copySrcIntoDstAt(tile, bi, bi_XIndex, 0);
            } else {
                for (int iy = 0; iy < 256; ++iy) {
                    for (int x = bi_XIndex; x < bi_XIndex + 256; ++x) {
                        bi.setRGB(x, iy, -1118482);
                    }
                }
            }
            bi_XIndex += 256;
        }
        return bi;
    }

    public BufferedImage loadImages(MapSpecification spec) {
        BufferedImage result = new BufferedImage(spec.getMapWidth(), spec.getMapHeight(), 2);
        BufferedImage tile = null;
        for (int indexY = 0; indexY < spec.getTilesY(); ++indexY) {
            int tileStartY = indexY * spec.getScaledTileSize();
            for (int indexX = 0; indexX < spec.getTilesX(); ++indexX) {
                if (!this.tileInfo.exists(spec.getX() - indexX, spec.getY() - indexY)) continue;
                tile = this.loadScaledTile(spec, spec.getX() - indexX, spec.getY() - indexY);
                int tileStartX = indexX * spec.getScaledTileSize();
                this.copySrcIntoDstAt(tile, result, tileStartX, tileStartY);
            }
        }
        return result;
    }

    private void copySrcIntoDstAt(BufferedImage src, BufferedImage dst, int dx, int dy) {
        int[] srcbuf = ((DataBufferInt)src.getRaster().getDataBuffer()).getData();
        int[] dstbuf = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        int width = src.getWidth();
        int height = src.getHeight();
        int dstoffs = dx + dy * dst.getWidth();
        int srcoffs = 0;
        int y = 0;
        while (y < height) {
            System.arraycopy(srcbuf, srcoffs, dstbuf, dstoffs, width);
            ++y;
            dstoffs += dst.getWidth();
            srcoffs += width;
        }
    }

    private BufferedImage loadScaledTile(MapSpecification spec, int x, int y) {
        BufferedImage image = this.tileInfo.loadTile(x, y);
        BufferedImage result = new BufferedImage(spec.getScaledTileSize(), spec.getScaledTileSize(), 2);
        AffineTransform at = new AffineTransform();
        at.scale(1.0 / (double)spec.getZoomFactor(), 1.0 / (double)spec.getZoomFactor());
        new AffineTransformOp(at, 2).filter(image, result);
        image = null;
        return result;
    }

    public BufferedImage scrollUp(MapSpecification spec, BufferedImage img) {
        int destPos = spec.getScaledTileSize() * spec.getMapWidth();
        System.arraycopy(((DataBufferInt)img.getRaster().getDataBuffer()).getData(), 0, ((DataBufferInt)img.getRaster().getDataBuffer()).getData(), destPos, (spec.getMapHeight() - spec.getScaledTileSize()) * spec.getMapWidth());
        for (int indexX = 0; indexX < spec.getTilesX(); ++indexX) {
            this.loadTileIntoImage(spec, spec.getX() - indexX, spec.getY(), img, indexX * spec.getScaledTileSize(), 0);
        }
        return img;
    }

    public BufferedImage scrollDown(MapSpecification spec, BufferedImage img) {
        int srcPos = spec.getScaledTileSize() * spec.getMapWidth();
        System.arraycopy(((DataBufferInt)img.getRaster().getDataBuffer()).getData(), srcPos, ((DataBufferInt)img.getRaster().getDataBuffer()).getData(), 0, (spec.getMapHeight() - spec.getScaledTileSize()) * spec.getMapWidth());
        for (int indexX = 0; indexX < spec.getTilesX(); ++indexX) {
            this.loadTileIntoImage(spec, spec.getX() - indexX, spec.getY() - spec.getTilesY() + 1, img, indexX * spec.getScaledTileSize(), (spec.getTilesY() - 1) * spec.getScaledTileSize());
        }
        return img;
    }

    public BufferedImage moveLeft(MapSpecification spec, BufferedImage img) {
        int lengthToCopy = spec.getMapWidth() - spec.getScaledTileSize();
        for (int y = 0; y < spec.getMapHeight(); ++y) {
            int startX = y * spec.getMapWidth();
            System.arraycopy(((DataBufferInt)img.getRaster().getDataBuffer()).getData(), startX, ((DataBufferInt)img.getRaster().getDataBuffer()).getData(), y * spec.getMapWidth() + spec.getScaledTileSize(), lengthToCopy);
        }
        for (int indexY = 0; indexY < spec.getTilesY(); ++indexY) {
            this.loadTileIntoImage(spec, spec.getX(), spec.getY() - indexY, img, 0, indexY * spec.getScaledTileSize());
        }
        return img;
    }

    public BufferedImage moveRight(MapSpecification spec, BufferedImage img) {
        int lengthToCopy = spec.getMapWidth() - spec.getScaledTileSize();
        for (int y = 0; y < spec.getMapHeight(); ++y) {
            int startX = y * spec.getMapWidth() + spec.getScaledTileSize();
            System.arraycopy(((DataBufferInt)img.getRaster().getDataBuffer()).getData(), startX, ((DataBufferInt)img.getRaster().getDataBuffer()).getData(), y * spec.getMapWidth(), lengthToCopy);
        }
        for (int indexY = 0; indexY < spec.getTilesY(); ++indexY) {
            this.loadTileIntoImage(spec, spec.getX() - spec.getTilesX() + 1, spec.getY() - indexY, img, (spec.getTilesX() - 1) * spec.getScaledTileSize(), indexY * spec.getScaledTileSize());
        }
        return img;
    }

    private void loadTileIntoImage(MapSpecification spec, int tileX, int tileY, BufferedImage img, int destStartX, int destStartY) {
        if (this.tileInfo.exists(tileX, tileY)) {
            BufferedImage tile = this.loadScaledTile(spec, tileX, tileY);
            this.copySrcIntoDstAt(tile, img, destStartX, destStartY);
            tile = null;
        } else {
            for (int y = destStartY; y < destStartY + spec.getScaledTileSize(); ++y) {
                for (int x = destStartX; x < destStartX + spec.getScaledTileSize(); ++x) {
                    img.setRGB(x, y, -1118482);
                }
            }
        }
    }
}

