/*
 * Decompiled with CFR 0.152.
 */
package ch.sfu.mapviewer;

public class MapSpecification {
    private int x;
    private int y;
    private int zoomFactor;
    private static final int TILES_X = 5;
    private static final int TILES_Y = 3;
    public static final int TILE_SIZE = 256;
    private static final int INITIAL_ZOOM = 4;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 16;

    public MapSpecification() {
        this.reset();
    }

    public void reset() {
        this.setX(8);
        this.setY(20);
        this.setZoomFactor(4);
    }

    public void setZoomFactor(int zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public int getTilesX() {
        return this.getZoomFactor() * 5;
    }

    public int getTilesY() {
        return this.getZoomFactor() * 3;
    }

    public int getScaledTileSize() {
        return 256 / this.getZoomFactor();
    }

    public int getMapWidth() {
        return 1280;
    }

    public int getMapHeight() {
        return 768;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getTitle() {
        return "ZoomFactor: " + this.getZoomFactor() + " X: " + this.getX() + " Y: " + this.getY();
    }
}

