/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.DeflatedChunksSet;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjInputException;

public class DeflatedChunkReader
extends ChunkReader {
    protected final DeflatedChunksSet deflatedChunksSet;
    protected boolean alsoBuffer = false;
    protected boolean skipBytes = false;
    protected byte[] skippedBytes;
    protected int seqNumExpected = -1;

    public DeflatedChunkReader(int clen, String chunkid, boolean checkCrc, long offsetInPng, DeflatedChunksSet iDatSet) {
        super(clen, chunkid, offsetInPng, ChunkReader.ChunkReaderMode.PROCESS);
        this.deflatedChunksSet = iDatSet;
        if (chunkid.equals("fdAT")) {
            this.skipBytes = true;
            this.skippedBytes = new byte[4];
        }
        iDatSet.appendNewChunk(this);
    }

    protected void processData(int offsetInchunk, byte[] buf, int off, int len) {
        if (this.skipBytes && offsetInchunk < 4) {
            int oc = offsetInchunk;
            while (oc < 4 && len > 0) {
                this.skippedBytes[oc] = buf[off];
                ++oc;
                ++off;
                --len;
            }
        }
        if (len > 0) {
            this.deflatedChunksSet.processBytes(buf, off, len);
            if (this.alsoBuffer) {
                System.arraycopy(buf, off, this.getChunkRaw().data, this.read, len);
            }
        }
    }

    protected void chunkDone() {
        int seqNum;
        if (this.skipBytes && this.getChunkRaw().id.equals("fdAT") && this.seqNumExpected >= 0 && (seqNum = PngHelperInternal.readInt4fromBytes(this.skippedBytes, 0)) != this.seqNumExpected) {
            throw new PngjInputException("bad chunk sequence for fDAT chunk " + seqNum + " expected " + this.seqNumExpected);
        }
    }

    public boolean isFromDeflatedSet() {
        return true;
    }

    public void setAlsoBuffer() {
        if (this.read > 0) {
            throw new RuntimeException("too late");
        }
        this.alsoBuffer = true;
        this.getChunkRaw().allocData();
    }

    public void setSeqNumExpected(int seqNumExpected) {
        this.seqNumExpected = seqNumExpected;
    }
}

