-- Global variables
properties = getProperty("config.properties");

radius = 0;
center = nil;

function onEnable()
	print("WorldBorder script started!");
	center = StringUtils:stringToVector2f(properties:getProperty("center"));
	radius = properties:getProperty("radius");
	print(center.x .. " " .. center.y);
end


function onDisable()
	print("WorldBorder script stopped!");
end


function onPlayerChangePosition(event)
	local playerPos = event.player:getPosition();
	print(AreaUtils:getDistanceBetweenPoints2D(center.x, center.y, playerPos.x, playerPos.z));
	if(AreaUtils:getDistanceBetweenPoints2D(center.x, center.y, playerPos.x, playerPos.z) > radius) then 
		event:setCancel(true);
	end
end
addEvent("PlayerChangePosition", onPlayerChangePosition);