/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.teleport;

import de.galveston01.teleport.Teleport;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class ListGui
implements Listener {
    public Teleport plugin;
    public Player player;
    public GuiPanel panel;
    public GuiLabel[] labels;
    public GuiLabel[] labelsid;
    public Vector3f[] lpos;
    public GuiLabel lnext;
    public GuiLabel llast;
    public GuiLabel lX;
    public int page;

    public ListGui(Teleport plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.initGui();
        this.showGui();
    }

    public void initGui() {
        this.panel = new GuiPanel(0.5f, 0.5f, true, 0.8f, 0.8f, true);
        this.panel.setPivot(PivotPosition.Center);
        this.panel.setColor(170);
        this.labels = new GuiLabel[20];
        this.labelsid = new GuiLabel[20];
        this.lpos = new Vector3f[20];
        for (int i = 0; i < 20; ++i) {
            GuiLabel l = new GuiLabel(0.1f + 0.8f * (float)(i / 10 + 1) / 3.0f, 0.75f - (float)(i % 10) * 0.05f, true);
            l.setPivot(PivotPosition.Center);
            l.setClickable(true);
            GuiLabel lid = new GuiLabel(0.1f + 0.8f * (float)(i / 10 + 1) / 3.0f - 0.1f, 0.75f - (float)(i % 10) * 0.05f, true);
            lid.setPivot(PivotPosition.Center);
            lid.setClickable(false);
            if (i < this.plugin.portPoints.size()) {
                l.setText(this.plugin.portPoints.get((int)i).name);
                this.lpos[i] = this.plugin.portPoints.get((int)i).position;
                lid.setText(this.page * 20 + i + ")");
            } else {
                l.setText(" ");
                lid.setText(" ");
            }
            this.labels[i] = l;
            this.labelsid[i] = lid;
        }
        this.llast = new GuiLabel(0.2f, 0.22f, true);
        this.llast.setPivot(PivotPosition.Center);
        this.llast.setFontColor(-16776961);
        this.llast.setText("<-PREVIOUS");
        this.llast.setClickable(true);
        this.lnext = new GuiLabel(0.8f, 0.22f, true);
        this.lnext.setPivot(PivotPosition.Center);
        this.lnext.setFontColor(-16776961);
        this.lnext.setText("NEXT->");
        this.lnext.setClickable(true);
        this.lX = new GuiLabel(0.85f, 0.85f, true);
        this.lX.setPivot(PivotPosition.Center);
        this.lX.setFontSize(35);
        this.lX.setFontColor(-16776961);
        this.lX.setText("[X]");
        this.lX.setClickable(true);
    }

    public void showGui() {
        this.plugin.registerEventListener(this);
        this.player.setMouseCursorVisible(true);
        this.player.disableClientsideKeys(new int[]{1});
        this.player.setListenForKeyInput(true);
        this.player.addGuiElement((GuiElement)this.panel);
        int i = 0;
        for (GuiLabel l : this.labels) {
            if (!l.getText().equals(" ")) {
                this.player.addGuiElement((GuiElement)l);
                this.player.addGuiElement((GuiElement)this.labelsid[i]);
            }
            ++i;
        }
        this.player.addGuiElement((GuiElement)this.llast);
        this.player.addGuiElement((GuiElement)this.lnext);
        this.player.addGuiElement((GuiElement)this.lX);
    }

    public void disableGui() {
        this.plugin.unregisterEventListener(this);
        this.player.setMouseCursorVisible(false);
        this.player.enableClientsideKeys(new int[]{1});
        if (this.plugin.cnf.listenforkeyinputfalse) {
            this.player.setListenForKeyInput(false);
        }
        this.player.removeGuiElement((GuiElement)this.panel);
        int i = 0;
        for (GuiLabel l : this.labels) {
            if (!l.getText().equals(" ")) {
                this.player.removeGuiElement((GuiElement)l);
                this.player.removeGuiElement((GuiElement)this.labelsid[i]);
            }
            ++i;
        }
        this.player.removeGuiElement((GuiElement)this.llast);
        this.player.removeGuiElement((GuiElement)this.lnext);
        this.player.removeGuiElement((GuiElement)this.lX);
    }

    public void updatePage() {
        for (int i = 0; i < 20; ++i) {
            if (this.page * 20 + i < this.plugin.portPoints.size()) {
                this.labels[i].setText(this.plugin.portPoints.get((int)(this.page * 20 + i)).name);
                this.lpos[i] = this.plugin.portPoints.get((int)(this.page * 20 + i)).position;
                this.labelsid[i].setText(this.page * 20 + i + ")");
                continue;
            }
            this.labels[i].setText(" ");
            this.lpos[i] = null;
            this.labelsid[i].setText(" ");
        }
    }

    @EventMethod
    public void onPlayerKey(PlayerKeyEvent evt) {
        if (evt.getPlayer() == this.player && evt.getKeyCode() == 1) {
            this.disableGui();
        }
    }

    @EventMethod
    public void onPlayerGuiElementClick(PlayerGuiElementClickEvent evt) {
        if (evt.getPlayer() == this.player) {
            int i = 0;
            if (this.lX == evt.getGuiElement()) {
                this.disableGui();
            }
            if (this.llast == evt.getGuiElement()) {
                --this.page;
                if (this.page < 0) {
                    this.page = 0;
                }
                this.updatePage();
            } else if (this.lnext == evt.getGuiElement()) {
                ++this.page;
                if (this.page > this.plugin.portPoints.size() / 20) {
                    this.page = this.plugin.portPoints.size() / 20;
                }
                this.updatePage();
            } else {
                for (GuiLabel l : this.labels) {
                    if (evt.getGuiElement() == l) {
                        if ((this.plugin.cnf.onlyadmin || this.plugin.cnf.onlyadmin_to_port || this.plugin.cnf.onlyadmin_topoint_port) && !evt.getPlayer().isAdmin()) {
                            evt.getPlayer().sendTextMessage("[#ff0000]ERROR! ONLY ADMINS ARE ALLOWED TO DO THIS!");
                            return;
                        }
                        this.player.setPosition(this.lpos[i]);
                        evt.getPlayer().sendTextMessage("[#00ff00]TELEPORTED TO '" + l.getText() + "'!");
                    }
                    ++i;
                }
            }
        }
    }
}

