/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap.gui;

import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiGroup;
import org.miwarre.ap.gui.GuiSearchBox;

public class GuiScrollList
extends GuiGroup {
    private static final int SELECTED_ID_NONE = -1;
    private GuiLabel[] guiItems;
    private GuiImage buttonNext;
    private GuiImage buttonPrev;
    private int firstItem;
    private final boolean fixedHeight;
    private final List<GuiDefs.Pair<String, GuiDefs.Pair<Integer, Object>>> items;
    private int itemsWidth;
    private final int maxNumOfShownItems;
    private int numOfItems;
    private int numOfShownItems;
    private GuiSearchBox searchBox;
    private int selectedItemId;
    private int shown;

    public GuiScrollList(int maxSize, boolean fixedHeight) {
        if (maxSize < 0) {
            this.searchBox = new GuiSearchBox(0);
            this.addChild((GuiElement)this.searchBox);
            this.searchBox.setVisible(true);
            maxSize = -maxSize;
        } else {
            this.searchBox = null;
        }
        this.maxNumOfShownItems = maxSize;
        this.firstItem = 0;
        this.fixedHeight = fixedHeight;
        this.guiItems = new GuiLabel[this.maxNumOfShownItems];
        this.items = new ArrayList<GuiDefs.Pair<String, GuiDefs.Pair<Integer, Object>>>();
        this.itemsWidth = 0;
        this.numOfItems = 0;
        this.selectedItemId = -1;
        this.shown = 0;
        this.setPivot(PivotPosition.TopLeft);
        this.setColor(0x202020FF);
        this.setVisible(true);
        this.buttonNext = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        GuiDefs.setImage(this.buttonNext, 0);
        this.buttonNext.setPivot(PivotPosition.BottomRight);
        this.buttonNext.setClickable(true);
        this.buttonNext.setVisible(false);
        this.addChild((GuiElement)this.buttonNext);
        this.buttonPrev = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        GuiDefs.setImage(this.buttonPrev, 3);
        this.buttonPrev.setPivot(PivotPosition.TopRight);
        this.buttonPrev.setClickable(true);
        this.buttonPrev.setVisible(false);
        this.addChild((GuiElement)this.buttonPrev);
    }

    @Override
    public void addChild(GuiElement element, Integer id, Object data) {
    }

    public GuiLabel selectItem(int id) {
        GuiLabel label = (GuiLabel)this.getChildFromId(this.selectedItemId);
        if (label != null) {
            label.setFontColor(-1);
        }
        this.selectedItemId = id;
        label = (GuiLabel)this.getChildFromId(this.selectedItemId);
        if (label != null) {
            label.setFontColor(0xB0FFFF);
        }
        return label;
    }

    @Override
    public GuiLabel addTextItem(String text, Integer id, Object data) {
        GuiDefs.Pair<String, GuiDefs.Pair<Integer, Object>> item = new GuiDefs.Pair<String, GuiDefs.Pair<Integer, Object>>(text, new GuiDefs.Pair<Integer, Object>(id, data));
        this.items.add(item);
        int textWidth = (int)GuiDefs.getTextWidth(text, 15.0f);
        if (textWidth > this.itemsWidth) {
            this.itemsWidth = textWidth;
        }
        if (this.numOfItems < this.maxNumOfShownItems) {
            this.guiItems[this.numOfItems] = new GuiLabel(0.0f, 0.0f, false);
            this.guiItems[this.numOfItems].setPivot(PivotPosition.TopLeft);
            this.guiItems[this.numOfItems].setFontSize(15);
            this.guiItems[this.numOfItems].setClickable(true);
            this.addChild((GuiElement)this.guiItems[this.numOfItems]);
            ++this.numOfShownItems;
        }
        ++this.numOfItems;
        if (this.shown > 0) {
            this.layout((int)this.getWidth(), (int)this.getHeight());
        }
        return null;
    }

    public void removeTextItem(int id) {
        int index = 0;
        for (GuiDefs.Pair<String, GuiDefs.Pair<Integer, Object>> item : this.items) {
            if (item != null && item.getR().getL() == id) {
                this.items.remove(index);
                if (this.numOfItems < this.maxNumOfShownItems) {
                    --this.numOfShownItems;
                    this.guiItems[this.numOfItems - 1].setText("");
                }
                --this.numOfItems;
                if (this.shown > 0) {
                    this.layout((int)this.getWidth(), (int)this.getHeight());
                }
                return;
            }
            ++index;
        }
    }

    public void clear(Player player) {
        this.items.clear();
        for (int i = 0; i < this.guiItems.length; ++i) {
            if (this.guiItems[i] != null) {
                player.removeGuiElement((GuiElement)this.guiItems[i]);
                this.removeChild((GuiElement)this.guiItems[i]);
            }
            this.guiItems[i] = null;
        }
        this.itemsWidth = 0;
        this.firstItem = 0;
        this.numOfShownItems = 0;
        this.numOfItems = 0;
        this.selectedItemId = -1;
        this.buttonNext.setVisible(false);
        this.buttonPrev.setVisible(false);
    }

    @Override
    public Integer getItemId(GuiElement element) {
        Integer id;
        if (this.searchBox != null && (id = this.searchBox.getItemId(element)) != null) {
            return id;
        }
        GuiDefs.Pair<Integer, Object> itemData = this.getItemData(element);
        if (itemData == null) {
            return null;
        }
        return itemData.getL();
    }

    @Override
    public GuiDefs.Pair<Integer, Object> getItemData(GuiElement element) {
        GuiDefs.Pair<Integer, Object> data;
        if (this.searchBox != null && (data = this.searchBox.getItemData(element)) != null) {
            return data;
        }
        if (element == this.buttonPrev) {
            this.scrollUp();
            return new GuiDefs.Pair<Integer, Object>(-3, null);
        }
        if (element == this.buttonNext) {
            this.scrollDown();
            return new GuiDefs.Pair<Integer, Object>(-3, null);
        }
        int count = 0;
        for (GuiLabel guiItem : this.guiItems) {
            if (guiItem == null) continue;
            if (guiItem == element) {
                return this.items.get(count + this.firstItem).getR();
            }
            ++count;
        }
        return null;
    }

    @Override
    public GuiElement getChildFromId(int id) {
        int from = this.firstItem;
        int to = this.firstItem + this.numOfShownItems - 1;
        if (this.firstItem >= this.items.size()) {
            return null;
        }
        if (to >= this.items.size()) {
            to = this.items.size() - 1;
        }
        for (int i = from; i <= to; ++i) {
            if (this.items.get(i) == null || this.items.get(i).getR().getL() != id) continue;
            return this.guiItems[i - this.firstItem];
        }
        return null;
    }

    public void setItemText(int id, String newText) {
        for (GuiDefs.Pair<String, GuiDefs.Pair<Integer, Object>> item : this.items) {
            if (item == null || item.getR().getL() != id) continue;
            item.setL(newText);
            return;
        }
    }

    @Override
    public void layout(int minWidth, int minHeight) {
        int finalW;
        int searchH;
        int finalH = (this.fixedHeight ? this.maxNumOfShownItems : this.numOfShownItems) * (15 + this.padding) - this.padding + this.margin * 2 + (searchH = this.searchBox != null ? (int)this.searchBox.getHeight() + 6 : 0);
        if (minHeight > finalH) {
            finalH = minHeight;
        }
        if (minWidth > (finalW = this.itemsWidth + this.padding + 18 + this.margin * 2)) {
            finalW = minWidth;
        }
        this.setSize(finalW, finalH, false);
        if (this.searchBox != null) {
            this.searchBox.setPosition(finalW - this.margin, finalH - this.margin, false);
        }
        this.buttonPrev.setPosition((float)(finalW - this.margin), (float)(finalH - this.margin - searchH), false);
        this.buttonNext.setPosition((float)(finalW - this.margin), (float)this.margin, false);
        int i = 0;
        int y = finalH - this.margin - searchH;
        while (i < this.numOfShownItems) {
            this.guiItems[i].setPosition((float)this.margin, (float)y, false);
            ++i;
            y -= 15 + this.margin;
        }
        this.updateTexts();
    }

    @Override
    public void show(Player player) {
        player.addGuiElement((GuiElement)this);
        if (this.searchBox != null) {
            this.searchBox.show(player);
        }
        player.addGuiElement((GuiElement)this.buttonPrev);
        player.addGuiElement((GuiElement)this.buttonNext);
        for (GuiLabel element : this.guiItems) {
            if (element == null) continue;
            player.addGuiElement((GuiElement)element);
        }
        ++this.shown;
    }

    @Override
    public void hide(Player player) {
        player.removeGuiElement((GuiElement)this);
        for (GuiLabel element : this.guiItems) {
            if (element == null) continue;
            player.removeGuiElement((GuiElement)element);
        }
        player.removeGuiElement((GuiElement)this.buttonNext);
        player.removeGuiElement((GuiElement)this.buttonPrev);
        if (this.searchBox != null) {
            this.searchBox.hide(player);
        }
        --this.shown;
        if (this.shown < 0) {
            this.shown = 0;
        }
    }

    @Override
    public void free() {
        if (this.searchBox != null) {
            super.removeChild((GuiElement)this.searchBox);
        }
        this.searchBox = null;
        super.removeChild((GuiElement)this.buttonNext);
        this.buttonNext = null;
        super.removeChild((GuiElement)this.buttonPrev);
        this.buttonPrev = null;
        for (GuiLabel element : this.guiItems) {
            if (element == null) continue;
            if (element instanceof GuiGroup) {
                ((GuiGroup)element).free();
            }
            super.removeChild((GuiElement)element);
        }
        this.guiItems = null;
        this.items.clear();
    }

    private void scrollDown() {
        this.firstItem += this.maxNumOfShownItems - 1;
        if (this.firstItem + this.maxNumOfShownItems > this.numOfItems) {
            this.firstItem = this.numOfItems - this.maxNumOfShownItems;
        }
        this.updateTexts();
    }

    private void scrollUp() {
        this.firstItem -= this.maxNumOfShownItems - 1;
        if (this.firstItem < 0) {
            this.firstItem = 0;
        }
        this.updateTexts();
    }

    private void updateArrows() {
        this.buttonPrev.setVisible(this.firstItem > 0);
        this.buttonNext.setVisible(this.firstItem + this.maxNumOfShownItems < this.numOfItems);
    }

    private void updateTexts() {
        for (int i = 0; i < this.numOfShownItems; ++i) {
            GuiDefs.Pair<String, GuiDefs.Pair<Integer, Object>> item = this.items.get(this.firstItem + i);
            this.guiItems[i].setText(item.getL());
            Integer id = item.getR().getL();
            if (id == null) continue;
            this.guiItems[i].setFontColor(id == this.selectedItemId ? 0xB0FFFF : -1);
        }
        this.updateArrows();
    }
}

