/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap.gui;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.events.player.gui.PlayerGuiInputEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiGroup;
import org.miwarre.ap.gui.GuiGroupStatic;
import org.miwarre.ap.gui.GuiScrollList;
import org.miwarre.ap.gui.GuiTitleBar;

public class GuiModalWindow
extends GuiPanel
implements Listener {
    GuiDefs.GuiCallback _callback;
    GuiGroup _panel;
    boolean inText;
    int listenerRef;
    GuiModalWindow prevWindow;
    Plugin plugin;
    GuiTitleBar titleBar;

    public GuiModalWindow(Plugin plugin, String title, int groupType, int typeParam, GuiDefs.GuiCallback callback) {
        this.setPosition(0.5f, 0.5f, true);
        this.setPivot(PivotPosition.Center);
        this.setBorderColor(-1869573889);
        this.setBorderThickness(2.0f, false);
        this.setColor(0x202020FF);
        this._callback = callback;
        this.plugin = plugin;
        this.inText = false;
        switch (groupType) {
            case 0: {
                this._panel = new GuiGroupStatic(0);
                break;
            }
            case 1: {
                this._panel = new GuiScrollList(typeParam, false);
                break;
            }
            default: {
                this._panel = null;
            }
        }
        if (this._panel != null) {
            this._panel.setMargin(6);
            this._panel.setPivot(PivotPosition.BottomLeft);
            this._panel.setPosition(0.0f, 0.0f, false);
            super.addChild((GuiElement)this._panel);
        }
        this.titleBar = new GuiTitleBar((GuiElement)this, title, true);
        super.addChild((GuiElement)this.titleBar);
        this.listenerRef = 0;
    }

    @EventMethod
    public void onClick(PlayerGuiElementClickEvent event) {
        int id;
        if (this._callback == null) {
            return;
        }
        GuiElement element = event.getGuiElement();
        Player player = event.getPlayer();
        if (this.titleBar.isCancelButton(element)) {
            this.pop(player);
            this._callback.onCall(player, -1, null);
            return;
        }
        GuiDefs.Pair<Integer, Object> data = this._panel.getItemData(element);
        if (data != null && (id = data.getL().intValue()) > -3) {
            Object obj;
            if (element instanceof GuiTextField) {
                this.inText = true;
                obj = null;
            } else {
                if (this.inText) {
                    return;
                }
                obj = data.getR();
            }
            this._callback.onCall(player, id, obj);
        }
    }

    @EventMethod
    public void onTextEntry(PlayerGuiInputEvent event) {
        if (this._callback == null) {
            return;
        }
        Integer id = this._panel.getItemId(event.getGuiElement());
        if (id != null) {
            this.inText = false;
            this._callback.onCall(event.getPlayer(), id, event.getInput());
        }
    }

    public void setPanel(GuiGroup panel) {
        this._panel = panel;
        this._panel.setPivot(PivotPosition.BottomLeft);
        this._panel.setPosition(0.0f, 0.0f, false);
        super.addChild((GuiElement)this._panel);
    }

    public GuiGroup getPanel() {
        return this._panel;
    }

    public void setPanelSize(int width, int height) {
        this._panel.setSize(width, height, false);
    }

    public void setCallback(GuiDefs.GuiCallback callback) {
        this._callback = callback;
    }

    public void setMargin(int value) {
        this._panel.setMargin(value);
    }

    public void setPadding(int value) {
        this._panel.setPadding(value);
    }

    public int getTitleBarMinWidth() {
        return this.titleBar.getMinWidth();
    }

    public void layout() {
        int tbw = this.titleBar.getMinWidth();
        this._panel.layout(tbw, 0);
        int height = (int)this._panel.getHeight();
        int width = (int)this._panel.getWidth();
        int borderW = (int)this.getBorderThickness();
        this._panel.setPosition(borderW, borderW, false);
        this.setSize(width + borderW * 2, (height += (int)this.titleBar.getHeight()) + borderW * 2, false);
        this.titleBar.relayout();
    }

    public GuiLabel addTextItem(String text, Integer id, Object data) {
        return this._panel.addTextItem(text, id, data);
    }

    public void addChild(GuiElement element, Integer id, Object data) {
        this._panel.addChild(element, id, data);
    }

    public void show(Player player) {
        this.layout();
        this.titleBar.show(player);
        this._panel.show(player);
        ++this.listenerRef;
        if (this.listenerRef == 1) {
            this.plugin.registerEventListener((Listener)this);
        }
        player.addGuiElement((GuiElement)this);
        player.setMouseCursorVisible(true);
    }

    public void hide(Player player) {
        if (this.titleBar != null) {
            this.titleBar.hide(player);
        }
        if (this._panel != null) {
            this._panel.hide(player);
        }
        player.removeGuiElement((GuiElement)this);
        --this.listenerRef;
        if (this.listenerRef <= 0) {
            this.plugin.unregisterEventListener((Listener)this);
        }
        player.setMouseCursorVisible(false);
    }

    public void push(Player player, GuiModalWindow win) {
        this.hide(player);
        win.prevWindow = this;
        win.show(player);
    }

    public void pop(Player player) {
        this.hide(player);
        this.free();
        if (this.prevWindow != null) {
            this.prevWindow.show(player);
            player.setMouseCursorVisible(true);
        } else {
            player.setMouseCursorVisible(false);
        }
    }

    public void poppush(Player player, GuiModalWindow win) {
        this.hide(player);
        this.free();
        if (this.prevWindow != null) {
            this.prevWindow.prevWindow = win;
        }
        win.show(player);
        player.setMouseCursorVisible(true);
    }

    public Integer getItemId(GuiElement element) {
        return this._panel.getItemId(element);
    }

    public GuiElement getChildFromId(int id) {
        return this._panel.getChildFromId(id);
    }

    public void free() {
        if (this.titleBar != null) {
            this.titleBar.free();
            this.titleBar = null;
        }
        if (this._panel != null) {
            this._panel.free();
            this._panel = null;
        }
    }
}

