/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.util.Map;
import java.util.TreeMap;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.WorldArea;
import org.miwarre.ap.Db;

public class ProtArea
extends Area {
    int id;
    Map<Integer, Long> groups;
    String name;
    long permissions;
    Map<Integer, Long> players;
    WorldArea worldArea;

    public ProtArea(Vector3f fromF, Vector3f toF) {
        super(fromF, toF);
        this.initPlayers();
    }

    public ProtArea(int id, int fromX, int fromY, int fromZ, int toX, int toY, int toZ, String name, long permissions) {
        super(new Vector3f((float)fromX, (float)fromY, (float)fromZ), new Vector3f((float)toX, (float)toY, (float)toZ));
        this.id = id;
        this.name = name;
        this.permissions = permissions;
        this.initPlayers();
    }

    public ProtArea(Vector3f fromF, Vector3f toF, String name, long permissions) {
        super(fromF, toF);
        this.name = name;
        this.permissions = permissions;
        this.initPlayers();
    }

    public Extent getExtent() {
        return new Extent(this);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getPermissions() {
        return this.permissions;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setPermissions(long newPermissions) {
        this.permissions = newPermissions;
    }

    private void initPlayers() {
        if (this.id != 0) {
            this.players = Db.getAllPlayerPermissionsForArea(this.id, 1);
            this.groups = Db.getAllPlayerPermissionsForArea(this.id, 2);
        } else {
            this.players = new TreeMap<Integer, Long>();
            this.groups = new TreeMap<Integer, Long>();
        }
    }

    public class Extent {
        int minX;
        int maxX;
        int minY;
        int maxY;
        int minZ;
        int maxZ;

        public Extent(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
            this.minY = minY;
            this.maxY = maxY;
            this.rearrange();
        }

        public Extent(Area area) {
            area.rearrange();
            Vector3f from = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getStartChunkPosition(), (Vector3i)area.getStartBlockPosition());
            Vector3f to = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getEndChunkPosition(), (Vector3i)area.getEndBlockPosition());
            this.minX = (int)from.x;
            this.maxX = (int)to.x;
            this.minY = (int)from.y;
            this.maxY = (int)to.y;
            this.minZ = (int)from.z;
            this.maxZ = (int)to.z;
            this.rearrange();
        }

        public Vector3f getFrom() {
            return new Vector3f((float)this.minX, (float)this.minY, (float)this.minZ);
        }

        public Vector3f getTo() {
            return new Vector3f((float)this.maxX, (float)this.maxY, (float)this.maxZ);
        }

        public int getMinX() {
            return this.minX;
        }

        public int getMaxX() {
            return this.maxX;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public int getMinZ() {
            return this.minZ;
        }

        public int getMaxZ() {
            return this.maxZ;
        }

        public void setMinX(int val) {
            this.minX = val;
            this.rearrange();
        }

        public void setMaxX(int val) {
            this.maxX = val;
            this.rearrange();
        }

        public void setMinY(int val) {
            this.minY = val;
            this.rearrange();
        }

        public void setMaxY(int val) {
            this.maxY = val;
            this.rearrange();
        }

        public void setMinZ(int val) {
            this.minZ = val;
            this.rearrange();
        }

        public void setMaxZ(int val) {
            this.maxZ = val;
            this.rearrange();
        }

        private void rearrange() {
            int temp;
            if (this.minX > this.maxX) {
                temp = this.minX;
                this.minX = this.maxX;
                this.maxX = temp;
            }
            if (this.minY > this.maxY) {
                temp = this.minY;
                this.minY = this.maxY;
                this.maxY = temp;
            }
            if (this.minZ > this.maxZ) {
                temp = this.minZ;
                this.minZ = this.maxZ;
                this.maxZ = temp;
            }
        }
    }
}

