/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.util.Map;
import java.util.Set;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Db;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.ProtArea;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiGroupStatic;
import org.miwarre.ap.gui.GuiModalWindow;
import org.miwarre.ap.gui.GuiScrollList;

class GuiTwoListsSelector
extends GuiModalWindow {
    public static final int DOBUTTON_ID = 2000000;
    public static final int MIN_PRESET_ID = 1000001;
    private final ProtArea area;
    private final GuiDefs.GuiCallback callerCallback;
    private GuiLabel doButton;
    GuiScrollList list1;
    GuiScrollList list2;
    private final TwoListPanel panel;
    private Integer selId1;
    private Integer selId2;
    private String selText1;
    private String selText2;
    private final int type;

    public GuiTwoListsSelector(Plugin plugin, String title, GuiDefs.GuiCallback callback, ProtArea area, int maxLines, int type) {
        super(plugin, title, -1, 0, null);
        this.setCallback(new DlgHandler());
        this.callerCallback = callback;
        this.selId2 = null;
        this.selId1 = null;
        this.selText1 = "";
        this.selText2 = "";
        this.area = area;
        this.type = type;
        this.panel = new TwoListPanel(maxLines, type);
        this.setPanel(this.panel);
    }

    String getSelectedItemText(boolean list1) {
        String selected;
        String string = selected = list1 ? this.selText1 : this.selText2;
        if (selected != null && selected.length() > 0) {
            return selected;
        }
        return null;
    }

    Integer getSelectedItemId(boolean list1) {
        Integer selected = list1 ? this.selId1 : this.selId2;
        return selected;
    }

    private void updateDoButton() {
        boolean complete = this.selText1.length() > 0 && (this.selText2.length() > 0 || this.type == 3);
        this.doButton.setColor(complete ? 6344959 : 0x404040FF);
        this.doButton.setClickable(complete);
    }

    private void fillPlayerList(String filter) {
        if (filter != null && filter.length() > 1) {
            if (this.type == 2) {
                for (Map.Entry<Integer, String> entry : Db.groupNames.entrySet()) {
                    String groupName;
                    int groupId = entry.getKey();
                    if (this.area.groups.containsKey(groupId) || !(groupName = entry.getValue()).contains(filter)) continue;
                    this.list1.addTextItem(groupName, groupId, groupName);
                }
            } else {
                Set<Integer> playerIds = Db.getPlayerIdSet();
                for (Integer id : playerIds) {
                    String name;
                    if (this.area.players.containsKey(id) || !(name = Db.getPlayerNameFromId(id, this.type)).contains(filter)) continue;
                    this.list1.addTextItem(name, id, name);
                }
            }
        } else if (this.type == 2) {
            for (Map.Entry<Integer, String> entry : Db.groupNames.entrySet()) {
                int groupId = entry.getKey();
                if (this.area.groups.containsKey(groupId)) continue;
                String groupName = entry.getValue();
                this.list1.addTextItem(groupName, groupId, groupName);
            }
        } else {
            Set<Integer> playerIds = Db.getPlayerIdSet();
            for (Integer id : playerIds) {
                if (this.area.players.containsKey(id)) continue;
                String name = Db.getPlayerNameFromId(id, this.type);
                this.list1.addTextItem(name, id, name);
            }
        }
    }

    class TwoListPanel
    extends GuiGroupStatic {
        GuiLabel list1Head;
        GuiLabel list2Head;

        public TwoListPanel(int maxLines, int type) {
            super(0);
            this.setMargin(6);
            this.list1Head = this.addTextItem(Msgs.msg[type == 2 ? 73 : 72], null, null);
            this.list2Head = this.addTextItem(type == 3 ? "" : Msgs.msg[74], null, null);
            GuiTwoListsSelector.this.list1 = new GuiScrollList(-maxLines, true);
            this.addChild((GuiElement)GuiTwoListsSelector.this.list1, null, null);
            GuiTwoListsSelector.this.list1.setBorderThickness(1.0f, false);
            GuiTwoListsSelector.this.list1.setMargin(6);
            GuiTwoListsSelector.this.fillPlayerList(null);
            GuiTwoListsSelector.this.list2 = new GuiScrollList(maxLines, true);
            this.addChild((GuiElement)GuiTwoListsSelector.this.list2, null, null);
            GuiTwoListsSelector.this.list2.setBorderThickness(1.0f, false);
            GuiTwoListsSelector.this.list2.setMargin(6);
            int presetId = 1000001;
            if (type == 3) {
                GuiTwoListsSelector.this.selId2 = 1000001;
                GuiTwoListsSelector.this.selText2 = "Admin";
                GuiTwoListsSelector.this.list2.setVisible(false);
            } else {
                for (Map.Entry<String, Long> entry : AreaProtection.presets.entrySet()) {
                    GuiTwoListsSelector.this.list2.addTextItem(entry.getKey(), presetId, entry.getKey());
                    ++presetId;
                }
            }
            GuiTwoListsSelector.this.doButton = this.addTextItem(Msgs.msg[65], 2000000, null);
            GuiTwoListsSelector.this.doButton.setPivot(PivotPosition.Center);
            GuiTwoListsSelector.this.doButton.setColor(0x404040FF);
            GuiTwoListsSelector.this.doButton.setClickable(false);
        }

        @Override
        public void layout(int minWidth, int minHeight) {
            int height;
            int margin = this.getMargin();
            int padding = this.getPadding();
            GuiTwoListsSelector.this.list1.layout(minWidth, minHeight);
            GuiTwoListsSelector.this.list2.layout(minWidth, minHeight);
            int width = (int)(GuiTwoListsSelector.this.list1.getWidth() + GuiTwoListsSelector.this.list2.getWidth()) + 2 * margin;
            if (minWidth > width) {
                width = minWidth;
            }
            if (minHeight > (height = (int)GuiTwoListsSelector.this.list1.getHeight() + 60 + 2 * padding + 2 * margin)) {
                height = minHeight;
            }
            this.setSize(width, height, false);
            int list1X = margin;
            int list2X = margin + (int)GuiTwoListsSelector.this.list1.getWidth() + padding;
            this.list1Head.setPosition((float)list1X, (float)(height -= margin), false);
            this.list2Head.setPosition((float)list2X, (float)height, false);
            GuiTwoListsSelector.this.list1.setPosition(list1X, height -= 15 + padding, false);
            GuiTwoListsSelector.this.list2.setPosition(list2X, height, false);
            height = (int)((float)height - (GuiTwoListsSelector.this.list1.getHeight() + (float)padding + 22.0f));
            GuiTwoListsSelector.this.doButton.setPosition((float)(width / 2), (float)height, false);
        }
    }

    private class DlgHandler
    implements GuiDefs.GuiCallback {
        private DlgHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object data) {
            if (id == -2) {
                if (data != null && ((String)data).length() > 1) {
                    GuiTwoListsSelector.this.list1.hide(player);
                    GuiTwoListsSelector.this.list1.clear(player);
                    GuiTwoListsSelector.this.fillPlayerList((String)data);
                    GuiTwoListsSelector.this.layout();
                    GuiTwoListsSelector.this.list1.show(player);
                }
                return;
            }
            if (id >= 1 && id < 1000001) {
                GuiTwoListsSelector.this.selId1 = id;
                GuiTwoListsSelector.this.selText1 = (String)data;
                GuiTwoListsSelector.this.list1.selectItem(id);
                GuiTwoListsSelector.this.updateDoButton();
                return;
            }
            if (id >= 1000001 && id < 2000000) {
                GuiTwoListsSelector.this.selId2 = id;
                GuiTwoListsSelector.this.selText2 = (String)data;
                GuiTwoListsSelector.this.list2.selectItem(id);
                GuiTwoListsSelector.this.updateDoButton();
                return;
            }
            if (id == 2000000) {
                GuiTwoListsSelector.this.callerCallback.onCall(player, 0, null);
            }
        }
    }
}

