/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.util.Map;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Db;
import org.miwarre.ap.GuiAreaPlayerEdit;
import org.miwarre.ap.GuiTwoListsSelector;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.ProtArea;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiGroupStatic;
import org.miwarre.ap.gui.GuiModalWindow;
import org.miwarre.ap.gui.GuiScrollList;

class GuiPlayersEdit
extends GuiModalWindow {
    private static final int MAX_NUM_OF_ROWS = 10;
    private static final int UNKNOWN_ID = -1;
    private static final int MAX_PLAYER_DBID = 1000000;
    private static final int ADDBUTT_ID = 1000001;
    private static final int EDITBUTT_ID = 1000002;
    private static final int DELETEBUTT_ID = 1000003;
    private final ProtArea area;
    private int selPlayerIdx;
    private String selPlayerName;
    private GuiLabel addButt;
    private GuiLabel nameLabel;
    private GuiLabel deleteButt;
    private GuiLabel editButt;
    private GuiAreaPlayerEdit playerEditor;
    private GuiScrollList playerList;
    private GuiTwoListsSelector playerSelector;
    private final int type;

    public GuiPlayersEdit(ProtArea area, int type) {
        super(AreaProtection.plugin, Msgs.msg[type == 2 ? 59 : 58], -1, 0, null);
        this.setCallback(new DlgHandler());
        this.area = area;
        this.type = type;
        this.selPlayerIdx = -1;
        this.selPlayerName = null;
        this.setPanel(new PlayersEditPanel(area.name));
    }

    private void updateButtons() {
        boolean hasSelected = this.selPlayerIdx != -1 && this.selPlayerName != null;
        this.editButt.setColor(hasSelected ? 6344959 : 0x404040FF);
        this.editButt.setClickable(hasSelected);
        this.deleteButt.setColor(hasSelected ? 6344959 : 0x404040FF);
        this.deleteButt.setClickable(hasSelected);
    }

    class PlayersEditPanel
    extends GuiGroupStatic {
        public PlayersEditPanel(String areaName) {
            super(0);
            this.setMargin(6);
            GuiPlayersEdit.this.nameLabel = this.addTextItem(areaName, null, null);
            GuiPlayersEdit.this.playerList = new GuiScrollList(10, true);
            this.addChild((GuiElement)GuiPlayersEdit.this.playerList, null, null);
            GuiPlayersEdit.this.playerList.setBorderThickness(1.0f, false);
            GuiPlayersEdit.this.playerList.setMargin(6);
            for (Map.Entry<Integer, Long> entry : (GuiPlayersEdit.this.type == 2 ? ((GuiPlayersEdit)GuiPlayersEdit.this).area.groups : ((GuiPlayersEdit)GuiPlayersEdit.this).area.players).entrySet()) {
                int playerId = entry.getKey();
                String playerName = Db.getPlayerNameFromId(playerId, GuiPlayersEdit.this.type);
                if (playerName == null) continue;
                String txt = playerName;
                if (GuiPlayersEdit.this.type != 3) {
                    txt = txt + " (" + AreaProtection.getPresetNameFromPermissions(entry.getValue()) + ")";
                }
                GuiPlayersEdit.this.playerList.addTextItem(txt, playerId, playerName);
            }
            GuiPlayersEdit.this.addButt = this.addTextItem(Msgs.msg[65], 1000001, null);
            GuiPlayersEdit.this.addButt.setPivot(PivotPosition.Center);
            GuiPlayersEdit.this.addButt.setColor(6344959);
            GuiPlayersEdit.this.editButt = this.addTextItem(Msgs.msg[67], 1000002, null);
            GuiPlayersEdit.this.editButt.setPivot(PivotPosition.Center);
            GuiPlayersEdit.this.editButt.setColor(0x404040FF);
            if (GuiPlayersEdit.this.type == 3) {
                GuiPlayersEdit.this.editButt.setVisible(false);
            }
            GuiPlayersEdit.this.deleteButt = this.addTextItem(Msgs.msg[66], 1000003, null);
            GuiPlayersEdit.this.deleteButt.setPivot(PivotPosition.Center);
            GuiPlayersEdit.this.deleteButt.setColor(0x404040FF);
        }

        @Override
        public void layout(int minWidth, int minHeight) {
            int height;
            GuiPlayersEdit.this.playerList.layout(minWidth, minHeight);
            int margin = this.getMargin();
            int padding = this.getPadding();
            int width = (int)(GuiPlayersEdit.this.playerList.getWidth() + (float)(2 * margin));
            if (minWidth > width) {
                width = minWidth;
            }
            if (minHeight > (height = 2 * margin + (int)GuiPlayersEdit.this.playerList.getHeight() + 60 + 18)) {
                height = minHeight;
            }
            this.setSize(width, height, false);
            GuiPlayersEdit.this.nameLabel.setPosition((float)margin, (float)(height -= margin), false);
            GuiPlayersEdit.this.playerList.setPosition(margin, height -= margin + 15 + padding, false);
            height = (int)((float)height - (GuiPlayersEdit.this.playerList.getHeight() + (float)padding + 22.0f));
            GuiPlayersEdit.this.addButt.setPosition((float)(width / 4), (float)height, false);
            GuiPlayersEdit.this.editButt.setPosition((float)(width / 2), (float)height, false);
            GuiPlayersEdit.this.deleteButt.setPosition((float)(width / 4 * 3), (float)height, false);
        }
    }

    private class PlayerHandler
    implements GuiDefs.GuiCallback {
        private PlayerHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object permPlayerId) {
            if (id == 0 && GuiPlayersEdit.this.playerEditor != null) {
                long permissions = GuiPlayersEdit.this.playerEditor.getPermissions();
                if (!((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue()) {
                    permissions &= Long.MAX_VALUE;
                }
                Db.addPlayerToArea(GuiPlayersEdit.this.area, (Integer)permPlayerId, permissions, GuiPlayersEdit.this.type);
                String txt = GuiPlayersEdit.this.playerEditor.getPlayerName() + " (" + AreaProtection.getPresetNameFromPermissions(permissions) + ")";
                GuiPlayersEdit.this.playerList.setItemText(GuiPlayersEdit.this.selPlayerIdx, txt);
                GuiPlayersEdit.this.playerEditor.pop(player);
                GuiPlayersEdit.this.playerEditor = null;
            }
        }
    }

    private class SelectorHandler
    implements GuiDefs.GuiCallback {
        private SelectorHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object name) {
            if (id == 0 && GuiPlayersEdit.this.playerSelector != null) {
                String presetName;
                String playerName = GuiPlayersEdit.this.playerSelector.getSelectedItemText(true);
                Integer playerId = GuiPlayersEdit.this.playerSelector.getSelectedItemId(true);
                String string = presetName = GuiPlayersEdit.this.type == 3 ? "" : GuiPlayersEdit.this.playerSelector.getSelectedItemText(false);
                if (playerId != null && presetName != null) {
                    Long permissions;
                    Long l = permissions = GuiPlayersEdit.this.type == 3 ? Long.valueOf(Long.MAX_VALUE) : AreaProtection.presets.get(presetName);
                    if (!((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue()) {
                        permissions = permissions & Long.MAX_VALUE;
                    }
                    Db.addPlayerToArea(GuiPlayersEdit.this.area, playerId, permissions, GuiPlayersEdit.this.type);
                    String txt = playerName;
                    if (GuiPlayersEdit.this.type != 3) {
                        txt = txt + " (" + presetName + ")";
                    }
                    GuiPlayersEdit.this.playerList.addTextItem(txt, playerId, playerName);
                    GuiPlayersEdit.this.playerSelector.pop(player);
                    GuiPlayersEdit.this.playerSelector = null;
                    GuiPlayersEdit.this.updateButtons();
                }
            }
        }
    }

    private class DlgHandler
    implements GuiDefs.GuiCallback {
        private DlgHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object data) {
            if (id >= 1 && id <= 1000000) {
                GuiPlayersEdit.this.selPlayerIdx = id;
                GuiPlayersEdit.this.selPlayerName = (String)data;
                GuiPlayersEdit.this.playerList.selectItem(GuiPlayersEdit.this.selPlayerIdx);
                GuiPlayersEdit.this.updateButtons();
                return;
            }
            switch (id) {
                case 1000001: {
                    GuiPlayersEdit.this.playerSelector = new GuiTwoListsSelector(AreaProtection.plugin, Msgs.msg[GuiPlayersEdit.this.type == 2 ? 73 : 72], new SelectorHandler(), GuiPlayersEdit.this.area, 10, GuiPlayersEdit.this.type);
                    GuiPlayersEdit.this.push(player, GuiPlayersEdit.this.playerSelector);
                    break;
                }
                case 1000002: {
                    if (GuiPlayersEdit.this.selPlayerIdx == -1 || GuiPlayersEdit.this.selPlayerName == null) break;
                    GuiPlayersEdit.this.playerEditor = new GuiAreaPlayerEdit(player, GuiPlayersEdit.this.area, GuiPlayersEdit.this.selPlayerIdx, GuiPlayersEdit.this.selPlayerName, GuiPlayersEdit.this.type, new PlayerHandler());
                    GuiPlayersEdit.this.push(player, GuiPlayersEdit.this.playerEditor);
                    break;
                }
                case 1000003: {
                    if (GuiPlayersEdit.this.selPlayerIdx != -1 && GuiPlayersEdit.this.selPlayerName != null) {
                        Db.removePlayerFromArea(GuiPlayersEdit.this.area, GuiPlayersEdit.this.selPlayerIdx, GuiPlayersEdit.this.type);
                        GuiPlayersEdit.this.playerList.removeTextItem(GuiPlayersEdit.this.selPlayerIdx);
                        GuiPlayersEdit.this.selPlayerIdx = -1;
                    }
                    GuiPlayersEdit.this.updateButtons();
                }
            }
        }
    }
}

