/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.util.Map;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Db;
import org.miwarre.ap.GuiAreaEdit;
import org.miwarre.ap.GuiAreaList;
import org.miwarre.ap.GuiPlayersEdit;
import org.miwarre.ap.ListenerPlayer;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.NewAreaCreation;
import org.miwarre.ap.ProtArea;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiMenu;
import org.miwarre.ap.gui.GuiMessageBox;

class GuiMainMenu
extends GuiMenu {
    static final int MENU_SHOWAREAS_ID = 1;
    static final int MENU_EDITAREA_ID = 2;
    static final int MENU_NEWAREA_ID = 3;
    static final int MENU_GOTOAREA_ID = 4;
    static final int MENU_DELETEAREA_ID = 5;
    static final int MENU_CHESTACCESS_ID = 6;
    static final int MENU_AREAMANAGERS_ID = 7;
    static final int MENU_ADMINSACCESS_ID = 8;

    public GuiMainMenu(Player player) {
        super(AreaProtection.plugin, Msgs.msg[0], null);
        this.setCallback(new MenuHandler());
        this.addTextItem(Msgs.msg[(Boolean)player.getAttribute("com.mwr.apShown") != false ? 2 : 1], 1, null);
        this.addTextItem(Msgs.msg[5], 2, null);
        if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue() || !AreaProtection.adminOnly) {
            this.addTextItem(Msgs.msg[3], 3, null);
            this.addTextItem(Msgs.msg[4], 4, null);
            this.addTextItem(Msgs.msg[6], 5, null);
            if (player.isAdmin()) {
                this.addTextItem(Msgs.msg[8], 7, null);
                this.addTextItem(Msgs.msg[AreaProtection.adminNoPriv ? 10 : 9], 8, null);
            }
        }
    }

    private class GotoListHandler
    implements GuiDefs.GuiCallback {
        private GotoListHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object obj) {
            if (id != -1) {
                Db.movePlayerToArea(player, (ProtArea)((Object)obj));
            }
        }
    }

    private class DeleteConfirmHandler
    implements GuiDefs.GuiCallback {
        private DeleteConfirmHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object obj) {
            if (id == 0) {
                Db.deleteArea((ProtArea)((Object)obj));
            }
        }
    }

    private class DeleteListHandler
    implements GuiDefs.GuiCallback {
        private DeleteListHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object obj) {
            GuiMainMenu.this.push(player, new GuiMessageBox(AreaProtection.plugin, Msgs.msg[6], new String[]{Msgs.msg[80], ((ProtArea)((Object)obj)).getName()}, new String[]{Msgs.msg[66], Msgs.msg[68]}, obj, new DeleteConfirmHandler()));
        }
    }

    private class EditListHandler
    implements GuiDefs.GuiCallback {
        private EditListHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object obj) {
            if (id != -1) {
                GuiMainMenu.this.push(player, new GuiAreaEdit(null, (ProtArea)((Object)obj), player, 1));
            }
        }
    }

    private class MenuHandler
    implements GuiDefs.GuiCallback {
        private MenuHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object obj) {
            switch (id) {
                case 1: {
                    boolean show = AreaProtection.togglePlayerAreas(player);
                    GuiLabel menuItem = (GuiLabel)GuiMainMenu.this.getChildFromId(1);
                    if (menuItem == null) break;
                    menuItem.setText(Msgs.msg[show ? 2 : 1]);
                    break;
                }
                case 3: {
                    GuiMainMenu.this.pop(player);
                    NewAreaCreation nac = new NewAreaCreation(player);
                    nac.setPriority(3);
                    nac.start();
                    break;
                }
                case 4: {
                    GuiMainMenu.this.push(player, new GuiAreaList(player, false, (GuiDefs.GuiCallback)new GotoListHandler()));
                    break;
                }
                case 2: {
                    Map areas = (Map)player.getAttribute("com.mwr.apInAreas");
                    if (areas != null && !areas.isEmpty()) {
                        ProtArea area = Db.getAreaFromId((Integer)areas.keySet().toArray()[0]);
                        GuiMainMenu.this.push(player, new GuiAreaEdit(null, area, player, 1));
                        break;
                    }
                    GuiMainMenu.this.push(player, new GuiAreaList(player, true, (GuiDefs.GuiCallback)new EditListHandler()));
                    break;
                }
                case 5: {
                    GuiMainMenu.this.push(player, new GuiAreaList(player, true, (GuiDefs.GuiCallback)new DeleteListHandler()));
                    break;
                }
                case 7: {
                    ProtArea area = new ProtArea(-1, 0, 0, 0, 0, 0, 0, Msgs.msg[8], 0L);
                    GuiMainMenu.this.push(player, new GuiPlayersEdit(area, 3));
                    break;
                }
                case 8: {
                    ListenerPlayer.flipAdminPriv();
                    GuiLabel menuItem = (GuiLabel)GuiMainMenu.this.getChildFromId(8);
                    if (menuItem == null) break;
                    menuItem.setText(Msgs.msg[AreaProtection.adminNoPriv ? 10 : 9]);
                }
            }
        }
    }
}

